# 画面設計書 148-商品編集

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「商品編集」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、既存の商品情報を編集するためのフォーム画面です。商品の基本情報、在庫追跡設定、物流情報の変更に加えて、在庫数量の更新機能も提供します。

**業務上の目的・背景**：商品マスタの更新は、価格改定、商品情報の修正、在庫追跡設定の変更など様々な場面で必要となります。特に在庫管理モジュールでは、在庫追跡対象商品の数量を直接更新できる「数量更新」機能が追加されており、棚卸や在庫調整などの業務を効率的に行えます。

**画面へのアクセス方法**：
- 商品一覧画面 → 行アクションの編集を選択
- 商品詳細画面 → サブナビゲーションの編集タブを選択

**主要な操作・処理内容**：
1. 現在の商品情報の表示（既存値のロード）
2. 商品の基本情報の編集
3. 在庫追跡設定の変更
4. 物流情報の変更
5. 数量更新機能（在庫追跡対象商品のみ）
6. 保存ボタン押下によるレコード更新
7. 削除ボタン押下によるレコード削除

**画面遷移**：
- 遷移元：商品一覧画面、商品詳細画面
- 遷移先：商品詳細画面（保存成功後）、商品一覧画面（削除成功後）、数量管理画面（条件付き）

**権限による表示制御**：特になし（在庫管理モジュールへのアクセス権限に依存）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-020 | 在庫商品管理 | 主機能 | 商品編集・数量更新 |
| FN-PRD-003 | 商品編集 | 補助機能 | 基底商品フォームの継承 |
| FN-INV-021 | 数量管理 | 補助機能 | 在庫数量の直接更新 |

## 画面種別

編集

## URL/ルーティング

`/inventories/products/products/{record}/edit`

## 画面構成

- サブナビゲーション（Top位置）
  - 詳細表示タブ
  - 編集タブ（現在地）
  - 属性タブ
  - バリエーションタブ
  - 数量タブ
  - 移動履歴タブ
- ヘッダーアクション
  - 数量更新ボタン（在庫追跡対象商品のみ）
  - 削除ボタン等（継承元から）
- フォーム（3カラムレイアウト）
  - 商品作成画面と同様の構成
- フッターアクション
  - 保存ボタン
  - キャンセルボタン

## 入出力項目

商品作成画面と同様の入出力項目に加え、以下の数量更新ダイアログ項目があります。

### 数量更新ダイアログ

| 項目名 | フィールド名 | データ型 | 必須 | 入力形式 | 表示条件 | 説明 |
|--------|-------------|---------|------|---------|---------|------|
| 商品 | product_id | integer | ○ | Select（検索可） | コンフィギュラブル商品時のみ | バリエーション選択 |
| 数量 | quantity | decimal | ○ | TextInput（数値） | 常時 | 更新後の在庫数量 |

## 表示項目

該当なし（編集画面のため、入力項目が初期値としてロードされます）

## イベント仕様

### 1-保存ボタン押下

入力値のバリデーション後、商品レコードを更新します。
- 成功時：商品詳細画面へリダイレクト
- 失敗時：バリデーションエラーメッセージを表示

### 2-数量更新ボタン押下

在庫数量を直接更新するモーダルダイアログを表示します。
- is_storable = true の商品のみ表示
- パッケージ・ロケーション・ロット/シリアル番号管理が有効な場合は数量管理画面へリダイレクト

### 3-数量更新ダイアログ送信

在庫数量を更新し、在庫移動レコードを作成します。
- 数量増加時：調整ロケーション → ロット在庫ロケーション
- 数量減少時：ロット在庫ロケーション → 調整ロケーション
- ProductQuantityレコードを更新または作成
- Moveレコードを作成

### 4-商品選択（コンフィギュラブル商品時）

バリエーション商品を選択すると、その商品の現在在庫数量がquantityフィールドに表示されます。

### 5-サブナビゲーションタブ選択

各タブ選択時、対応する管理画面へ遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | products | SELECT | 編集対象商品の取得 |
| 保存ボタン押下 | products | UPDATE | 商品レコードの更新 |
| 数量更新送信 | inventories_product_quantities | UPDATE/INSERT | 数量レコードの更新/作成 |
| 数量更新送信 | inventories_moves | INSERT | 移動レコードの作成 |
| 数量更新送信 | inventories_move_lines | INSERT | 移動明細レコードの作成 |

### テーブル別更新項目詳細

#### products

商品作成画面と同様のUPDATE項目

#### inventories_product_quantities

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | product_id, location_id | 条件検索 | 既存レコード確認 |
| UPDATE | quantity | ダイアログ入力値 | 既存レコード時 |
| INSERT | product_id | 対象商品ID | 新規レコード時 |
| INSERT | company_id | 商品の会社ID | 新規レコード時 |
| INSERT | location_id | 倉庫のロット在庫ロケーションID | 新規レコード時 |
| INSERT | package_id | NULL | 新規レコード時 |
| INSERT | lot_id | NULL | 新規レコード時 |
| INSERT | quantity | ダイアログ入力値 | 新規レコード時 |
| INSERT | reserved_quantity | 0 | 新規レコード時 |
| INSERT | incoming_at | 現在日時 | 新規レコード時 |
| INSERT | creator_id | ログインユーザーID | 新規レコード時 |

#### inventories_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | 'Product Quantity Updated' | 固定値 |
| INSERT | state | DONE | MoveState Enum |
| INSERT | product_id | 対象商品ID | - |
| INSERT | source_location_id | 元ロケーションID | 数量変化方向に依存 |
| INSERT | destination_location_id | 先ロケーションID | 数量変化方向に依存 |
| INSERT | product_qty | 絶対数量 | - |
| INSERT | product_uom_qty | 絶対数量 | - |
| INSERT | quantity | 絶対数量 | - |
| INSERT | reference | 'Product Quantity Updated' | 固定値 |
| INSERT | scheduled_at | 現在日時 | - |
| INSERT | uom_id | 商品のUOM ID | - |
| INSERT | creator_id | ログインユーザーID | - |
| INSERT | company_id | 商品の会社ID | - |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-UPD-001 | 成功 | 商品が正常に更新されました | 更新成功時 |
| MSG-QTY-001 | 成功 | 在庫数量が正常に更新されました | 数量更新成功時 |
| MSG-DEL-001 | 成功 | 商品が正常に削除されました | 削除成功時 |
| MSG-VAL-001 | エラー | 商品名は必須です | 名前未入力時 |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| レコード未存在 | 404エラーページを表示 |
| 権限不足 | 403エラーページを表示、またはリダイレクト |
| バリデーションエラー | フォーム上にエラーメッセージを表示 |
| 外部キー制約違反（削除時） | エラー通知を表示し、削除処理をキャンセル |
| 倉庫未設定 | 数量更新時にエラー（Warehouse::first()がnull） |

## 備考

- 本画面はWebkul\Product\Filament\Resources\ProductResource\Pages\EditProductを継承して実装されています
- 数量更新機能は在庫管理モジュール固有の機能として追加されています
- 数量更新ボタンはis_storable = true の商品のみに表示されます
- パッケージ管理、ロケーション管理、ロット/シリアル番号管理のいずれかが有効な場合、数量更新ダイアログではなく数量管理画面（ManageQuantities）へリダイレクトされます
- 数量更新時は在庫移動レコード（Move）と移動明細レコード（MoveLine）が自動生成されます
- 調整ロケーションはtype = INVENTORY かつ is_scrap = false のロケーションが使用されます
- サブナビゲーションにはViewProduct, EditProduct, ManageAttributes, ManageVariants, ManageQuantities, ManageMovesが含まれます
