# 画面設計書 149-商品詳細

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「商品詳細」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、商品の詳細情報を表示するための画面です。商品の基本情報、設定、価格、在庫追跡設定（物品の場合）、物流情報、トレーサビリティ情報、レコード情報を確認することができます。

**業務上の目的・背景**：商品詳細画面は、商品マスタの登録内容を確認するために使用されます。在庫管理モジュールでは、在庫追跡設定、追跡方法、物流ルート、担当者、重量・容積などの物流関連情報も表示されます。また、サブナビゲーションから属性管理、バリエーション管理、数量管理、移動履歴管理などの関連機能へ遷移できます。

**画面へのアクセス方法**：
- 商品一覧画面 → 対象行をクリック または 表示アクションを選択
- 商品編集画面 → サブナビゲーションの詳細タブを選択

**主要な操作・処理内容**：
1. 商品名・説明・タグの確認
2. 商品画像の確認
3. 種別・参照番号・バーコード・カテゴリ・会社の確認
4. 価格・原価の確認
5. 在庫追跡設定の確認（物品のみ）
6. 追跡方法・有効期限使用フラグの確認
7. 物流ルートの確認
8. 担当者・重量・容積・販売リードタイムの確認
9. トレーサビリティ情報の確認（有効期限使用時）
10. 作成者・作成日時・更新日時の確認
11. 編集画面・各種管理画面への遷移

**画面遷移**：
- 遷移元：商品一覧画面、商品編集画面
- 遷移先：商品編集画面、属性管理画面、バリエーション管理画面、数量管理画面、移動履歴管理画面

**権限による表示制御**：特になし（在庫管理モジュールへのアクセス権限に依存）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-020 | 在庫商品管理 | 主機能 | 商品詳細表示 |
| FN-PRD-004 | 商品表示 | 補助機能 | 基底商品infolistの継承 |

## 画面種別

詳細

## URL/ルーティング

`/inventories/products/products/{record}`

## 画面構成

- サブナビゲーション（Top位置）
  - 詳細表示タブ（現在地）
  - 編集タブ
  - 属性タブ
  - バリエーションタブ
  - 数量タブ
  - 移動履歴タブ
- メインコンテンツ（3カラムレイアウト）
  - 左側グループ（2カラム幅）
    - 一般セクション（商品名、説明、タグ）
    - 画像セクション（画像がある場合のみ）
    - インベントリセクション（物品のみ）
      - 在庫追跡・追跡方法・有効期限使用
      - オペレーションサブセクション（ルート）
      - 物流サブセクション（担当者、重量、容積、販売リードタイム）
      - トレーサビリティサブセクション（有効期限使用時のみ）
  - 右側グループ（1カラム幅）
    - レコード情報セクション
    - 設定セクション（種別、参照番号、バーコード、カテゴリ、会社）
    - 価格セクション（価格、原価）

## 入出力項目

該当なし（詳細画面のため入力項目はありません）

## 表示項目

### 一般セクション

| 項目名 | フィールド名 | データ型 | アイコン | 説明 |
|--------|-------------|---------|---------|------|
| 商品名 | name | string | - | 商品名称 |
| 説明 | description | html | - | 商品説明（HTML形式） |
| タグ | tags.name | array | - | 商品タグ（バッジ表示・太字） |

### 画像セクション

| 項目名 | フィールド名 | データ型 | 説明 |
|--------|-------------|---------|------|
| 画像 | images | array | 商品画像（画像がある場合のみ表示） |

### インベントリセクション（物品のみ）

| 項目名 | フィールド名 | データ型 | アイコン | 説明 |
|--------|-------------|---------|---------|------|
| 在庫追跡 | is_storable | boolean | - | 在庫追跡対象フラグ（アイコン表示） |
| 追跡方法 | tracking | enum | - | 追跡方法（QTY/LOT/SERIAL） |
| 有効期限使用 | use_expiration_date | boolean | - | 有効期限使用フラグ（アイコン表示） |
| ルート | routes.name | array | heroicon-o-arrow-path | 物流ルート（改行区切りリスト） |
| 担当者 | responsible.name | string | heroicon-o-user | 担当者名 |
| 重量 | weight | decimal | heroicon-o-scale | 重量 |
| 容積 | volume | decimal | heroicon-o-beaker | 容積 |
| 販売リードタイム | sale_delay | integer | - | 販売リードタイム（日） |
| 有効期限 | expiration_time | integer | heroicon-o-clock | 有効期限（日） |
| 賞味期限 | use_time | integer | heroicon-o-clock | 賞味期限（日） |
| 撤去期限 | removal_time | integer | heroicon-o-clock | 撤去期限（日） |
| アラート期限 | alert_time | integer | heroicon-o-clock | アラート期限（日） |

### レコード情報セクション

| 項目名 | フィールド名 | データ型 | アイコン | 説明 |
|--------|-------------|---------|---------|------|
| 作成日時 | created_at | datetime | heroicon-o-calendar | レコード作成日時 |
| 作成者 | creator.name | string | heroicon-o-user | レコード作成者名 |
| 更新日時 | updated_at | datetime | heroicon-o-calendar | レコード更新日時 |

### 設定セクション

| 項目名 | フィールド名 | データ型 | アイコン | 説明 |
|--------|-------------|---------|---------|------|
| 種別 | type | enum | heroicon-o-queue-list | 商品種別 |
| 参照番号 | reference | string | heroicon-o-identification | 商品参照番号 |
| バーコード | barcode | string | heroicon-o-bars-4 | 商品バーコード |
| カテゴリ | category.full_name | string | heroicon-o-folder | 商品カテゴリ（完全パス） |
| 会社 | company.name | string | heroicon-o-building-office | 所属会社名 |

### 価格セクション

| 項目名 | フィールド名 | データ型 | アイコン | 説明 |
|--------|-------------|---------|---------|------|
| 価格 | price | decimal | heroicon-o-banknotes | 販売価格 |
| 原価 | cost | decimal | heroicon-o-banknotes | 仕入原価 |

## イベント仕様

### 1-サブナビゲーション編集タブ選択

編集タブ選択時、商品編集画面へ遷移します。

### 2-サブナビゲーション属性タブ選択

属性タブ選択時、属性管理画面へ遷移します。

### 3-サブナビゲーションバリエーションタブ選択

バリエーションタブ選択時、バリエーション管理画面へ遷移します。

### 4-サブナビゲーション数量タブ選択

数量タブ選択時、数量管理画面へ遷移します。

### 5-サブナビゲーション移動履歴タブ選択

移動履歴タブ選択時、移動履歴管理画面へ遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 詳細表示 | products | SELECT | 商品情報の取得 |
| 詳細表示 | products_categories | SELECT | カテゴリ情報の取得 |
| 詳細表示 | companies | SELECT | 会社情報の取得 |
| 詳細表示 | users | SELECT | 作成者・担当者情報の取得 |
| 詳細表示 | inventories_routes | SELECT | ルート情報の取得 |
| 詳細表示 | products_tags | SELECT | タグ情報の取得 |

### テーブル別更新項目詳細

#### products

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | URL パラメータ {record} に一致 | 主キー |
| SELECT | name | - | 表示用 |
| SELECT | description | - | HTML表示用 |
| SELECT | type | - | Enum表示用 |
| SELECT | reference | - | 表示用 |
| SELECT | barcode | - | 表示用 |
| SELECT | price | - | 表示用 |
| SELECT | cost | - | 表示用 |
| SELECT | is_storable | - | 表示用 |
| SELECT | tracking | - | Enum表示用 |
| SELECT | use_expiration_date | - | 表示用 |
| SELECT | weight | - | 表示用 |
| SELECT | volume | - | 表示用 |
| SELECT | sale_delay | - | 表示用 |
| SELECT | expiration_time | - | 表示用 |
| SELECT | use_time | - | 表示用 |
| SELECT | removal_time | - | 表示用 |
| SELECT | alert_time | - | 表示用 |
| SELECT | images | - | JSON表示用 |
| SELECT | created_at | - | 表示用 |
| SELECT | updated_at | - | 表示用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| - | - | - | 詳細画面のため特定のメッセージ表示なし |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| レコード未存在 | 404エラーページを表示 |
| 権限不足 | 403エラーページを表示、またはリダイレクト |

## 備考

- 本画面はWebkul\Product\Filament\Resources\ProductResource\Pages\ViewProductを継承して実装されています
- infolistは3カラムレイアウトで構成されています
- インベントリセクションは商品種別が「物品（GOODS）」の場合のみ表示されます
- 画像セクションは画像が設定されている場合のみ表示されます
- トレーサビリティサブセクションはuse_expiration_dateがtrueの場合のみ表示されます
- サブナビゲーションにはViewProduct, EditProduct, ManageAttributes, ManageVariants, ManageQuantities, ManageMovesが含まれます
- 値が未設定の項目はプレースホルダー「—」で表示されます
