# 画面設計書 15-クレジットノート一覧

## 概要

本ドキュメントは、Aureus ERPシステムにおける「クレジットノート一覧」画面の設計仕様を定義するものである。

### 本画面の処理概要

クレジットノート一覧画面は、会計モジュールにおいて発行済みのクレジットノート（返品伝票・貸方票）を管理するための画面である。

**業務上の目的・背景**：顧客への返品処理や請求金額の減額調整時に発行されるクレジットノートを一元管理する。元の請求書に対する減額・返金を記録し、会計処理の正確性と追跡可能性を確保する。売掛金の調整や返品処理のワークフローを効率化する。

**画面へのアクセス方法**：会計モジュールのナビゲーションメニューから「クレジットノート」を選択してアクセスする。または請求書画面からクレジットノートアクションを実行してアクセスする。

**主要な操作・処理内容**：
1. クレジットノートの一覧表示（フィルタリング、ソート、検索）
2. プリセットビュー（クレジットノート、下書き、転記済み、キャンセル等）での切り替え表示
3. 新規クレジットノートの作成
4. 既存クレジットノートの詳細表示・編集・削除
5. 複数レコードの一括削除

**画面遷移**：
- クレジットノート作成画面へ遷移可能
- クレジットノート詳細画面へ遷移可能
- クレジットノート編集画面へ遷移可能

**権限による表示制御**：Filament Resourceの標準的な権限管理に従い、リソースへのアクセス権限を持つユーザーのみが画面にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-ACC-031 | クレジットノート管理 | 主機能 | クレジットノートのCRUD操作全般 |
| FN-ACC-052 | クレジットノート管理 | 主機能 | 作成/編集/削除 |

## 画面種別

一覧

## URL/ルーティング

`/admin/accounts/credit-notes`

## 画面構成

1. **ヘッダーエリア**
   - ページタイトル
   - 「作成」ボタン（heroicon-o-plus-circleアイコン付き）

2. **プリセットビュータブエリア**
   - クレジットノート（out_refund - デフォルト、お気に入り）
   - 下書き（draft）
   - 転記済み（posted）
   - キャンセル（cancelled）
   - 未保護（not_secured）
   - 返金（in_refund）
   - 要確認（to_check）
   - 支払待ち（to_pay）
   - 支払中（in_payment）
   - 期限超過（overdue）

3. **テーブルエリア**
   - 多数のカラム（番号、状態、顧客、請求日、支払期日、税抜金額、税額、合計、残高、支払状態等）
   - 各行アクション：表示、編集、削除
   - グループ化機能
   - 検索・ソート・フィルタ機能
   - 合計表示（Summarizers）

4. **バルクアクションエリア**
   - 一括削除機能

## 入出力項目

該当なし（一覧画面のため入力項目なし）

## 表示項目

| 項目名 | 物理名 | データ型 | 説明 |
|--------|--------|----------|------|
| 番号 | name | string | クレジットノート番号 |
| 状態 | state | enum | ステータス（下書き/転記済み/キャンセル） |
| 顧客 | invoice_partner_display_name | string | 顧客名 |
| 請求日 | invoice_date | date | 請求日 |
| 支払期日 | invoice_date_due | date | 支払期限 |
| 税抜金額 | amount_untaxed_in_currency_signed | numeric | 税抜合計金額 |
| 税額 | amount_tax_signed | numeric | 税額 |
| 合計 | amount_total_in_currency_signed | numeric | 総合計金額 |
| 残高 | amount_residual_signed | numeric | 未払残高 |
| 支払状態 | payment_state | enum | 支払状態（未払/一部支払/支払済等） |
| 確認済み | checked | boolean | 確認フラグ |
| 会計日 | date | date | 会計日付 |
| 元伝票 | invoice_origin | string | 元となる伝票番号 |
| 参照 | reference | string | 参照情報 |
| 担当者 | invoiceUser.name | string | 営業担当者名 |
| 通貨 | currency.name | string | 通貨名 |

## イベント仕様

### 1-作成ボタン押下

ヘッダーの「作成」ボタン押下時、クレジットノート作成画面（CreateCreditNote）へ遷移する。

### 2-プリセットビュー切替

タブ切り替え時、選択されたビューに応じてクエリが変更され、該当するレコードのみがフィルタリング表示される。デフォルトはout_refund（顧客へのクレジットノート）でフィルタリング。

### 3-表示アクション

各行の「表示」アクション選択時、該当レコードの詳細画面（ViewCreditNote）へ遷移する。

### 4-編集アクション

各行の「編集」アクション選択時、該当レコードの編集画面（EditCreditNote）へ遷移する。

### 5-削除アクション

各行の「削除」アクション選択時、確認後にレコードを削除し、成功通知を表示する。

### 6-一括削除

バルクアクションの「削除」選択時、選択された複数レコードを一括削除し、成功通知を表示する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | accounts_account_moves | DELETE | 選択レコードの削除 |
| 一括削除 | accounts_account_moves | DELETE | 複数レコードの一括削除 |

### テーブル別更新項目詳細

#### accounts_account_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE move_type = 'out_refund' | デフォルトビュー |
| DELETE | - | WHERE id = 選択ID | 物理削除 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 成功 | 削除成功通知（タイトル・本文） | 削除アクション成功時 |
| 成功 | 一括削除成功通知（タイトル・本文） | 一括削除成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| データなし | 空のテーブルを表示 |
| 権限不足 | Filament標準の権限エラー表示 |

## 備考

- CreditNoteResourceはInvoiceResourceを継承しており、多くの機能を請求書リソースから引き継いでいる
- ListCreditNotesはListInvoicesを継承し、プリセットビューをカスタマイズしている
- デフォルトのプリセットビューは「out_refund」（顧客向けクレジットノート）でフィルタリング
- 「invoice」プリセットビューは除外され、代わりに「out_refund」ビューがデフォルトとして設定
- テーブルカラムにはSumマリータイプが設定され、各種金額の合計が表示される
- HasTableViewsトレイトを使用してテーブルビュー機能を実装
