# 画面設計書 150-パッケージ一覧

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「パッケージ一覧」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、在庫管理で使用するパッケージ（梱包単位）を一覧表示し、検索・フィルタリング・グルーピングなどの操作を行うための画面です。内部ロケーションに存在するパッケージをデフォルトで表示するプリセットビューが設定されています。

**業務上の目的・背景**：パッケージは、複数の商品をまとめて管理するための梱包単位です。倉庫内での商品移動やピッキング、出荷作業において、パッケージ単位での管理により作業効率が向上します。パッケージには名前、パッケージタイプ、梱包日、保管ロケーションなどの情報を設定できます。また、パッケージにはバーコードが付与され、バーコードラベルの印刷機能も提供されます。

**画面へのアクセス方法**：在庫管理モジュール → 商品（Products）クラスター → パッケージ

**主要な操作・処理内容**：
1. パッケージの一覧表示（テーブル形式）
2. パッケージ名での検索
3. パッケージタイプ、ロケーション、作成者、会社でのフィルタリング
4. パッケージタイプ、ロケーション、作成日でのグルーピング
5. 内部ロケーションタブでの絞り込み（デフォルト）
6. 新規パッケージ作成画面への遷移
7. パッケージ詳細画面への遷移
8. パッケージ編集画面への遷移
9. パッケージの削除（個別・一括）
10. バーコードラベルの印刷（内容あり/なし）

**画面遷移**：
- 遷移元：在庫管理ダッシュボード、商品メニュー
- 遷移先：パッケージ作成画面、パッケージ詳細画面、パッケージ編集画面

**権限による表示制御**：OperationSettingsのenable_packagesが有効な場合のみ、本リソースが表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-021 | パッケージ一覧 | 主機能 | パッケージ一覧表示・検索・フィルタ |
| FN-INV-021-1 | バーコード印刷 | 補助機能 | パッケージバーコードの印刷 |

## 画面種別

一覧

## URL/ルーティング

`/inventories/products/packages`

## 画面構成

- プリセットビュータブ
  - 内部ロケーションタブ（internal_locations）：内部ロケーションに存在するパッケージのみ表示（デフォルト・お気に入り）
- ヘッダーアクション
  - 新規作成ボタン
- テーブル
  - グルーピング機能
  - フィルター機能
  - 一括操作機能
- 空状態アクション
  - なし（標準動作）

## 入出力項目

該当なし（一覧画面のため）

## 表示項目

| 項目名 | フィールド名 | データ型 | 検索可否 | ソート可否 | デフォルト表示 | 説明 |
|--------|-------------|---------|---------|-----------|--------------|------|
| パッケージ名 | name | string | ○ | ○ | ○ | パッケージ名称 |
| パッケージタイプ | packageType.name | string | - | ○ | ○ | パッケージタイプ名 |
| ロケーション | location.full_name | string | - | ○ | ○ | 保管ロケーション（完全パス） |
| 会社 | company.name | string | - | ○ | ○ | 所属会社名 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの新規作成ボタン押下時、パッケージ作成画面へ遷移します。

### 2-行クリック（表示アクション）

テーブル行の表示アクション選択時、パッケージ詳細画面へ遷移します。

### 3-編集アクション選択

行アクションの編集を選択時、パッケージ編集画面へ遷移します。

### 4-削除アクション選択

行アクションの削除を選択時、削除確認ダイアログを表示し、確認後にレコードを削除します。外部キー制約違反時はエラー通知を表示。

### 5-一括削除アクション

チェックボックスで選択した複数レコードを一括削除します。外部キー制約違反時はエラー通知を表示。

### 6-内容なしバーコード印刷

選択したパッケージのバーコードラベルをPDF形式で出力します（パッケージ内容なし）。

### 7-内容ありバーコード印刷

選択したパッケージのバーコードラベルをPDF形式で出力します（パッケージ内容あり）。

### 8-内部ロケーションタブ選択

プリセットビューの内部ロケーションタブを選択時、type = INTERNAL のロケーションに存在するパッケージのみを表示します。

### 9-フィルター適用

パッケージタイプ、ロケーション、作成者、会社でのフィルタリングを適用し、テーブル表示を更新します。

### 10-グルーピング適用

選択したグループ基準（パッケージタイプ、ロケーション、作成日）でテーブルをグルーピング表示します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | inventories_packages | SELECT | パッケージ情報の取得 |
| 一覧表示 | inventories_package_types | SELECT | パッケージタイプ情報の取得 |
| 一覧表示 | inventories_locations | SELECT | ロケーション情報の取得 |
| 一覧表示 | companies | SELECT | 会社情報の取得 |
| 一覧表示 | users | SELECT | 作成者情報の取得 |
| 削除アクション | inventories_packages | DELETE | パッケージの削除 |
| 一括削除 | inventories_packages | DELETE | 複数パッケージの削除 |

### テーブル別更新項目詳細

#### inventories_packages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | - | 主キー |
| SELECT | name | - | 検索・表示用 |
| SELECT | package_type_id | - | パッケージタイプリレーション用 |
| SELECT | location_id | - | ロケーションリレーション用 |
| SELECT | company_id | - | 会社リレーション用 |
| SELECT | creator_id | - | 作成者リレーション用 |
| SELECT | created_at | - | グルーピング用 |
| DELETE | id | 選択されたレコードID | 削除対象 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-DEL-001 | 成功 | パッケージが正常に削除されました | 削除成功時 |
| MSG-DEL-002 | エラー | このパッケージは他のレコードで使用されているため削除できません | 外部キー制約違反時 |
| MSG-BULK-001 | 成功 | 選択したパッケージが正常に削除されました | 一括削除成功時 |
| MSG-BULK-002 | エラー | 一部のパッケージは他のレコードで使用されているため削除できません | 一括削除で制約違反時 |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| 権限不足 | 403エラーページを表示、またはリダイレクト |
| パッケージ機能無効 | リソースが非表示となり、アクセス不可 |
| 外部キー制約違反 | エラー通知を表示し、削除処理をキャンセル |
| データベース接続エラー | システムエラーページを表示 |

## 備考

- 本画面はFilament PHPのListRecordsを使用して実装されています
- HasTableViewsトレイトを使用してテーブルビュー機能を提供しています
- OperationSettingsのenable_packagesが有効な場合のみ、このリソースにアクセス可能です
- プリセットビュー「内部ロケーション」はデフォルト・お気に入りとして設定されています
- バーコード印刷はbarryvdh/laravel-dompdfパッケージを使用してPDFを生成します
- 印刷はA4縦向きで出力されます
- 行アクションはActionGroupでグルーピングされています
- recordTitleAttributeはnameに設定されています
- navigationSortは2に設定されています
- ナビゲーションアイコンはheroicon-o-cubeです
