# 画面設計書 151-パッケージ作成

## 概要

本ドキュメントは、Aureus ERPシステムにおけるパッケージ作成画面の設計書です。在庫モジュール内のパッケージ管理機能において、新規パッケージを登録するためのフォーム画面について記述します。

### 本画面の処理概要

**業務上の目的・背景**：在庫管理において、商品を物理的にまとめて管理するためのパッケージを作成します。パッケージは、倉庫内での商品のグループ化、出荷時の梱包単位の管理、トレーサビリティの向上に不可欠です。パッケージタイプを指定することで、梱包仕様の標準化と管理効率化を実現します。

**画面へのアクセス方法**：メインメニューから「在庫」>「商品」クラスターの「パッケージ」を選択し、一覧画面の「作成」ボタンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. パッケージ名の入力（必須）
2. パッケージタイプの選択（オプション）- パッケージの物理的仕様を定義
3. パック日の設定 - パッケージングを行った日付
4. ロケーションの選択 - パッケージの保管場所

**画面遷移**：パッケージ一覧画面から遷移し、保存後はパッケージ詳細画面に遷移します。

**権限による表示制御**：パッケージ機能が有効な場合（OperationSettings.enable_packages = true）のみ表示されます。作成権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-021 | パッケージ一覧 | 遷移元機能 | パッケージ一覧から作成画面に遷移 |
| FN-INV-029 | パッケージタイプ管理 | 補助機能 | パッケージタイプをフォーム内で新規作成可能 |
| FN-INV-024 | ロケーション管理 | 補助機能 | ロケーションを選択してパッケージの保管場所を設定 |

## 画面種別

登録

## URL/ルーティング

`/inventories/products/packages/create`

## 画面構成

- セクション: 一般情報（General）
  - テキスト入力: パッケージ名
  - セレクトボックス: パッケージタイプ（新規作成機能付き）
  - 日付ピッカー: パック日
  - セレクトボックス: ロケーション
- ヘッダーナビゲーション: クラスター内の他リソースへの遷移タブ
- フォーム送信ボタン

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 初期値 | 入力形式/制約 | 説明 |
|--------|--------|----------|------|--------|---------------|------|
| パッケージ名 | name | string | Yes | - | 最大255文字、自動フォーカス | パッケージの識別名 |
| パッケージタイプ | package_type_id | integer | No | - | セレクト（検索可能） | パッケージの物理的仕様 |
| パック日 | pack_date | date | No | 今日の日付 | 日付ピッカー | パッケージングを行った日付 |
| ロケーション | location_id | integer | No | - | セレクト（検索可能） | パッケージの保管場所 |
| 作成者ID | creator_id | integer | - | ログインユーザー | 自動設定 | システムが自動的に設定 |
| 会社ID | company_id | integer | - | ユーザーのデフォルト会社 | 自動設定 | システムが自動的に設定 |

## 表示項目

なし（登録フォーム画面のため）

## イベント仕様

### 1-保存ボタン押下

フォームに入力された情報を検証し、パッケージレコードを新規作成します。

- 処理フロー:
  1. 入力値のバリデーション実行
  2. creator_idにログインユーザーIDを設定
  3. company_idにユーザーのデフォルト会社IDを設定
  4. inventories_packagesテーブルにINSERT
  5. 成功通知を表示
  6. パッケージ詳細画面にリダイレクト

### 2-パッケージタイプ新規作成

パッケージタイプ選択フィールド内で新規パッケージタイプを作成できます。

- 処理フロー:
  1. パッケージタイプ作成フォームがモーダルで表示
  2. 必要項目を入力して保存
  3. 作成されたパッケージタイプが自動選択

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | inventories_packages | INSERT | 新規パッケージレコードを作成 |
| パッケージタイプ新規作成 | inventories_package_types | INSERT | 新規パッケージタイプを作成 |

### テーブル別更新項目詳細

#### inventories_packages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | package_type_id | フォーム選択値 | NULL可 |
| INSERT | pack_date | フォーム入力値 | デフォルトは今日 |
| INSERT | location_id | フォーム選択値 | NULL可 |
| INSERT | creator_id | Auth::id() | ログインユーザーID |
| INSERT | company_id | Auth::user()->default_company_id | ユーザーのデフォルト会社 |
| INSERT | created_at | now() | 自動設定 |
| INSERT | updated_at | now() | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| create-package.notification.title | 成功 | パッケージが作成されました | 保存成功時 |
| create-package.notification.body | 成功 | パッケージの作成に成功しました | 保存成功時 |

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|----------|----------|-----------------|
| 必須項目未入力 | バリデーションエラー | 該当フィールドにエラーメッセージ表示 |
| パッケージ名が255文字超過 | バリデーションエラー | 文字数制限エラーメッセージ表示 |
| データベースエラー | 例外をキャッチ | システムエラー通知を表示 |

## 備考

- パッケージ機能はOperationSettings.enable_packagesがtrueの場合のみ有効です
- パッケージタイプはPackageTypeResourceのフォームを再利用して新規作成可能です
- ロケーションはfull_name（完全パス名）で表示されます
