# 画面設計書 152-パッケージ編集

## 概要

本ドキュメントは、Aureus ERPシステムにおけるパッケージ編集画面の設計書です。在庫モジュール内のパッケージ管理機能において、既存パッケージの情報を編集するためのフォーム画面について記述します。

### 本画面の処理概要

**業務上の目的・背景**：登録済みパッケージの情報を更新する必要がある場合に使用します。パッケージタイプの変更、ロケーションの移動、パック日の修正など、パッケージ属性の変更を行います。また、パッケージラベルの印刷やパッケージの削除も本画面から実行可能です。

**画面へのアクセス方法**：パッケージ一覧画面で対象パッケージの行アクションメニューから「編集」を選択するか、パッケージ詳細画面のサブナビゲーションから「編集」タブをクリックしてアクセスします。

**主要な操作・処理内容**：
1. パッケージ名の変更
2. パッケージタイプの変更
3. パック日の修正
4. ロケーションの変更
5. パッケージラベルの印刷（内容なし/内容あり）
6. パッケージの削除

**画面遷移**：パッケージ一覧画面または詳細画面から遷移し、保存後はパッケージ詳細画面に遷移します。サブナビゲーションから詳細画面、関連商品管理画面、オペレーション管理画面にも遷移可能です。

**権限による表示制御**：パッケージ機能が有効な場合（OperationSettings.enable_packages = true）のみ表示されます。編集権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-021 | パッケージ一覧 | 遷移元機能 | 一覧から編集画面に遷移 |
| FN-INV-029 | パッケージタイプ管理 | 補助機能 | パッケージタイプをフォーム内で新規作成可能 |
| FN-INV-024 | ロケーション管理 | 補助機能 | ロケーションを変更してパッケージの保管場所を更新 |

## 画面種別

編集

## URL/ルーティング

`/inventories/products/packages/{record}/edit`

## 画面構成

- ヘッダーアクション:
  - 印刷ボタン（ドロップダウン）
    - 内容なし印刷
    - 内容あり印刷
  - 削除ボタン
- セクション: 一般情報（General）
  - テキスト入力: パッケージ名
  - セレクトボックス: パッケージタイプ（新規作成機能付き）
  - 日付ピッカー: パック日
  - セレクトボックス: ロケーション
- サブナビゲーション: 詳細/編集/関連商品/オペレーション
- フォーム送信ボタン

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 初期値 | 入力形式/制約 | 説明 |
|--------|--------|----------|------|--------|---------------|------|
| パッケージ名 | name | string | Yes | 既存値 | 最大255文字 | パッケージの識別名 |
| パッケージタイプ | package_type_id | integer | No | 既存値 | セレクト（検索可能） | パッケージの物理的仕様 |
| パック日 | pack_date | date | No | 既存値 | 日付ピッカー | パッケージングを行った日付 |
| ロケーション | location_id | integer | No | 既存値 | セレクト（検索可能） | パッケージの保管場所 |

## 表示項目

なし（編集フォーム画面のため、入出力項目として既存値が表示される）

## イベント仕様

### 1-保存ボタン押下

フォームに入力された情報を検証し、パッケージレコードを更新します。

- 処理フロー:
  1. 入力値のバリデーション実行
  2. inventories_packagesテーブルをUPDATE
  3. 成功通知を表示
  4. パッケージ詳細画面にリダイレクト

### 2-印刷ボタン（内容なし）

パッケージのバーコードラベルをPDF形式で出力します（商品内容なし）。

- 処理フロー:
  1. PDFビュー（print-without-content）を読み込み
  2. A4縦サイズでPDFを生成
  3. 「Package-{パッケージ名}.pdf」としてダウンロード

### 3-印刷ボタン（内容あり）

パッケージのバーコードラベルと商品内容をPDF形式で出力します。

- 処理フロー:
  1. PDFビュー（print-with-content）を読み込み
  2. A4縦サイズでPDFを生成
  3. 「Package-{パッケージ名}.pdf」としてダウンロード

### 4-削除ボタン押下

パッケージを削除します。

- 処理フロー:
  1. 確認ダイアログを表示
  2. 削除確定時、inventories_packagesテーブルからDELETE
  3. 成功時: 成功通知を表示し、一覧画面にリダイレクト
  4. 失敗時（参照整合性エラー）: エラー通知を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | inventories_packages | UPDATE | パッケージレコードを更新 |
| 削除ボタン押下 | inventories_packages | DELETE | パッケージレコードを削除 |

### テーブル別更新項目詳細

#### inventories_packages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | package_type_id | フォーム選択値 | NULL可 |
| UPDATE | pack_date | フォーム入力値 | NULL可 |
| UPDATE | location_id | フォーム選択値 | NULL可 |
| UPDATE | updated_at | now() | 自動設定 |
| DELETE | - | WHERE id = {record_id} | 物理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| edit-package.notification.title | 成功 | パッケージが更新されました | 保存成功時 |
| edit-package.notification.body | 成功 | パッケージの更新に成功しました | 保存成功時 |
| delete.notification.success.title | 成功 | パッケージが削除されました | 削除成功時 |
| delete.notification.success.body | 成功 | パッケージの削除に成功しました | 削除成功時 |
| delete.notification.error.title | エラー | 削除できません | 削除失敗時 |
| delete.notification.error.body | エラー | このパッケージは他のレコードで使用されています | 削除失敗時（参照整合性エラー） |

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|----------|----------|-----------------|
| 必須項目未入力 | バリデーションエラー | 該当フィールドにエラーメッセージ表示 |
| パッケージ名が255文字超過 | バリデーションエラー | 文字数制限エラーメッセージ表示 |
| 削除時の参照整合性エラー | QueryExceptionをキャッチ | 削除失敗通知を表示 |
| レコードが存在しない | 404エラー | ページが見つかりません |

## 備考

- パッケージ機能はOperationSettings.enable_packagesがtrueの場合のみ有効です
- HasRecordNavigationTabsトレイトを使用してサブナビゲーションを実装しています
- PDF生成にはbarryvdh/laravel-dompdfを使用しています
- 削除時の参照整合性エラーはQueryExceptionでハンドリングされ、ユーザーフレンドリーなエラーメッセージが表示されます
