# 画面設計書 153-パッケージ詳細

## 概要

本ドキュメントは、Aureus ERPシステムにおけるパッケージ詳細画面の設計書です。在庫モジュール内のパッケージ管理機能において、パッケージの詳細情報を閲覧するための画面について記述します。

### 本画面の処理概要

**業務上の目的・背景**：登録済みパッケージの詳細情報を確認するために使用します。パッケージの基本情報（名前、タイプ、ロケーション）、パッケージに含まれる商品数量、関連するオペレーション（入出庫履歴）など、パッケージに関する包括的な情報を一覧表示します。

**画面へのアクセス方法**：パッケージ一覧画面で対象パッケージの行をクリック、または行アクションメニューから「詳細」を選択してアクセスします。

**主要な操作・処理内容**：
1. パッケージ基本情報の閲覧
2. パッケージラベルの印刷（内容なし/内容あり）
3. パッケージの削除
4. 関連画面（編集/商品管理/オペレーション管理）への遷移

**画面遷移**：パッケージ一覧画面から遷移します。サブナビゲーションから編集画面、関連商品管理画面、オペレーション管理画面に遷移可能です。

**権限による表示制御**：パッケージ機能が有効な場合（OperationSettings.enable_packages = true）のみ表示されます。閲覧権限を持つユーザーがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-021 | パッケージ一覧 | 遷移元機能 | 一覧から詳細画面に遷移 |
| FN-INV-022 | パッケージ編集 | 遷移先機能 | サブナビゲーションから編集画面に遷移 |
| FN-INV-024 | ロケーション管理 | 参照機能 | ロケーション情報を表示 |

## 画面種別

詳細

## URL/ルーティング

`/inventories/products/packages/{record}`

## 画面構成

- ヘッダーアクション:
  - 印刷ボタン（ドロップダウン）
    - 内容なし印刷
    - 内容あり印刷
  - 削除ボタン
- セクション: 一般情報
  - テキストエントリ: パッケージ名
  - テキストエントリ: パッケージタイプ
  - テキストエントリ: パック日
  - テキストエントリ: ロケーション
  - テキストエントリ: 商品数量（バッジ表示）
  - テキストエントリ: 会社
- セクション: レコード情報
  - テキストエントリ: 作成日時
  - テキストエントリ: 作成者
  - テキストエントリ: 最終更新日時
- サブナビゲーション: 詳細/編集/関連商品/オペレーション

## 入出力項目

なし（詳細表示画面のため入力項目なし）

## 表示項目

| 項目名 | 項目ID | データ型 | 取得元 | 表示形式 |
|--------|--------|----------|--------|----------|
| パッケージ名 | name | string | inventories_packages.name | テキスト、大サイズ、太字、アイコン付き |
| パッケージタイプ | packageType.name | string | inventories_package_types.name | テキスト、アイコン付き |
| パック日 | pack_date | date | inventories_packages.pack_date | 日付形式、アイコン付き |
| ロケーション | location.full_name | string | inventories_locations.full_name | テキスト、アイコン付き |
| 商品数量 | quantities_count | integer | hasMany(quantities).count() | バッジ形式 |
| 会社 | company.name | string | companies.name | テキスト、アイコン付き |
| 作成日時 | created_at | datetime | inventories_packages.created_at | 日時形式、アイコン付き |
| 作成者 | creator.name | string | users.name | テキスト、アイコン付き |
| 最終更新日時 | updated_at | datetime | inventories_packages.updated_at | 日時形式、アイコン付き |

## イベント仕様

### 1-印刷ボタン（内容なし）

パッケージのバーコードラベルをPDF形式で出力します（商品内容なし）。

- 処理フロー:
  1. PDFビュー（print-without-content）を読み込み
  2. A4縦サイズでPDFを生成
  3. 「Package-{パッケージ名}.pdf」としてダウンロード

### 2-印刷ボタン（内容あり）

パッケージのバーコードラベルと商品内容をPDF形式で出力します。

- 処理フロー:
  1. PDFビュー（print-with-content）を読み込み
  2. A4縦サイズでPDFを生成
  3. 「Package-{パッケージ名}.pdf」としてダウンロード

### 3-削除ボタン押下

パッケージを削除します。

- 処理フロー:
  1. 確認ダイアログを表示
  2. 削除確定時、inventories_packagesテーブルからDELETE
  3. 成功時: 成功通知を表示し、一覧画面にリダイレクト
  4. 失敗時（参照整合性エラー）: エラー通知を表示

### 4-サブナビゲーション遷移

サブナビゲーションタブをクリックして関連画面に遷移します。

- 遷移先:
  - 詳細: ViewPackage（現在の画面）
  - 編集: EditPackage
  - 商品: ManageQuantities
  - オペレーション: ManageOperations

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | inventories_packages | DELETE | パッケージレコードを削除 |

### テーブル別更新項目詳細

#### inventories_packages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = {record_id} | 物理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| delete.notification.success.title | 成功 | パッケージが削除されました | 削除成功時 |
| delete.notification.success.body | 成功 | パッケージの削除に成功しました | 削除成功時 |
| delete.notification.error.title | エラー | 削除できません | 削除失敗時 |
| delete.notification.error.body | エラー | このパッケージは他のレコードで使用されています | 削除失敗時（参照整合性エラー） |

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|----------|----------|-----------------|
| レコードが存在しない | 404エラー | ページが見つかりません |
| 削除時の参照整合性エラー | QueryExceptionをキャッチ | 削除失敗通知を表示 |

## 備考

- パッケージ機能はOperationSettings.enable_packagesがtrueの場合のみ有効です
- HasRecordNavigationTabsトレイトを使用してサブナビゲーションを実装しています
- 表示はInfolist形式で実装されており、各フィールドにはヒントアイコンが付与されています
- PDF生成にはbarryvdh/laravel-dompdfを使用しています
- 商品数量はquantitiesリレーションのカウントで算出されます
