# 画面設計書 154-ロット一覧

## 概要

本ドキュメントは、Aureus ERPシステムにおけるロット一覧画面の設計書です。在庫モジュール内のロット/シリアル番号管理機能において、登録済みロットを一覧表示・検索・操作するための画面について記述します。

### 本画面の処理概要

**業務上の目的・背景**：ロット（製造ロット）は、同一の製造条件下で生産された製品群を識別するための単位です。トレーサビリティ（追跡可能性）を実現し、品質問題発生時の影響範囲特定やリコール対応を効率化します。本画面では、登録済みロットの検索・閲覧・管理操作を行います。

**画面へのアクセス方法**：メインメニューから「在庫」>「商品」クラスターの「ロット/シリアル番号」を選択してアクセスします。

**主要な操作・処理内容**：
1. ロット一覧の表示（ページネーション付き）
2. ロットの検索・フィルタリング
3. ロットのグループ化表示
4. ロットの詳細/編集画面への遷移
5. ロットの削除
6. 一括印刷（バーコードラベル）
7. 一括削除

**画面遷移**：メインメニューから直接遷移します。一覧から詳細画面、編集画面、作成画面に遷移可能です。

**権限による表示制御**：ロット/シリアル番号管理機能が有効な場合（TraceabilitySettings.enable_lots_serial_numbers = true）のみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-031 | ロット作成 | 遷移先機能 | 一覧から作成画面に遷移 |
| FN-INV-032 | ロット編集 | 遷移先機能 | 一覧から編集画面に遷移 |
| FN-INV-033 | ロット詳細 | 遷移先機能 | 一覧から詳細画面に遷移 |

## 画面種別

一覧

## URL/ルーティング

`/inventories/products/lots`

## 画面構成

- ヘッダーアクション:
  - 作成ボタン
- テーブル:
  - カラム: ロット名、商品、参照、在庫数量、作成日、更新日
  - グループ化: 商品/ロケーション/作成日
  - フィルター: 商品/ロケーション/作成者/会社
  - 行アクション: 詳細/編集/削除
  - 一括アクション: 印刷/一括削除
- サブナビゲーション: クラスター内の他リソースへのタブ

## 入出力項目

なし（一覧画面のため入力項目なし）

## 表示項目

| 項目名 | 項目ID | データ型 | 取得元 | 表示形式 |
|--------|--------|----------|--------|----------|
| ロット名 | name | string | inventories_lots.name | テキスト、検索・ソート可 |
| 商品 | product.name | string | products.name | テキスト、検索・ソート可 |
| 参照 | reference | string | inventories_lots.reference | テキスト、検索・ソート可、プレースホルダー「—」 |
| 在庫数量 | total_quantity | decimal | 計算値 | 数値、ソート可 |
| 作成日時 | created_at | datetime | inventories_lots.created_at | 日時形式、デフォルト非表示 |
| 更新日時 | updated_at | datetime | inventories_lots.updated_at | 日時形式、デフォルト非表示 |

## イベント仕様

### 1-作成ボタン押下

ロット作成画面に遷移します。

- 処理フロー:
  1. /inventories/products/lots/createにリダイレクト

### 2-行アクション：詳細

選択したロットの詳細画面に遷移します。

- 処理フロー:
  1. /inventories/products/lots/{record}にリダイレクト

### 3-行アクション：編集

選択したロットの編集画面に遷移します。

- 処理フロー:
  1. /inventories/products/lots/{record}/editにリダイレクト

### 4-行アクション：削除

選択したロットを削除します。

- 処理フロー:
  1. 確認ダイアログを表示
  2. 削除確定時、inventories_lotsテーブルからDELETE
  3. 成功時: 成功通知を表示
  4. 失敗時（参照整合性エラー）: エラー通知を表示

### 5-一括アクション：印刷

選択したロットのバーコードラベルをPDF形式で一括出力します。

- 処理フロー:
  1. 選択されたロットを取得
  2. PDFビュー（print）を読み込み
  3. A4縦サイズでPDFを生成
  4. 「Lot-Barcode.pdf」としてダウンロード

### 6-一括アクション：削除

選択したロットを一括削除します。

- 処理フロー:
  1. 確認ダイアログを表示
  2. 削除確定時、選択された各レコードをDELETE
  3. 成功時: 成功通知を表示
  4. 失敗時（参照整合性エラー）: エラー通知を表示

### 7-グループ化変更

テーブルの表示をグループ化します。

- グループ化オプション:
  - 商品（product.name）
  - ロケーション（location.full_name）
  - 作成日（created_at）- 日付単位

### 8-フィルター適用

フィルター条件に基づいてロット一覧を絞り込みます。

- フィルターオプション:
  - 商品（product_id）- セレクト、検索可
  - ロケーション（location_id）- セレクト、検索可、複数選択可
  - 作成者（creator_id）- セレクト、検索可
  - 会社（company_id）- セレクト、検索可

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 行アクション：削除 | inventories_lots | DELETE | 単一ロットを削除 |
| 一括アクション：削除 | inventories_lots | DELETE | 複数ロットを一括削除 |

### テーブル別更新項目詳細

#### inventories_lots

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = {record_id} | 物理削除 |
| DELETE | - | WHERE id IN ({record_ids}) | 一括削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| delete.notification.success.title | 成功 | ロットが削除されました | 削除成功時 |
| delete.notification.success.body | 成功 | ロットの削除に成功しました | 削除成功時 |
| delete.notification.error.title | エラー | 削除できません | 削除失敗時 |
| delete.notification.error.body | エラー | このロットは他のレコードで使用されています | 削除失敗時（参照整合性エラー） |
| bulk-delete.notification.success.title | 成功 | ロットが削除されました | 一括削除成功時 |
| bulk-delete.notification.success.body | 成功 | 選択したロットの削除に成功しました | 一括削除成功時 |
| bulk-delete.notification.error.title | エラー | 削除できません | 一括削除失敗時 |
| bulk-delete.notification.error.body | エラー | 選択したロットの一部は他のレコードで使用されています | 一括削除失敗時 |

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|----------|----------|-----------------|
| 削除時の参照整合性エラー | QueryExceptionをキャッチ | 削除失敗通知を表示 |
| 一括削除時の参照整合性エラー | QueryExceptionをキャッチ | 一括削除失敗通知を表示 |

## 備考

- ロット/シリアル番号管理機能はTraceabilitySettings.enable_lots_serial_numbersがtrueの場合のみ有効です
- HasTableViewsトレイトを使用してテーブルビュー機能を実装しています
- 在庫数量（total_quantity）は、内部ロケーション（スクラップ以外）にある商品数量の合計を算出するアクセサとして実装されています
- ロットはLOTトラッキングが設定された商品にのみ関連付け可能です
