# 画面設計書 155-ロット作成

## 概要

本ドキュメントは、Aureus ERPシステムにおけるロット作成画面の設計書です。在庫モジュール内のロット/シリアル番号管理機能において、新規ロットを登録するためのフォーム画面について記述します。

### 本画面の処理概要

**業務上の目的・背景**：製造ロットを新規登録することで、商品のトレーサビリティを確保します。ロット番号は、入荷時や製造時に商品に紐づけることで、品質問題発生時の追跡調査や、先入先出法（FIFO）による在庫管理を実現します。

**画面へのアクセス方法**：メインメニューから「在庫」>「商品」クラスターの「ロット/シリアル番号」を選択し、一覧画面の「作成」ボタンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. ロット名の入力（必須）- ロットを一意に識別する名前
2. 商品の選択（必須）- ロットに紐づける商品（LOTトラッキング設定のみ）
3. 参照コードの入力（オプション）- 外部システムとの連携用
4. 説明の入力（オプション）- ロットに関する詳細情報

**画面遷移**：ロット一覧画面から遷移し、保存後はロット編集画面に遷移します。

**権限による表示制御**：ロット/シリアル番号管理機能が有効な場合（TraceabilitySettings.enable_lots_serial_numbers = true）のみ表示されます。作成権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-030 | ロット一覧 | 遷移元機能 | ロット一覧から作成画面に遷移 |
| FN-INV-011 | 商品管理 | 補助機能 | 商品選択時に参照（LOTトラッキング商品のみ） |

## 画面種別

登録

## URL/ルーティング

`/inventories/products/lots/create`

## 画面構成

- セクション: 一般情報（General）
  - テキスト入力: ロット名（大サイズ表示）
  - グループ（2カラム）:
    - セレクトボックス: 商品（検索可能、ヒントアイコン付き）
    - テキスト入力: 参照（ヒントアイコン付き）
    - リッチエディター: 説明（2カラム幅）
- ヘッダーナビゲーション: クラスター内の他リソースへの遷移タブ
- フォーム送信ボタン

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 初期値 | 入力形式/制約 | 説明 |
|--------|--------|----------|------|--------|---------------|------|
| ロット名 | name | string | Yes | - | 最大255文字、自動フォーカス、大サイズ表示 | ロットを一意に識別する名前 |
| 商品 | product_id | integer | Yes | - | セレクト（検索可能）、LOTトラッキング商品のみ | ロットに紐づける商品 |
| 参照 | reference | string | No | - | 最大255文字 | 外部システムとの連携用参照コード |
| 説明 | description | text | No | - | リッチテキスト形式 | ロットに関する詳細情報 |
| 作成者ID | creator_id | integer | - | ログインユーザー | 自動設定 | システムが自動的に設定 |
| 会社ID | company_id | integer | - | ユーザーのデフォルト会社 | 自動設定 | システムが自動的に設定 |

## 表示項目

なし（登録フォーム画面のため）

## イベント仕様

### 1-保存ボタン押下

フォームに入力された情報を検証し、ロットレコードを新規作成します。

- 処理フロー:
  1. 入力値のバリデーション実行
  2. creator_idにログインユーザーIDを設定
  3. company_idにユーザーのデフォルト会社IDを設定
  4. inventories_lotsテーブルにINSERT
  5. 成功通知を表示
  6. ロット編集画面にリダイレクト

### 2-商品選択

商品セレクトボックスで商品を選択します。LOTトラッキングが設定された商品のみが選択肢として表示されます。

- フィルター条件:
  - tracking = ProductTracking::LOT
  - is_configurable = null（コンフィグ可能商品は除外）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | inventories_lots | INSERT | 新規ロットレコードを作成 |

### テーブル別更新項目詳細

#### inventories_lots

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | product_id | フォーム選択値 | 必須、LOTトラッキング商品のみ |
| INSERT | reference | フォーム入力値 | NULL可 |
| INSERT | description | フォーム入力値 | NULL可、HTML形式 |
| INSERT | creator_id | Auth::id() | ログインユーザーID |
| INSERT | company_id | Auth::user()->default_company_id | ユーザーのデフォルト会社 |
| INSERT | created_at | now() | 自動設定 |
| INSERT | updated_at | now() | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| create-lot.notification.title | 成功 | ロットが作成されました | 保存成功時 |
| create-lot.notification.body | 成功 | ロットの作成に成功しました | 保存成功時 |

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|----------|----------|-----------------|
| 必須項目未入力 | バリデーションエラー | 該当フィールドにエラーメッセージ表示 |
| ロット名が255文字超過 | バリデーションエラー | 文字数制限エラーメッセージ表示 |
| 参照が255文字超過 | バリデーションエラー | 文字数制限エラーメッセージ表示 |
| データベースエラー | 例外をキャッチ | システムエラー通知を表示 |

## 備考

- ロット/シリアル番号管理機能はTraceabilitySettings.enable_lots_serial_numbersがtrueの場合のみ有効です
- 商品セレクトボックスはProductTracking::LOTトラッキングが設定された商品のみ表示されます
- 一部の画面（EditReceipt、EditDelivery、ManageQuantities等）では商品選択フィールドは非表示になります（hiddenOn設定）
- ロット名入力フィールドは強調表示されるよう、カスタムスタイル（font-size: 1.5rem; height: 3rem）が適用されています
- 商品と参照フィールドにはヒントアイコン（?マーク）が付いており、ツールチップで詳細説明が表示されます
