# 画面設計書 156-ロット編集

## 概要

本ドキュメントは、Aureus ERPシステムにおけるロット編集画面の設計書です。在庫モジュール内のロット/シリアル番号管理機能において、既存ロットの情報を編集するためのフォーム画面について記述します。

### 本画面の処理概要

**業務上の目的・背景**：登録済みロットの情報を更新する必要がある場合に使用します。ロット名の変更、参照コードの修正、説明の更新などを行います。また、ロットのバーコードラベル印刷やロットの削除も本画面から実行可能です。

**画面へのアクセス方法**：ロット一覧画面で対象ロットの行アクションメニューから「編集」を選択するか、ロット詳細画面のサブナビゲーションから「編集」タブをクリックしてアクセスします。

**主要な操作・処理内容**：
1. ロット名の変更
2. 商品の変更（変更時は既存商品との関連確認が必要）
3. 参照コードの修正
4. 説明の更新
5. ロットバーコードラベルの印刷
6. ロットの削除

**画面遷移**：ロット一覧画面または詳細画面から遷移し、保存後は編集画面に留まります。サブナビゲーションから詳細画面、在庫数量管理画面にも遷移可能です。

**権限による表示制御**：ロット/シリアル番号管理機能が有効な場合（TraceabilitySettings.enable_lots_serial_numbers = true）のみ表示されます。編集権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-030 | ロット一覧 | 遷移元機能 | 一覧から編集画面に遷移 |
| FN-INV-033 | ロット詳細 | 遷移元/先機能 | サブナビゲーションで相互遷移 |
| FN-INV-034 | 在庫数量管理 | 遷移先機能 | サブナビゲーションから遷移 |

## 画面種別

編集

## URL/ルーティング

`/inventories/products/lots/{record}/edit`

## 画面構成

- ヘッダーアクション:
  - 印刷ボタン
  - 削除ボタン
- セクション: 一般情報（General）
  - テキスト入力: ロット名（大サイズ表示）
  - グループ（2カラム）:
    - セレクトボックス: 商品（検索可能、ヒントアイコン付き）
    - テキスト入力: 参照（ヒントアイコン付き）
    - リッチエディター: 説明（2カラム幅）
- サブナビゲーション: 詳細/編集/在庫数量
- フォーム送信ボタン

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 初期値 | 入力形式/制約 | 説明 |
|--------|--------|----------|------|--------|---------------|------|
| ロット名 | name | string | Yes | 既存値 | 最大255文字、大サイズ表示 | ロットを一意に識別する名前 |
| 商品 | product_id | integer | Yes | 既存値 | セレクト（検索可能）、LOTトラッキング商品のみ | ロットに紐づける商品 |
| 参照 | reference | string | No | 既存値 | 最大255文字 | 外部システムとの連携用参照コード |
| 説明 | description | text | No | 既存値 | リッチテキスト形式 | ロットに関する詳細情報 |

## 表示項目

なし（編集フォーム画面のため、入出力項目として既存値が表示される）

## イベント仕様

### 1-保存ボタン押下

フォームに入力された情報を検証し、ロットレコードを更新します。

- 処理フロー:
  1. 入力値のバリデーション実行
  2. inventories_lotsテーブルをUPDATE
  3. 成功通知を表示
  4. 編集画面に留まる

### 2-印刷ボタン押下

ロットのバーコードラベルをPDF形式で出力します。

- 処理フロー:
  1. PDFビュー（print）を読み込み
  2. 対象ロットをコレクションとして渡す
  3. A4縦サイズでPDFを生成
  4. 「Lot-{ロット名}.pdf」としてダウンロード
  5. ロット名のスラッシュはアンダースコアに置換

### 3-削除ボタン押下

ロットを削除します。

- 処理フロー:
  1. 確認ダイアログを表示
  2. 削除確定時、inventories_lotsテーブルからDELETE
  3. 成功時: 成功通知を表示し、一覧画面にリダイレクト
  4. 失敗時（参照整合性エラー）: エラー通知を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | inventories_lots | UPDATE | ロットレコードを更新 |
| 削除ボタン押下 | inventories_lots | DELETE | ロットレコードを削除 |

### テーブル別更新項目詳細

#### inventories_lots

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | product_id | フォーム選択値 | 必須、LOTトラッキング商品のみ |
| UPDATE | reference | フォーム入力値 | NULL可 |
| UPDATE | description | フォーム入力値 | NULL可、HTML形式 |
| UPDATE | updated_at | now() | 自動設定 |
| DELETE | - | WHERE id = {record_id} | 物理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| edit-lot.notification.title | 成功 | ロットが更新されました | 保存成功時 |
| edit-lot.notification.body | 成功 | ロットの更新に成功しました | 保存成功時 |
| delete.notification.success.title | 成功 | ロットが削除されました | 削除成功時 |
| delete.notification.success.body | 成功 | ロットの削除に成功しました | 削除成功時 |
| delete.notification.error.title | エラー | 削除できません | 削除失敗時 |
| delete.notification.error.body | エラー | このロットは他のレコードで使用されています | 削除失敗時（参照整合性エラー） |

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|----------|----------|-----------------|
| 必須項目未入力 | バリデーションエラー | 該当フィールドにエラーメッセージ表示 |
| ロット名が255文字超過 | バリデーションエラー | 文字数制限エラーメッセージ表示 |
| 削除時の参照整合性エラー | QueryExceptionをキャッチ | 削除失敗通知を表示 |
| レコードが存在しない | 404エラー | ページが見つかりません |

## 備考

- ロット/シリアル番号管理機能はTraceabilitySettings.enable_lots_serial_numbersがtrueの場合のみ有効です
- HasRecordNavigationTabsトレイトを使用してサブナビゲーションを実装しています
- PDF生成にはbarryvdh/laravel-dompdfを使用しています
- ロット名にスラッシュが含まれる場合、PDFファイル名ではアンダースコアに置換されます（例: LOT/2024/001 -> Lot-LOT_2024_001.pdf）
- 削除時の参照整合性エラーはQueryExceptionでハンドリングされ、ユーザーフレンドリーなエラーメッセージが表示されます
- サブナビゲーションにはViewLot、EditLot、ManageQuantitiesの3画面が含まれます
