# 画面設計書 157-ロット詳細

## 概要

本ドキュメントは、Aureus ERPシステムにおけるロット詳細画面の設計書です。在庫モジュール内のロット/シリアル番号管理機能において、ロットの詳細情報を閲覧するための画面について記述します。

### 本画面の処理概要

**業務上の目的・背景**：登録済みロットの詳細情報を確認するために使用します。ロットの基本情報（名前、商品、参照、説明）、在庫数量、所属会社、レコード情報（作成日時、作成者、更新日時）など、ロットに関する包括的な情報を一覧表示します。

**画面へのアクセス方法**：ロット一覧画面で対象ロットの行をクリック、または行アクションメニューから「詳細」を選択してアクセスします。

**主要な操作・処理内容**：
1. ロット基本情報の閲覧
2. ロットバーコードラベルの印刷
3. ロットの削除
4. 関連画面（編集/在庫数量管理）への遷移

**画面遷移**：ロット一覧画面から遷移します。サブナビゲーションから編集画面、在庫数量管理画面に遷移可能です。

**権限による表示制御**：ロット/シリアル番号管理機能が有効な場合（TraceabilitySettings.enable_lots_serial_numbers = true）のみ表示されます。閲覧権限を持つユーザーがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-030 | ロット一覧 | 遷移元機能 | 一覧から詳細画面に遷移 |
| FN-INV-032 | ロット編集 | 遷移先機能 | サブナビゲーションから編集画面に遷移 |
| FN-INV-034 | 在庫数量管理 | 遷移先機能 | サブナビゲーションから遷移 |

## 画面種別

詳細

## URL/ルーティング

`/inventories/products/lots/{record}`

## 画面構成

- ヘッダーアクション:
  - 印刷ボタン
  - 削除ボタン
- セクション: 一般情報（2カラム幅）
  - テキストエントリ: ロット名（大サイズ、太字、アイコン付き）
  - グリッド（2カラム）:
    - テキストエントリ: 商品（アイコン付き）
    - テキストエントリ: 参照（アイコン付き、プレースホルダー「—」）
  - テキストエントリ: 説明（HTML表示、プレースホルダー「—」）
  - グリッド（2カラム）:
    - テキストエントリ: 在庫数量（バッジ表示、アイコン付き）
    - テキストエントリ: 会社（アイコン付き）
- セクション: レコード情報（1カラム幅）
  - テキストエントリ: 作成日時（アイコン付き）
  - テキストエントリ: 作成者（アイコン付き）
  - テキストエントリ: 最終更新日時（アイコン付き）
- サブナビゲーション: 詳細/編集/在庫数量

## 入出力項目

なし（詳細表示画面のため入力項目なし）

## 表示項目

| 項目名 | 項目ID | データ型 | 取得元 | 表示形式 |
|--------|--------|----------|--------|----------|
| ロット名 | name | string | inventories_lots.name | テキスト、大サイズ、太字、rectangle-stackアイコン |
| 商品 | product.name | string | products.name | テキスト、cubeアイコン |
| 参照 | reference | string | inventories_lots.reference | テキスト、document-textアイコン、プレースホルダー「—」 |
| 説明 | description | text | inventories_lots.description | HTML形式、プレースホルダー「—」 |
| 在庫数量 | total_quantity | decimal | 計算値 | バッジ形式、calculatorアイコン |
| 会社 | company.name | string | companies.name | テキスト、building-officeアイコン |
| 作成日時 | created_at | datetime | inventories_lots.created_at | 日時形式、calendarアイコン |
| 作成者 | creator.name | string | users.name | テキスト、userアイコン |
| 最終更新日時 | updated_at | datetime | inventories_lots.updated_at | 日時形式、calendar-daysアイコン |

## イベント仕様

### 1-印刷ボタン押下

ロットのバーコードラベルをPDF形式で出力します。

- 処理フロー:
  1. PDFビュー（print）を読み込み
  2. 対象ロットをコレクションとして渡す
  3. A4縦サイズでPDFを生成
  4. 「Lot-{ロット名}.pdf」としてダウンロード
  5. ロット名のスラッシュはアンダースコアに置換

### 2-削除ボタン押下

ロットを削除します。

- 処理フロー:
  1. 確認ダイアログを表示
  2. 削除確定時、inventories_lotsテーブルからDELETE
  3. 成功時: 成功通知を表示し、一覧画面にリダイレクト
  4. 失敗時（参照整合性エラー）: エラー通知を表示

### 3-サブナビゲーション遷移

サブナビゲーションタブをクリックして関連画面に遷移します。

- 遷移先:
  - 詳細: ViewLot（現在の画面）
  - 編集: EditLot
  - 在庫数量: ManageQuantities

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | inventories_lots | DELETE | ロットレコードを削除 |

### テーブル別更新項目詳細

#### inventories_lots

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = {record_id} | 物理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| delete.notification.success.title | 成功 | ロットが削除されました | 削除成功時 |
| delete.notification.success.body | 成功 | ロットの削除に成功しました | 削除成功時 |
| delete.notification.error.title | エラー | 削除できません | 削除失敗時 |
| delete.notification.error.body | エラー | このロットは他のレコードで使用されています | 削除失敗時（参照整合性エラー） |

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|----------|----------|-----------------|
| レコードが存在しない | 404エラー | ページが見つかりません |
| 削除時の参照整合性エラー | QueryExceptionをキャッチ | 削除失敗通知を表示 |

## 備考

- ロット/シリアル番号管理機能はTraceabilitySettings.enable_lots_serial_numbersがtrueの場合のみ有効です
- HasRecordNavigationTabsトレイトを使用してサブナビゲーションを実装しています
- 表示はInfolist形式で実装されており、3カラムレイアウト（メイン2カラム + サイドバー1カラム）で構成されています
- PDF生成にはbarryvdh/laravel-dompdfを使用しています
- 在庫数量（total_quantity）は、内部ロケーション（スクラップ以外）にある商品数量の合計を算出するアクセサとして実装されています
- 説明フィールドはHTML形式で保存されているため、html()メソッドでレンダリングされます
