# 画面設計書 158-入庫一覧

## 概要

本ドキュメントは、Aureus ERPシステムにおける入庫一覧画面の設計書です。在庫モジュール内のオペレーション管理機能において、登録済み入庫（Receipt）オペレーションを一覧表示・検索・操作するための画面について記述します。

### 本画面の処理概要

**業務上の目的・背景**：入庫（Receipt）は、サプライヤーからの商品受け入れや、他の倉庫からの在庫移動時に使用されるオペレーションです。本画面では、入庫オペレーションの進捗状況を一覧で確認し、処理待ち・処理中・完了済みの入庫を管理します。

**画面へのアクセス方法**：メインメニューから「在庫」>「オペレーション」クラスターの「入庫」を選択してアクセスします。

**主要な操作・処理内容**：
1. 入庫オペレーション一覧の表示（ページネーション付き）
2. 入庫オペレーションの検索・フィルタリング（高度なクエリビルダー対応）
3. 入庫オペレーションのグループ化表示
4. 入庫オペレーションの詳細/編集画面への遷移
5. 入庫オペレーションの削除（完了済み以外）
6. 一括削除（完了済み以外）
7. プリセットビュー（ToDo/My/Starred/Draft/Waiting/Ready/Done/Canceled）

**画面遷移**：メインメニューから直接遷移します。一覧から詳細画面、編集画面、作成画面に遷移可能です。

**権限による表示制御**：アクセス権限を持つユーザーのみ表示されます。完了済みオペレーションは削除不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-041 | 入庫作成 | 遷移先機能 | 一覧から作成画面に遷移 |
| FN-INV-042 | 入庫編集 | 遷移先機能 | 一覧から編集画面に遷移 |
| FN-INV-043 | 入庫詳細 | 遷移先機能 | 一覧から詳細画面に遷移 |

## 画面種別

一覧

## URL/ルーティング

`/inventories/operations/receipts`

## 画面構成

- ヘッダーアクション:
  - 作成ボタン
- プリセットビュー: ToDo/My/Starred/Draft/Waiting/Ready/Done/Canceled
- テーブル:
  - カラム: お気に入り、参照番号、元ロケーション、先ロケーション、取引先、担当者、予定日、期限、完了日、ソースドキュメント、オペレーションタイプ、会社、ステータス
  - グループ化: ステータス/ソースドキュメント/オペレーションタイプ/予定日/作成日
  - フィルター: QueryBuilder形式の高度なフィルター
  - 行アクション: 詳細/編集/削除
  - 一括アクション: 一括削除
- サブナビゲーション: クラスター内の他リソースへのタブ

## 入出力項目

なし（一覧画面のため入力項目なし）

## 表示項目

| 項目名 | 項目ID | データ型 | 取得元 | 表示形式 |
|--------|--------|----------|--------|----------|
| お気に入り | is_favorite | boolean | inventories_operations.is_favorite | アイコン（星）、クリックでトグル |
| 参照番号 | name | string | inventories_operations.name | テキスト、検索・ソート可 |
| 元ロケーション | sourceLocation.full_name | string | inventories_locations.full_name | テキスト、ソート可、デフォルト非表示 |
| 先ロケーション | destinationLocation.full_name | string | inventories_locations.full_name | テキスト、ソート可、デフォルト非表示 |
| 取引先 | partner.name | string | partners.name | テキスト、検索・ソート可、プレースホルダー「—」 |
| 担当者 | user.name | string | users.name | テキスト、ソート可、デフォルト非表示 |
| 予定日 | scheduled_at | datetime | inventories_operations.scheduled_at | 日時形式、ソート可、プレースホルダー「—」 |
| 期限 | deadline | datetime | inventories_operations.deadline | 日時形式、ソート可、デフォルト非表示 |
| 完了日 | closed_at | datetime | inventories_operations.closed_at | 日時形式、ソート可、デフォルト非表示 |
| ソースドキュメント | origin | string | inventories_operations.origin | テキスト、検索・ソート可、プレースホルダー「—」 |
| オペレーションタイプ | operationType.name | string | inventories_operation_types.name | テキスト、ソート可、デフォルト非表示 |
| 会社 | company.name | string | companies.name | テキスト、ソート可、プレースホルダー「—」 |
| ステータス | state | enum | inventories_operations.state | バッジ形式、ソート可 |

## イベント仕様

### 1-作成ボタン押下

入庫作成画面に遷移します。

- 処理フロー:
  1. /inventories/operations/receipts/createにリダイレクト

### 2-行アクション：詳細

選択した入庫の詳細画面に遷移します。

- 処理フロー:
  1. /inventories/operations/receipts/{record}/viewにリダイレクト

### 3-行アクション：編集

選択した入庫の編集画面に遷移します。

- 処理フロー:
  1. /inventories/operations/receipts/{record}/editにリダイレクト

### 4-行アクション：削除

選択した入庫を削除します。完了済み（DONE）の入庫は削除不可。

- 処理フロー:
  1. ステータスがDONEの場合は非表示
  2. 確認ダイアログを表示
  3. 削除確定時、inventories_operationsテーブルからDELETE
  4. 成功時: 成功通知を表示
  5. 失敗時（参照整合性エラー）: エラー通知を表示

### 5-一括アクション：削除

選択した入庫を一括削除します。完了済み（DONE）の入庫は選択不可。

- 処理フロー:
  1. ステータスがDONEのレコードはチェックボックス無効
  2. 確認ダイアログを表示
  3. 削除確定時、選択された各レコードをDELETE
  4. 成功時: 成功通知を表示
  5. 失敗時（参照整合性エラー）: エラー通知を表示

### 6-お気に入りトグル

お気に入りアイコンをクリックしてお気に入り状態を切り替えます。

- 処理フロー:
  1. is_favoriteフィールドをトグル
  2. inventories_operationsテーブルをUPDATE

### 7-プリセットビュー切り替え

プリセットビュータブをクリックして表示を切り替えます。

- プリセットビュー:
  - ToDo: state NOT IN (DONE, CANCELED)
  - My: user_id = 現在のユーザーID
  - Starred: is_favorite = true
  - Draft: state = DRAFT
  - Waiting: state = CONFIRMED
  - Ready: state = ASSIGNED
  - Done: state = DONE
  - Canceled: state = CANCELED

### 8-グループ化変更

テーブルの表示をグループ化します。

- グループ化オプション:
  - ステータス（state）
  - ソースドキュメント（origin）
  - オペレーションタイプ（operationType.name）
  - 予定日（scheduled_at）- 日付単位
  - 作成日（created_at）- 日付単位

### 9-フィルター適用

QueryBuilder形式の高度なフィルターを適用します。

- フィルターオプション:
  - 参照番号（name）- テキスト
  - ステータス（state）- 複数選択
  - 取引先（partner）- リレーション
  - 担当者（user）- リレーション
  - オーナー（owner）- リレーション
  - 元ロケーション（sourceLocation）- リレーション（ロケーション有効時のみ）
  - 先ロケーション（destinationLocation）- リレーション（ロケーション有効時のみ）
  - 期限（deadline）- 日付
  - 予定日（scheduled_at）- 日付
  - 完了日（closed_at）- 日付
  - 作成日（created_at）- 日付
  - 更新日（updated_at）- 日付
  - 会社（company）- リレーション
  - 作成者（creator）- リレーション

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 行アクション：削除 | inventories_operations | DELETE | 単一入庫オペレーションを削除 |
| 一括アクション：削除 | inventories_operations | DELETE | 複数入庫オペレーションを一括削除 |
| お気に入りトグル | inventories_operations | UPDATE | is_favoriteフィールドを更新 |

### テーブル別更新項目詳細

#### inventories_operations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = {record_id} | 物理削除、state != DONE |
| DELETE | - | WHERE id IN ({record_ids}) | 一括削除、state != DONE |
| UPDATE | is_favorite | !is_favorite | トグル |
| UPDATE | updated_at | now() | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| delete.notification.success.title | 成功 | 入庫が削除されました | 削除成功時 |
| delete.notification.success.body | 成功 | 入庫の削除に成功しました | 削除成功時 |
| delete.notification.error.title | エラー | 削除できません | 削除失敗時 |
| delete.notification.error.body | エラー | この入庫は他のレコードで使用されています | 削除失敗時（参照整合性エラー） |
| bulk-delete.notification.success.title | 成功 | 入庫が削除されました | 一括削除成功時 |
| bulk-delete.notification.success.body | 成功 | 選択した入庫の削除に成功しました | 一括削除成功時 |
| bulk-delete.notification.error.title | エラー | 削除できません | 一括削除失敗時 |
| bulk-delete.notification.error.body | エラー | 選択した入庫の一部は他のレコードで使用されています | 一括削除失敗時 |

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|----------|----------|-----------------|
| 削除時の参照整合性エラー | QueryExceptionをキャッチ | 削除失敗通知を表示 |
| 一括削除時の参照整合性エラー | QueryExceptionをキャッチ | 一括削除失敗通知を表示 |

## 備考

- 入庫オペレーションはoperationType.type = INCOMING でフィルタリングされています
- HasTableViewsトレイトを使用してプリセットビュー機能を実装しています
- ロケーション表示はWarehouseSettings.enable_locationsがtrueの場合のみ表示されます
- 完了済み（DONE）のオペレーションは削除不可、チェックボックスも無効化されます
- フィルターはモーダル表示（スライドオーバー）で、2カラムレイアウトで表示されます
- テーブルカラムは並び替え可能（reorderableColumns）です
- カラムマネージャーで表示カラムをカスタマイズ可能（2カラム表示）
