# 画面設計書 159-入庫作成

## 概要

本ドキュメントは、Aureus ERPシステムにおける入庫作成画面の設計書です。在庫モジュール内のオペレーション管理機能において、新規入庫（Receipt）オペレーションを登録するためのフォーム画面について記述します。

### 本画面の処理概要

**業務上の目的・背景**：入庫（Receipt）オペレーションは、サプライヤーからの商品受け入れを管理するために使用します。入庫オペレーションを作成することで、仕入先からの商品を受け入れ、在庫に計上するための準備を行います。発注書との連携や、入荷予定の管理も本画面から開始されます。

**画面へのアクセス方法**：メインメニューから「在庫」>「オペレーション」クラスターの「入庫」を選択し、一覧画面の「作成」ボタンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 仕入先（受け取り元）の選択（オプション）
2. オペレーションタイプの選択（必須）- 入庫タイプがデフォルト設定
3. 先ロケーションの選択（必須）- オペレーションタイプに応じて自動設定
4. 入庫明細（Moves）の登録
5. 追加情報（担当者、配送ポリシー、予定日、ソースドキュメント）の入力
6. メモの入力

**画面遷移**：入庫一覧画面から遷移し、保存後は入庫編集画面に遷移します。

**権限による表示制御**：アクセス権限を持つユーザーのみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-040 | 入庫一覧 | 遷移元機能 | 入庫一覧から作成画面に遷移 |
| FN-PAR-001 | 取引先管理 | 補助機能 | 仕入先をフォーム内で新規作成可能 |
| FN-INV-024 | ロケーション管理 | 補助機能 | 先ロケーションを選択 |
| FN-INV-011 | 商品管理 | 補助機能 | 入庫明細で商品を選択 |

## 画面種別

登録

## URL/ルーティング

`/inventories/operations/receipts/create`

## 画面構成

- ステータスステッパー: ドラフト/確認済み/準備完了/完了/キャンセル（無効、表示のみ）
- セクション: 一般情報
  - セレクトボックス: 仕入先（受け取り元）（検索可能、新規作成可能）
  - セレクトボックス: オペレーションタイプ（必須、検索可能、倉庫付きで表示）
  - セレクトボックス: 先ロケーション（必須、検索可能、ロケーション有効時のみ）
- タブ:
  - オペレーション: 入庫明細（Movesリピーター）
  - 追加情報: 担当者、配送ポリシー、予定日、ソースドキュメント
  - メモ: リッチエディター
- ヘッダーナビゲーション: クラスター内の他リソースへの遷移タブ
- フォーム送信ボタン

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 初期値 | 入力形式/制約 | 説明 |
|--------|--------|----------|------|--------|---------------|------|
| 仕入先 | partner_id | integer | No | - | セレクト（検索可能）、新規作成可能 | 商品の受け取り元 |
| オペレーションタイプ | operation_type_id | integer | Yes | 入庫タイプ | セレクト（検索可能）、ライブ更新 | オペレーションの種類 |
| 先ロケーション | destination_location_id | integer | Yes | オペレーションタイプのデフォルト | セレクト（検索可能）、ロケーション有効時のみ表示 | 入庫先のロケーション |
| 担当者 | user_id | integer | No | ログインユーザー | セレクト（検索可能） | オペレーションの担当者 |
| 配送ポリシー | move_type | enum | No | DIRECT | セレクト | 配送ポリシー（一括/分割） |
| 予定日 | scheduled_at | datetime | No | 現在日時 | 日時ピッカー | 入庫予定日時 |
| ソースドキュメント | origin | string | No | - | 最大255文字 | 参照元ドキュメント |
| メモ | description | text | No | - | リッチテキスト形式 | オペレーションに関するメモ |

### 入庫明細（Moves）

| 項目名 | 項目ID | データ型 | 必須 | 初期値 | 入力形式/制約 | 説明 |
|--------|--------|----------|------|--------|---------------|------|
| 商品 | product_id | integer | Yes | - | セレクト（検索可能）、重複不可 | 入庫する商品 |
| 最終ロケーション | final_location_id | integer | No | - | セレクト（検索可能）、デフォルト非表示 | 最終保管先ロケーション |
| 説明 | description_picking | string | No | - | 最大255文字、デフォルト非表示 | 明細の説明 |
| 予定日 | scheduled_at | datetime | No | 現在日時 | 日時ピッカー、デフォルト非表示 | 明細の予定日 |
| 期限 | deadline | datetime | No | - | 日時ピッカー、デフォルト非表示 | 明細の期限 |
| パッケージング | product_packaging_id | integer | No | - | セレクト（検索可能）、パッケージング有効時のみ | 商品パッケージング |
| 需要数量 | product_uom_qty | decimal | Yes | 0 | 数値、0以上 | 需要する数量 |
| 単位 | uom_id | integer | Yes | 商品の単位 | セレクト（検索可能）、UOM有効時のみ表示 | 数量の単位 |
| ピック済み | is_picked | boolean | No | false | トグル | ピック済みフラグ |

## 表示項目

なし（登録フォーム画面のため）

## イベント仕様

### 1-保存ボタン押下

フォームに入力された情報を検証し、入庫オペレーションレコードを新規作成します。

- 処理フロー:
  1. 入力値のバリデーション実行
  2. mutateFormDataBeforeCreateで以下を設定:
     - company_id: オペレーションタイプの先ロケーションの会社ID（未設定時）
     - source_location_id: オペレーションタイプのデフォルト元ロケーション（未設定時）
     - destination_location_id: オペレーションタイプのデフォルト先ロケーション（未設定時）
     - state: DRAFT（未設定時）
     - creator_id: ログインユーザーID
  3. inventories_operationsテーブルにINSERT
  4. 成功通知を表示
  5. 入庫編集画面にリダイレクト

### 2-オペレーションタイプ変更

オペレーションタイプを変更すると、元ロケーションと先ロケーションが自動更新されます。

- 処理フロー:
  1. 選択されたオペレーションタイプを取得
  2. source_location_idをオペレーションタイプのデフォルト値に設定
  3. destination_location_idをオペレーションタイプのデフォルト値に設定

### 3-仕入先新規作成

仕入先選択フィールド内で新規取引先を作成できます。

- 処理フロー:
  1. 取引先作成フォームがモーダルで表示
  2. 必要項目を入力して保存
  3. 作成された取引先が自動選択

### 4-商品選択（入庫明細）

入庫明細で商品を選択すると、関連フィールドが自動設定されます。

- 処理フロー:
  1. 選択された商品を取得
  2. uom_idを商品のデフォルト単位に設定
  3. product_qtyを計算して設定
  4. 最適なパッケージングを検索して設定

### 5-需要数量変更（入庫明細）

需要数量を変更すると、製品数量とパッケージングが再計算されます。

- 処理フロー:
  1. 単位に基づいてproduct_qtyを計算
  2. 最適なパッケージングを検索して設定

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | inventories_operations | INSERT | 新規入庫オペレーションを作成 |
| 保存ボタン押下 | inventories_moves | INSERT | 入庫明細を作成（Movesリピーター経由） |
| 仕入先新規作成 | partners | INSERT | 新規取引先を作成 |

### テーブル別更新項目詳細

#### inventories_operations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | partner_id | フォーム選択値 | NULL可 |
| INSERT | operation_type_id | フォーム選択値 | 必須 |
| INSERT | source_location_id | オペレーションタイプのデフォルト | 入庫では通常「仕入先ロケーション」 |
| INSERT | destination_location_id | フォーム選択値 or オペレーションタイプのデフォルト | 必須 |
| INSERT | user_id | フォーム選択値 | NULL可 |
| INSERT | move_type | フォーム選択値 | デフォルトDIRECT |
| INSERT | scheduled_at | フォーム入力値 | デフォルト現在日時 |
| INSERT | origin | フォーム入力値 | NULL可 |
| INSERT | description | フォーム入力値 | NULL可 |
| INSERT | state | DRAFT | 新規作成時は常にDRAFT |
| INSERT | company_id | オペレーションタイプの先ロケーションの会社ID | 自動設定 |
| INSERT | creator_id | Auth::id() | ログインユーザーID |
| INSERT | created_at | now() | 自動設定 |
| INSERT | updated_at | now() | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| create-receipt.notification.title | 成功 | 入庫が作成されました | 保存成功時 |
| create-receipt.notification.body | 成功 | 入庫の作成に成功しました | 保存成功時 |

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|----------|----------|-----------------|
| 必須項目未入力 | バリデーションエラー | 該当フィールドにエラーメッセージ表示 |
| 数量が0未満 | バリデーションエラー | 数量エラーメッセージ表示 |
| データベースエラー | 例外をキャッチ | システムエラー通知を表示 |

## 備考

- 入庫オペレーションはoperationType.type = INCOMING のオペレーションタイプがデフォルトで選択されます
- mountメソッドでオペレーションタイプ、元ロケーション、先ロケーションがデフォルト設定されます
- HasRepeaterColumnManagerトレイトを使用してMovesリピーターのカラム管理を実装しています
- 入庫タイプでは「元ロケーション」フィールドは非表示になります（入庫では仕入先ロケーションが固定のため）
- 商品選択は重複不可（distinct）で、同一オペレーション内で同じ商品を複数回選択することはできません
- 削除済みレコードも選択肢に表示されますが、選択不可になります（(Deleted)ラベル付き）
- 保存後は編集画面にリダイレクトされ、入庫明細の詳細な編集が可能になります
