# 画面設計書 16-クレジットノート作成

## 概要

本ドキュメントは、Aureus ERPシステムにおける「クレジットノート作成」画面の設計仕様を定義するものである。

### 本画面の処理概要

クレジットノート作成画面は、会計モジュールにおいて新規のクレジットノート（返品伝票・貸方票）を作成するための画面である。

**業務上の目的・背景**：顧客への返品処理、請求金額の減額調整、誤請求の訂正などを行う際に、クレジットノートを発行する。これにより、元の請求書に対する減額・返金を正式に記録し、会計上の整合性を保つ。売掛金の調整や顧客との債権債務関係を適切に管理する。

**画面へのアクセス方法**：
1. クレジットノート一覧画面のヘッダーにある「作成」ボタンをクリック
2. 請求書画面の「クレジットノート」アクションから遷移
3. URL直接入力でもアクセス可能

**主要な操作・処理内容**：
1. 顧客の選択
2. 請求日、支払期日/支払条件の入力
3. 明細行（商品、数量、単価、税率等）の入力
4. その他情報（参照、担当者、通貨等）の入力
5. 保存ボタンで登録を確定

**画面遷移**：
- 保存成功時：クレジットノート詳細画面（ViewCreditNote）へ自動遷移
- キャンセル時：クレジットノート一覧画面へ戻る

**権限による表示制御**：Filament Resourceの標準的な権限管理に従い、作成権限を持つユーザーのみが画面にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-ACC-031 | クレジットノート管理 | 主機能 | クレジットノートの新規作成 |
| FN-ACC-052 | クレジットノート管理 | 主機能 | 作成処理 |

## 画面種別

登録

## URL/ルーティング

`/admin/accounts/credit-notes/create`

## 画面構成

1. **ステータスステッパー**
   - ProgressStepper（状態表示、作成時は常にDRAFT）

2. **一般情報セクション**
   - 顧客選択（Select）
   - 請求日（DatePicker）
   - 支払期日/支払条件（DatePicker/Select）

3. **タブエリア**
   - **明細タブ**：商品明細のRepeater、合計サマリー（Livewireコンポーネント）
   - **その他情報タブ**：請求書詳細、会計情報、追加情報、マーケティング情報
   - **利用規約タブ**：備考・メモ（RichEditor）

4. **アクションエリア**
   - 保存ボタン（Filament標準）
   - キャンセルボタン（Filament標準）

## 入出力項目

### 一般セクション

| 項目名 | 物理名 | データ型 | 必須 | 初期値 | 説明 |
|--------|--------|----------|------|--------|------|
| 状態 | state | enum | - | DRAFT | ステータス（作成時は常に下書き） |
| 顧客 | partner_id | integer | 任意 | なし | 顧客ID |
| 請求日 | invoice_date | date | 任意 | 現在日 | 請求日 |
| 支払期日 | invoice_date_due | date | 条件付き | 現在日 | 支払期限（支払条件未設定時は必須） |
| 支払条件 | invoice_payment_term_id | integer | 条件付き | なし | 支払条件ID（支払期日未設定時は必須） |

### 明細行（products）

| 項目名 | 物理名 | データ型 | 必須 | 初期値 | 説明 |
|--------|--------|----------|------|--------|------|
| 商品 | product_id | integer | 必須 | なし | 商品ID |
| 数量 | quantity | numeric | 必須 | 1 | 数量 |
| 単位 | uom_id | integer | 必須 | なし | 単位ID |
| 税率 | taxes | array | 任意 | なし | 適用税率ID配列 |
| 割引率 | discount | numeric | 任意 | 0 | 割引パーセンテージ |
| 単価 | price_unit | numeric | 必須 | 0 | 単価 |
| 小計 | price_subtotal | numeric | - | 0 | 計算値 |

### その他情報

| 項目名 | 物理名 | データ型 | 必須 | 初期値 | 説明 |
|--------|--------|----------|------|--------|------|
| 顧客参照 | reference | string | 任意 | なし | 顧客参照番号 |
| 担当者 | invoice_user_id | integer | 任意 | なし | 営業担当者ID |
| 受取銀行 | partner_bank_id | integer | 任意 | なし | 銀行口座ID |
| 支払参照 | payment_reference | string | 任意 | なし | 支払参照 |
| 納品日 | delivery_date | date | 任意 | なし | 納品日 |
| インコターム | invoice_incoterm_id | integer | 任意 | なし | インコタームID |
| インコターム場所 | incoterm_location | string | 任意 | なし | インコターム適用場所 |
| 支払方法 | preferred_payment_method_line_id | integer | 任意 | なし | 支払方法ID |
| 自動転記 | auto_post | boolean | 任意 | false | 自動転記フラグ |
| 確認済み | checked | boolean | 任意 | false | 確認フラグ |
| 会社 | company_id | integer | 任意 | ログインユーザーの会社 | 会社ID |
| 通貨 | currency_id | integer | 必須 | 会社の通貨 | 通貨ID |
| キャンペーン | campaign_id | integer | 任意 | なし | キャンペーンID |
| メディア | medium_id | integer | 任意 | なし | メディアID |
| ソース | source_id | integer | 任意 | なし | ソースID |
| 備考 | narration | text | 任意 | なし | 利用規約・備考 |

## 表示項目

該当なし（登録画面のため出力専用項目なし）

## イベント仕様

### 1-顧客選択時

顧客選択後、以下のフィールドが自動設定される：
- 担当者（invoice_user_id）：顧客に関連付けられたユーザー
- 支払方法（preferred_payment_method_line_id）：顧客のデフォルト支払方法
- 支払条件（invoice_payment_term_id）：顧客のデフォルト支払条件

### 2-商品選択時

商品選択後、以下が自動設定される：
- 単位（uom_id）：商品のデフォルト単位
- 単価（price_unit）：商品の価格
- 税率（taxes）：商品に設定された税率
- 小計が自動計算される

### 3-数量・単価・割引・税率変更時

明細行の金額関連フィールド変更時、小計（price_subtotal）、税額（price_tax）、合計（price_total）が自動再計算される。

### 4-会社選択時

会社選択後、通貨（currency_id）がその会社のデフォルト通貨に自動設定される。

### 5-保存ボタン押下

フォーム内容をバリデーション後、データベースに新規レコードを作成する。作成後にAccount::computeAccountMoveで会計計算が実行される。成功時は詳細画面へ遷移。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_account_moves | INSERT | ヘッダーレコードの作成 |
| 保存ボタン押下 | accounts_account_move_lines | INSERT | 明細レコードの作成 |

### テーブル別更新項目詳細

#### accounts_account_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | move_type | OUT_REFUND | mutateFormDataBeforeCreateで設定 |
| INSERT | date | 現在日時 | mutateFormDataBeforeCreateで設定 |
| INSERT | partner_id | フォーム入力値 | - |
| INSERT | invoice_date | フォーム入力値 | - |
| INSERT | その他全フィールド | フォーム入力値 | - |
| INSERT | created_at | 現在日時 | 自動設定 |
| INSERT | updated_at | 現在日時 | 自動設定 |

#### accounts_account_move_lines

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | move_id | 親レコードID | Repeaterで自動関連付け |
| INSERT | product_id | フォーム入力値 | - |
| INSERT | quantity | フォーム入力値 | - |
| INSERT | price_unit | フォーム入力値 | - |
| INSERT | その他フィールド | フォーム入力値または計算値 | - |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 成功 | 作成成功通知（タイトル・本文） | レコード作成成功時 |
| エラー | バリデーションエラー | 必須項目未入力時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| バリデーションエラー | エラーメッセージを該当フィールドに表示 |
| データベースエラー | Filament標準のエラー処理 |
| 権限不足 | アクセス拒否エラー表示 |

## 備考

- CreateCreditNoteはCreateInvoiceを継承しており、フォーム構成は請求書作成と同一
- move_typeはOUT_REFUND（顧客向けクレジットノート）がデフォルトで設定される
- 保存後にAccount::computeAccountMoveメソッドで会計計算（税額、合計等）が実行される
- InvoiceSummaryはLivewireコンポーネントで、明細の合計をリアルタイム表示する
- ProductSettingsによりUOM（単位）フィールドの表示/非表示が制御される
- 削除された顧客/商品は選択肢に表示されるが、選択不可（Deleted表示）
