# 画面設計書 160-入庫編集

## 概要

本ドキュメントは、Aureus ERPシステムにおける入庫編集画面の設計書です。在庫モジュール内のオペレーション管理機能において、既存入庫（Receipt）オペレーションの情報を編集・処理するためのフォーム画面について記述します。

### 本画面の処理概要

**業務上の目的・背景**：登録済み入庫オペレーションの編集および処理を行います。入庫明細の追加・変更、数量の調整、検証（バリデート）による在庫計上、キャンセル処理、返品処理など、入庫ライフサイクルの全ての操作を本画面から実行します。

**画面へのアクセス方法**：入庫一覧画面で対象入庫の行アクションメニューから「編集」を選択するか、入庫詳細画面のサブナビゲーションから「編集」タブをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 入庫情報の編集（仕入先、オペレーションタイプ、ロケーションなど）
2. 入庫明細（Moves）の追加・編集・削除
3. 明細行の詳細設定（ロット/シリアル番号、パッケージ、数量など）
4. ToDo操作（明細の数量設定）
5. 検証（Validate）操作 - 在庫を計上
6. キャンセル操作
7. 返品操作
8. 各種印刷（ピッキングオペレーション/納品書/パッケージ/ラベル）
9. チャッター（コメント・履歴）
10. 入庫の削除（完了済み以外）

**画面遷移**：入庫一覧画面または詳細画面から遷移し、保存後は編集画面に留まります。サブナビゲーションから詳細画面、移動管理画面にも遷移可能です。

**権限による表示制御**：アクセス権限を持つユーザーのみ表示されます。完了済み・キャンセル済みのオペレーションは一部フィールドが編集不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-040 | 入庫一覧 | 遷移元機能 | 一覧から編集画面に遷移 |
| FN-INV-043 | 入庫詳細 | 遷移元/先機能 | サブナビゲーションで相互遷移 |
| FN-INV-044 | 移動管理 | 遷移先機能 | サブナビゲーションから遷移 |
| FN-INV-031 | ロット管理 | 補助機能 | 明細行でロットを選択・作成 |
| FN-INV-021 | パッケージ管理 | 補助機能 | 明細行でパッケージを選択・作成 |

## 画面種別

編集

## URL/ルーティング

`/inventories/operations/receipts/{record}/edit`

## 画面構成

- ステータスステッパー: ドラフト/確認済み/準備完了/完了/キャンセル（無効、表示のみ）
- ヘッダーアクション:
  - チャッターボタン
  - ToDoボタン
  - 検証ボタン
  - キャンセルボタン
  - 返品ボタン
  - 印刷ボタン（ドロップダウン）
    - ピッキングオペレーション印刷
    - 納品書印刷
    - パッケージ印刷
    - ラベル印刷
  - 削除ボタン（完了済み以外）
- セクション: 一般情報
  - セレクトボックス: 仕入先（検索可能、新規作成可能）
  - セレクトボックス: オペレーションタイプ（必須、検索可能）
  - セレクトボックス: 先ロケーション（必須、検索可能）
- タブ:
  - オペレーション: 入庫明細（Movesリピーター）
  - 追加情報: 担当者、配送ポリシー、予定日、ソースドキュメント
  - メモ: リッチエディター
- サブナビゲーション: 詳細/編集/移動

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 初期値 | 入力形式/制約 | 説明 |
|--------|--------|----------|------|--------|---------------|------|
| 仕入先 | partner_id | integer | No | 既存値 | セレクト、完了/キャンセル時は無効 | 商品の受け取り元 |
| オペレーションタイプ | operation_type_id | integer | Yes | 既存値 | セレクト、完了/キャンセル時は無効 | オペレーションの種類 |
| 先ロケーション | destination_location_id | integer | Yes | 既存値 | セレクト、完了/キャンセル時は無効 | 入庫先のロケーション |
| 担当者 | user_id | integer | No | 既存値 | セレクト、完了/キャンセル時は無効 | オペレーションの担当者 |
| 配送ポリシー | move_type | enum | No | 既存値 | セレクト、完了/キャンセル時は無効 | 配送ポリシー |
| 予定日 | scheduled_at | datetime | No | 既存値 | 日時ピッカー、完了/キャンセル時は無効 | 入庫予定日時 |
| ソースドキュメント | origin | string | No | 既存値 | 完了/キャンセル時は無効 | 参照元ドキュメント |
| メモ | description | text | No | 既存値 | リッチテキスト | オペレーションに関するメモ |

### 入庫明細（Moves）

| 項目名 | 項目ID | データ型 | 必須 | 入力形式/制約 | 説明 |
|--------|--------|----------|------|---------------|------|
| 商品 | product_id | integer | Yes | ドラフト時のみ編集可 | 入庫する商品 |
| 最終ロケーション | final_location_id | integer | No | 完了/キャンセル時は無効 | 最終保管先ロケーション |
| 説明 | description_picking | string | No | 完了/キャンセル時は無効 | 明細の説明 |
| 予定日 | scheduled_at | datetime | No | 完了/キャンセル時は無効 | 明細の予定日 |
| 期限 | deadline | datetime | No | 完了/キャンセル時は無効 | 明細の期限 |
| パッケージング | product_packaging_id | integer | No | 完了/キャンセル時は無効 | 商品パッケージング |
| 需要数量 | product_uom_qty | decimal | Yes | ドラフト時のみ編集可 | 需要する数量 |
| 数量 | quantity | decimal | Yes | 保存済み明細のみ表示、完了/キャンセル時は無効 | 実際に受け取る数量 |
| 単位 | uom_id | integer | Yes | 完了/キャンセル時は無効 | 数量の単位 |
| ピック済み | is_picked | boolean | No | 完了/キャンセル時は無効 | ピック済みフラグ |

## 表示項目

なし（編集フォーム画面のため、入出力項目として既存値が表示される）

## イベント仕様

### 1-保存ボタン押下

フォームに入力された情報を検証し、入庫オペレーションレコードを更新します。

- 処理フロー:
  1. 入力値のバリデーション実行
  2. inventories_operationsテーブルをUPDATE
  3. Movesリピーターの変更を保存
  4. 成功通知を表示
  5. 編集画面に留まる

### 2-チャッターボタン押下

チャッターサイドパネルを開き、コメントや履歴を表示します。

- 処理フロー:
  1. チャッターモーダルを開く
  2. コメントの追加・閲覧が可能
  3. 活動履歴の確認が可能

### 3-ToDoボタン押下

入庫明細の数量を一括設定するアクションを実行します。

- 処理フロー:
  1. 各明細の数量を需要数量と同じ値に設定
  2. 在庫移動の計算を実行

### 4-検証ボタン押下

入庫オペレーションを検証し、在庫を計上します。

- 処理フロー:
  1. 全ての明細が正しく設定されているか検証
  2. 在庫数量を更新（inventories_quantitiesテーブル）
  3. ステータスをDONEに更新
  4. closed_atを現在日時に設定
  5. 成功通知を表示

### 5-キャンセルボタン押下

入庫オペレーションをキャンセルします。

- 処理フロー:
  1. 確認ダイアログを表示
  2. ステータスをCANCELEDに更新
  3. 関連する明細もキャンセル状態に更新

### 6-返品ボタン押下

入庫に対する返品オペレーションを作成します。

- 処理フロー:
  1. 返品オペレーション作成ダイアログを表示
  2. 返品数量を入力
  3. 新規返品オペレーションを作成
  4. 元オペレーションとの関連付けを設定

### 7-印刷アクション

各種帳票をPDF形式で出力します。

- 印刷オプション:
  - ピッキングオペレーション: ピッキング作業用の帳票
  - 納品書: 配送用の納品書
  - パッケージ: パッケージラベル
  - ラベル: 商品ラベル

### 8-削除ボタン押下

入庫オペレーションを削除します。完了済み（DONE）の入庫は削除不可。

- 処理フロー:
  1. ステータスがDONEの場合は非表示
  2. 確認ダイアログを表示
  3. 削除確定時、inventories_operationsテーブルからDELETE
  4. 成功時: 成功通知を表示し、一覧画面にリダイレクト
  5. 失敗時（参照整合性エラー）: エラー通知を表示

### 9-明細行の詳細管理

明細行の数量フィールドのアクションボタンから詳細管理モーダルを開きます。

- 処理フロー:
  1. 明細行（MoveLine）のリピーターを表示
  2. ロット/シリアル番号の選択・作成
  3. 保管先ロケーションの指定
  4. 結果パッケージの選択・作成
  5. 数量の入力

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | inventories_operations | UPDATE | オペレーションを更新 |
| 保存ボタン押下 | inventories_moves | INSERT/UPDATE/DELETE | 明細を更新 |
| 検証ボタン押下 | inventories_operations | UPDATE | ステータスをDONEに更新 |
| 検証ボタン押下 | inventories_quantities | UPDATE | 在庫数量を更新 |
| キャンセルボタン押下 | inventories_operations | UPDATE | ステータスをCANCELEDに更新 |
| 返品ボタン押下 | inventories_operations | INSERT | 返品オペレーションを作成 |
| 削除ボタン押下 | inventories_operations | DELETE | オペレーションを削除 |

### テーブル別更新項目詳細

#### inventories_operations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | partner_id | フォーム選択値 | NULL可 |
| UPDATE | operation_type_id | フォーム選択値 | 必須 |
| UPDATE | destination_location_id | フォーム選択値 | 必須 |
| UPDATE | user_id | フォーム選択値 | NULL可 |
| UPDATE | move_type | フォーム選択値 | - |
| UPDATE | scheduled_at | フォーム入力値 | NULL可 |
| UPDATE | origin | フォーム入力値 | NULL可 |
| UPDATE | description | フォーム入力値 | NULL可 |
| UPDATE | state | DONE / CANCELED | 検証/キャンセル時 |
| UPDATE | closed_at | now() | 検証完了時 |
| UPDATE | updated_at | now() | 自動設定 |
| DELETE | - | WHERE id = {record_id} | 物理削除、state != DONE |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| edit-receipt.notification.title | 成功 | 入庫が更新されました | 保存成功時 |
| edit-receipt.notification.body | 成功 | 入庫の更新に成功しました | 保存成功時 |
| delete.notification.success.title | 成功 | 入庫が削除されました | 削除成功時 |
| delete.notification.success.body | 成功 | 入庫の削除に成功しました | 削除成功時 |
| delete.notification.error.title | エラー | 削除できません | 削除失敗時 |
| delete.notification.error.body | エラー | この入庫は他のレコードで使用されています | 削除失敗時 |

## 例外処理

| 例外条件 | 処理内容 | ユーザーへの表示 |
|----------|----------|-----------------|
| 必須項目未入力 | バリデーションエラー | 該当フィールドにエラーメッセージ表示 |
| 削除時の参照整合性エラー | QueryExceptionをキャッチ | 削除失敗通知を表示 |
| レコードが存在しない | 404エラー | ページが見つかりません |
| 検証時に数量不整合 | バリデーションエラー | 数量確認エラーメッセージ表示 |

## 備考

- HasRecordNavigationTabsトレイトを使用してサブナビゲーションを実装しています
- HasRepeaterColumnManagerトレイトを使用してMovesリピーターのカラム管理を実装しています
- 完了済み（DONE）またはキャンセル済み（CANCELED）のオペレーションでは、ほぼ全てのフィールドが編集不可になります
- 明細行のquantityフィールドは、明細がドラフト以外の状態で保存済みの場合のみ表示されます
- 明細行の詳細管理モーダルでは、ロット/シリアル番号の作成、パッケージの作成も可能です
- updateFormメソッドにより、関連データの変更時にフォームが自動的に再読み込みされます
- チャッター機能により、オペレーションに関するコメントや活動履歴を管理できます
- 保存後はリダイレクトせず、同じ編集画面に留まります（getRedirectUrlがeditを返す）
