# 画面設計書 161-入庫詳細

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「入庫詳細」画面の設計仕様を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：入庫詳細画面は、仕入先からの商品受入や倉庫間移動による入庫オペレーションの詳細情報を確認するための画面である。ユーザーは入庫伝票の完全な情報（商品、数量、ロケーション、ステータスなど）を一覧で把握でき、入庫処理の確認や監査に活用される。本画面により、入庫業務の透明性と追跡可能性が確保される。

**画面へのアクセス方法**：在庫管理モジュール > オペレーション > 入庫一覧から該当レコードをクリック、または入庫編集画面のサブナビゲーションから「詳細」タブを選択してアクセスする。

**主要な操作・処理内容**：
1. 入庫オペレーションの詳細情報の閲覧
2. 関連する移動明細（moves）の確認
3. チャット・アクティビティログの確認（ChatterAction）
4. 印刷アクション（ピッキングオペレーション、配送伝票、パッケージ、ラベル）の実行
5. 入庫オペレーションの削除（完了状態以外の場合）

**画面遷移**：
- 遷移元：入庫一覧画面、入庫編集画面
- 遷移先：入庫編集画面、移動管理画面

**権限による表示制御**：削除ボタンは入庫オペレーションの状態が「完了（DONE）」の場合は非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-004 | 入荷表示 | 主機能 | 入庫詳細情報の表示 |
| FN-INV-005 | 移動管理 | 遷移先機能 | 入庫に関連する在庫移動の管理 |

## 画面種別

詳細（View）

## URL/ルーティング

`/inventories/operations/receipts/{record}/view`

## 画面構成

- ヘッダーアクション
  - ChatterAction（チャット・アクティビティログ）
  - 印刷アクショングループ（ピッキングオペレーション、配送伝票、パッケージ、ラベル）
  - 削除アクション
- サブナビゲーション
  - 詳細表示
  - 編集
  - 移動管理
- 状態表示バッジ
- 一般情報セクション
  - 連絡先、オペレーションタイプ
  - 出発地ロケーション、到着地ロケーション
- 詳細タブ
  - オペレーションタブ（移動明細テーブル）
  - 追加情報タブ（担当者、出荷ポリシー、予定日時、元伝票）
  - メモタブ

## 入出力項目

本画面は詳細表示画面のため、入力項目はない。

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| 状態 | バッジ | オペレーションの状態（下書き、確認済、割当済、完了、キャンセル） |
| 連絡先 | テキスト | 入庫元パートナー名 |
| オペレーションタイプ | テキスト | オペレーションタイプ名 |
| 出発地ロケーション | テキスト | 入庫元のロケーション完全名 |
| 到着地ロケーション | テキスト | 入庫先のロケーション完全名 |
| 移動明細（商品） | テキスト | 商品名 |
| 移動明細（最終ロケーション） | テキスト | 最終配置先ロケーション名 |
| 移動明細（説明） | テキスト | ピッキング説明 |
| 移動明細（予定日） | 日付 | 予定日時 |
| 移動明細（期限） | 日付 | 期限日時 |
| 移動明細（パッケージング） | テキスト | 商品パッケージング名 |
| 移動明細（需要数量） | 数値 | 要求数量 |
| 移動明細（実数量） | 数値 | 実際の数量 |
| 移動明細（単位） | テキスト | 単位名 |
| 移動明細（ピック済） | アイコン | ピック済みフラグ |
| 担当者 | テキスト | 担当ユーザー名 |
| 出荷ポリシー | テキスト | 移動タイプ（直接配送など） |
| 予定日時 | 日時 | 予定されている日時 |
| 元伝票 | テキスト | 元となる伝票の識別子 |
| 説明 | マークダウン | オペレーションの説明・メモ |

## イベント仕様

### 1-チャットアクション

ChatterActionをクリックすると、右側からスライドオーバーが表示され、チャットメッセージやアクティビティログを確認できる。

### 2-印刷アクション

印刷ドロップダウンから各種帳票を選択すると、対応する帳票が生成・印刷される。
- ピッキングオペレーション
- 配送伝票
- パッケージ
- ラベル

### 3-削除アクション

削除ボタンをクリックすると確認ダイアログが表示され、確定するとレコードが削除される。削除に成功すると成功通知が表示される。外部キー制約違反などでエラーが発生した場合はエラー通知が表示される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | inventories_operations | DELETE | 入庫オペレーションレコードの削除 |
| 削除ボタン押下 | inventories_moves | DELETE | 関連する移動レコードのカスケード削除 |
| 削除ボタン押下 | inventories_move_lines | DELETE | 関連する移動明細のカスケード削除 |

### テーブル別更新項目詳細

#### inventories_operations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = {record_id} | 完了状態以外の場合のみ削除可能 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| delete.success.title | 成功 | 削除成功タイトル | 削除成功時 |
| delete.success.body | 成功 | 削除成功メッセージ | 削除成功時 |
| delete.error.title | エラー | 削除エラータイトル | 削除失敗時 |
| delete.error.body | エラー | 削除エラーメッセージ | 削除失敗時（外部キー制約違反など） |

## 例外処理

- **削除時のエラー**：QueryExceptionが発生した場合（外部キー制約違反など）、エラー通知が表示され、削除処理が中断される。
- **レコード不存在**：指定されたIDのレコードが存在しない場合、404エラーページが表示される。
- **権限不足**：閲覧権限がない場合、403エラーが返される。

## 備考

- 本画面はFilament PHPのViewRecordクラスを継承している
- HasRecordNavigationTabsトレイトによりサブナビゲーションが実装されている
- HasRepeatableEntryColumnManagerトレイトにより移動明細のカラム管理が可能
- ロケーション表示はWarehouseSettingsのenable_locationsフラグにより制御される
- 単位表示はProductSettingsのenable_uomフラグにより制御される
- パッケージング表示はProductSettingsのenable_packagingsフラグにより制御される
