# 画面設計書 162-廃棄一覧

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「廃棄一覧」画面の設計仕様を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：廃棄一覧画面は、在庫商品の廃棄処理を管理するための画面である。破損品、期限切れ品、不良品などの廃棄オペレーションを一覧で確認・管理でき、廃棄処理の追跡と監査に活用される。各廃棄伝票の状態、数量、廃棄理由などを一目で把握できる。

**画面へのアクセス方法**：在庫管理モジュール > オペレーション > 廃棄 を選択してアクセスする。

**主要な操作・処理内容**：
1. 廃棄一覧の閲覧とフィルタリング
2. 廃棄伝票の検索（参照番号、オリジン）
3. 新規廃棄伝票の作成
4. 既存廃棄伝票の詳細表示・編集・削除
5. 一括削除操作

**画面遷移**：
- 遷移元：在庫管理モジュールメニュー
- 遷移先：廃棄作成画面、廃棄詳細画面、廃棄編集画面

**権限による表示制御**：削除アクションは廃棄が「完了（DONE）」状態の場合は非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-006 | 廃棄管理 | 主機能 | 廃棄一覧の表示・管理 |
| FN-INV-007 | 廃棄作成 | 遷移先機能 | 新規廃棄の登録 |

## 画面種別

一覧（ListRecords）

## URL/ルーティング

`/inventories/operations/scraps`

## 画面構成

- ヘッダーアクション
  - 新規作成ボタン
- テーブル
  - カラム並べ替え可能
  - カラム表示/非表示管理
  - グループ化機能
- フィルター（モーダル表示）
- 一括アクション（削除）

## 入出力項目

### フィルター項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| 参照番号 | テキスト | - | 廃棄伝票の参照番号で検索 |
| 状態 | 選択（複数） | - | 下書き/完了でフィルタリング |
| 商品 | 選択（複数） | - | 廃棄対象商品でフィルタリング |
| ロット | 選択（複数） | - | ロット/シリアル番号でフィルタリング |
| オリジン | テキスト | - | 元伝票番号で検索 |
| 予定日時 | 日付範囲 | - | 予定日時でフィルタリング |
| 完了日時 | 日付範囲 | - | 完了日時でフィルタリング |
| 作成日時 | 日付範囲 | - | レコード作成日時でフィルタリング |
| 更新日時 | 日付範囲 | - | レコード更新日時でフィルタリング |
| 会社 | 選択（複数） | - | 会社でフィルタリング |
| 作成者 | 選択（複数） | - | 作成者でフィルタリング |

## 表示項目

| 項目名 | 表示形式 | ソート | 説明 |
|--------|----------|--------|------|
| 参照番号 | テキスト（リンク） | ○ | 廃棄伝票番号（SP/ID形式） |
| 予定日時 | 日時 | ○ | 廃棄予定日時 |
| 商品 | テキスト | ○ | 廃棄対象商品名 |
| ロット/シリアル | テキスト | ○ | ロットまたはシリアル番号（トレーサビリティ有効時） |
| 会社 | テキスト | ○ | 所属会社名 |
| 出発地 | テキスト | ○ | 廃棄元ロケーション名 |
| 行先 | テキスト | ○ | 廃棄先ロケーション名 |
| 数量 | 数値 | ○ | 廃棄数量 |
| 状態 | バッジ | ○ | 下書き/完了 |

## イベント仕様

### 1-新規作成

ヘッダーの「新規作成」ボタンをクリックすると、廃棄作成画面に遷移する。

### 2-行アクション

各行のアクションメニューから以下の操作が可能：
- **詳細表示**：廃棄詳細画面に遷移
- **編集**：廃棄編集画面に遷移
- **削除**：削除確認ダイアログを表示し、確定で削除実行

### 3-一括削除

チェックボックスで複数レコードを選択し、一括削除を実行できる。完了状態のレコードは選択不可。

### 4-フィルター

フィルターボタンをクリックするとスライドオーバーでフィルターフォームが表示される。QueryBuilderによる高度なフィルタリングが可能。

### 5-グループ化

以下の項目でレコードをグループ化可能：
- 状態
- オリジン
- 商品
- 予定日時（日別）
- 作成日時（日別）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | inventories_scraps | DELETE | 廃棄レコードの削除 |
| 一括削除 | inventories_scraps | DELETE | 複数廃棄レコードの一括削除 |

### テーブル別更新項目詳細

#### inventories_scraps

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = {record_id} AND state != 'done' | 完了状態以外のみ削除可能 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| delete.notification.success.title | 成功 | 削除成功タイトル | 削除成功時 |
| delete.notification.success.body | 成功 | 削除成功メッセージ | 削除成功時 |
| delete.notification.error.title | エラー | 削除エラータイトル | 削除失敗時 |
| delete.notification.error.body | エラー | 削除エラーメッセージ | 削除失敗時 |
| bulk-actions.delete.notification.success.title | 成功 | 一括削除成功タイトル | 一括削除成功時 |
| bulk-actions.delete.notification.success.body | 成功 | 一括削除成功メッセージ | 一括削除成功時 |
| bulk-actions.delete.notification.error.title | エラー | 一括削除エラータイトル | 一括削除失敗時 |
| bulk-actions.delete.notification.error.body | エラー | 一括削除エラーメッセージ | 一括削除失敗時 |

## 例外処理

- **削除時のエラー**：QueryExceptionが発生した場合（外部キー制約違反など）、エラー通知が表示され、削除処理が中断される。
- **検索結果なし**：フィルター条件に一致するレコードがない場合、空の一覧が表示される。
- **権限不足**：閲覧権限がない場合、403エラーが返される。

## 備考

- 本画面はFilament PHPのListRecordsクラスを継承している
- ロット/シリアル番号カラムはTraceabilitySettingsのenable_lots_serial_numbersフラグにより表示が制御される
- ロケーション表示はWarehouseSettingsのenable_locationsフラグにより制御される
- テーブルはidの降順でソートされている
- 完了状態のレコードはチェックボックスで選択不可（checkIfRecordIsSelectableUsing）
