# 画面設計書 163-廃棄作成

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「廃棄作成」画面の設計仕様を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：廃棄作成画面は、在庫商品の廃棄処理を新規登録するための画面である。破損品、期限切れ品、不良品などの廃棄を記録し、在庫から適切に除外する処理を開始する。廃棄元ロケーション、廃棄先ロケーション、数量などを指定して廃棄伝票を作成する。

**画面へのアクセス方法**：在庫管理モジュール > オペレーション > 廃棄 > 新規作成ボタン をクリックしてアクセスする。

**主要な操作・処理内容**：
1. 廃棄対象商品の選択
2. 廃棄数量の入力
3. 出発地/行先ロケーションの指定
4. ロット/シリアル番号の選択（トレーサビリティ有効時）
5. パッケージの選択（オプション）
6. 廃棄伝票の保存

**画面遷移**：
- 遷移元：廃棄一覧画面
- 遷移先：廃棄詳細画面、廃棄編集画面

**権限による表示制御**：作成権限がないユーザーには本画面へのアクセスが制限される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-007 | 廃棄作成 | 主機能 | 新規廃棄の登録 |
| FN-INV-006 | 廃棄管理 | 遷移元機能 | 廃棄一覧からの遷移 |

## 画面種別

作成（CreateRecord）

## URL/ルーティング

`/inventories/operations/scraps/create`

## 画面構成

- ヘッダーアクション
  - 作成ボタン
  - キャンセルボタン
- フォーム
  - 一般情報セクション
  - 追加情報セクション

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 初期値 | 説明 |
|--------|-----|------|--------|------|
| 商品 | 選択 | ○ | - | 廃棄対象商品を選択。商品タイプがGOODSのもののみ選択可能 |
| 数量 | 数値 | ○ | 1 | 廃棄数量 |
| 単位 | 選択 | ○ | 商品のデフォルト単位 | 数量の単位 |
| 出発地ロケーション | 選択 | ○ | - | 廃棄元のロケーション |
| 行先ロケーション | 選択 | ○ | - | 廃棄先のロケーション（通常は仮想ロケーション） |
| ロット/シリアル番号 | 選択 | - | - | トレーサビリティ有効時に表示。商品のトラッキング設定に応じて選択 |
| パッケージ | 選択 | - | - | パッケージ機能有効時に表示 |
| オペレーション | 選択 | - | - | 関連オペレーションを選択 |
| パートナー | 選択 | - | - | 関連パートナーを選択 |
| オリジン | テキスト | - | - | 元伝票の参照番号 |
| 補充する | トグル | - | false | 在庫補充を自動で行うかどうか |

## 表示項目

本画面は作成画面のため、入力項目以外の表示専用項目はない。

## イベント仕様

### 1-商品選択時

商品を選択すると以下の処理が実行される：
- 商品のデフォルト単位が自動設定される
- 商品のトラッキング設定に応じてロット/シリアル番号フィールドが表示される
- 選択可能なロット/シリアル番号が絞り込まれる

### 2-保存ボタン押下

フォームのバリデーションが実行される。バリデーション成功時：
- inventories_scrapsテーブルにレコードが作成される
- 廃棄伝票番号（SP/{id}形式）が自動生成される
- 成功通知が表示される
- 廃棄詳細画面または廃棄編集画面に遷移する

### 3-キャンセルボタン押下

入力内容を破棄し、廃棄一覧画面に戻る。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | inventories_scraps | INSERT | 新規廃棄レコードの作成 |

### テーブル別更新項目詳細

#### inventories_scraps

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | SP/{id} | 自動生成（savingイベント） |
| INSERT | origin | フォーム入力値 | オプション |
| INSERT | state | 'draft' | 下書き状態で作成 |
| INSERT | qty | フォーム入力値 | 必須 |
| INSERT | should_replenish | フォーム入力値 | デフォルト: false |
| INSERT | product_id | フォーム入力値 | 必須 |
| INSERT | uom_id | フォーム入力値 | 必須 |
| INSERT | lot_id | フォーム入力値 | オプション |
| INSERT | package_id | フォーム入力値 | オプション |
| INSERT | partner_id | フォーム入力値 | オプション |
| INSERT | operation_id | フォーム入力値 | オプション |
| INSERT | source_location_id | フォーム入力値 | 必須 |
| INSERT | destination_location_id | フォーム入力値 | 必須 |
| INSERT | company_id | 現在ユーザーのデフォルト会社ID | 自動設定 |
| INSERT | creator_id | 現在ユーザーID | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| notification.created.title | 成功 | 作成成功タイトル | 作成成功時 |
| notification.created.body | 成功 | 作成成功メッセージ | 作成成功時 |
| validation.required | エラー | 必須項目エラー | 必須項目未入力時 |
| validation.numeric | エラー | 数値エラー | 数量が数値でない時 |

## 例外処理

- **バリデーションエラー**：必須項目が未入力の場合、該当フィールドにエラーメッセージが表示される。
- **データベースエラー**：レコード作成に失敗した場合、エラー通知が表示される。
- **権限不足**：作成権限がない場合、403エラーが返される。

## 備考

- 本画面はFilament PHPのCreateRecordクラスを継承している
- 商品選択は商品タイプがGOODS（物品）かつ設定可能でないもののみ表示される
- ロット/シリアル番号フィールドはTraceabilitySettingsのenable_lots_serial_numbersフラグにより表示が制御される
- パッケージフィールドはOperationSettingsのenable_packagesフラグにより表示が制御される
- ロケーション表示はWarehouseSettingsのenable_locationsフラグにより制御される
- 単位フィールドはProductSettingsのenable_uomフラグにより表示が制御される
- 廃棄伝票番号はモデルのsavingイベントで自動生成される
