# 画面設計書 164-廃棄編集

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「廃棄編集」画面の設計仕様を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：廃棄編集画面は、既存の廃棄伝票の内容を修正・更新するための画面である。廃棄処理の実行前に数量の変更、ロケーションの修正、関連情報の追加・変更などを行うことができる。廃棄伝票の検証・確定・キャンセルなどのワークフロー操作も本画面から実行可能。

**画面へのアクセス方法**：在庫管理モジュール > オペレーション > 廃棄 > 対象レコード > 編集 を選択してアクセスする。

**主要な操作・処理内容**：
1. 廃棄伝票情報の編集
2. 検証（Validate）操作による廃棄の確定
3. キャンセル操作による廃棄の取り消し
4. 変更内容の保存

**画面遷移**：
- 遷移元：廃棄一覧画面、廃棄詳細画面
- 遷移先：廃棄詳細画面

**権限による表示制御**：編集権限がないユーザーには本画面へのアクセスが制限される。状態が「完了（DONE）」の場合は編集不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-008 | 廃棄編集 | 主機能 | 廃棄伝票の編集・更新 |
| FN-INV-009 | 廃棄検証 | 関連機能 | 廃棄の確定処理 |

## 画面種別

編集（EditRecord）

## URL/ルーティング

`/inventories/operations/scraps/{record}/edit`

## 画面構成

- ヘッダーアクション
  - ChatterAction（チャット・アクティビティログ）
  - 検証ボタン
  - 印刷アクショングループ
  - キャンセルボタン
  - 削除ボタン
- サブナビゲーション
  - 詳細表示
  - 編集
- 状態ステッパー
- フォーム
  - 一般情報セクション
  - 追加情報セクション

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 初期値 | 状態による制御 | 説明 |
|--------|-----|------|--------|--------------|------|
| 商品 | 選択 | ○ | 現在値 | 完了時：無効 | 廃棄対象商品 |
| 数量 | 数値 | ○ | 現在値 | 完了時：無効 | 廃棄数量 |
| 単位 | 選択 | ○ | 現在値 | 完了時：無効 | 数量の単位 |
| 出発地ロケーション | 選択 | ○ | 現在値 | 完了時：無効 | 廃棄元のロケーション |
| 行先ロケーション | 選択 | ○ | 現在値 | 完了時：無効 | 廃棄先のロケーション |
| ロット/シリアル番号 | 選択 | - | 現在値 | 完了時：無効 | ロット/シリアル番号 |
| パッケージ | 選択 | - | 現在値 | 完了時：無効 | パッケージ |
| オペレーション | 選択 | - | 現在値 | 完了時：無効 | 関連オペレーション |
| パートナー | 選択 | - | 現在値 | 完了時：無効 | 関連パートナー |
| オリジン | テキスト | - | 現在値 | 完了時：無効 | 元伝票の参照番号 |
| 補充する | トグル | - | 現在値 | 完了時：無効 | 在庫補充フラグ |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| 状態ステッパー | ProgressStepper | 現在の状態を視覚的に表示（下書き/完了） |
| 参照番号 | テキスト | 廃棄伝票番号（SP/{id}形式） |

## イベント仕様

### 1-検証（Validate）ボタン押下

**表示条件**：状態が「下書き（DRAFT）」の場合のみ表示

検証ボタンをクリックすると以下の処理が実行される：
1. 廃棄の在庫移動処理が実行される
2. 状態が「完了（DONE）」に更新される
3. 完了日時（closed_at）が現在日時で設定される
4. 成功通知が表示される

### 2-キャンセルボタン押下

**表示条件**：状態が「下書き（DRAFT）」の場合のみ表示

確認ダイアログが表示され、確定すると：
1. 関連する移動レコードがキャンセルされる
2. 廃棄レコードが削除される
3. 成功通知が表示される
4. 廃棄一覧画面にリダイレクトされる

### 3-削除ボタン押下

**表示条件**：状態が「完了（DONE）」以外の場合のみ表示

削除確認ダイアログが表示され、確定すると：
1. 廃棄レコードが削除される
2. 成功通知が表示される
3. 廃棄一覧画面にリダイレクトされる

### 4-保存ボタン押下

フォームのバリデーションが実行され、成功時：
1. inventories_scrapsテーブルのレコードが更新される
2. 成功通知が表示される

### 5-ChatterAction

チャット・アクティビティログのサイドパネルが表示される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | inventories_scraps | UPDATE | 廃棄レコードの更新 |
| 検証ボタン押下 | inventories_scraps | UPDATE | 状態を完了に更新 |
| 検証ボタン押下 | inventories_moves | INSERT | 在庫移動レコードの作成 |
| 検証ボタン押下 | inventories_move_lines | INSERT | 在庫移動明細の作成 |
| キャンセルボタン押下 | inventories_scraps | DELETE | 廃棄レコードの削除 |
| キャンセルボタン押下 | inventories_moves | UPDATE | 移動レコードのキャンセル |
| 削除ボタン押下 | inventories_scraps | DELETE | 廃棄レコードの削除 |

### テーブル別更新項目詳細

#### inventories_scraps

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | 各フィールド | フォーム入力値 | 保存時 |
| UPDATE | state | 'done' | 検証時 |
| UPDATE | closed_at | now() | 検証時 |
| DELETE | - | WHERE id = {record_id} | キャンセル/削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| header-actions.validate.notification.success.title | 成功 | 検証成功タイトル | 検証成功時 |
| header-actions.validate.notification.success.body | 成功 | 検証成功メッセージ | 検証成功時 |
| header-actions.cancel.notification.title | 成功 | キャンセル成功タイトル | キャンセル成功時 |
| header-actions.cancel.notification.body | 成功 | キャンセル成功メッセージ | キャンセル成功時 |
| header-actions.delete.notification.success.title | 成功 | 削除成功タイトル | 削除成功時 |
| header-actions.delete.notification.success.body | 成功 | 削除成功メッセージ | 削除成功時 |
| header-actions.delete.notification.error.title | エラー | 削除エラータイトル | 削除失敗時 |
| header-actions.delete.notification.error.body | エラー | 削除エラーメッセージ | 削除失敗時 |

## 例外処理

- **検証処理エラー**：在庫移動処理中にエラーが発生した場合、例外がスローされロールバックされる。
- **削除時のエラー**：QueryExceptionが発生した場合、エラー通知が表示される。
- **レコード不存在**：指定されたIDのレコードが存在しない場合、404エラーページが表示される。
- **権限不足**：編集権限がない場合、403エラーが返される。

## 備考

- 本画面はFilament PHPのEditRecordクラスを継承している
- HasRecordNavigationTabsトレイトによりサブナビゲーションが実装されている
- 検証処理はInventoryファサードのprocessScrapメソッドを呼び出す
- キャンセル処理はInventoryファサードのcancelScrapメソッドを呼び出す
- 状態が「完了（DONE）」の場合、全フィールドが編集不可となる
- ProgressStepperにより現在の状態が視覚的に表示される
