# 画面設計書 165-廃棄詳細

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「廃棄詳細」画面の設計仕様を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：廃棄詳細画面は、廃棄伝票の完全な情報を確認するための画面である。廃棄対象商品、数量、ロケーション情報、関連オペレーション、状態などを一目で把握でき、廃棄処理の確認・監査に活用される。本画面により、廃棄業務の透明性と追跡可能性が確保される。

**画面へのアクセス方法**：在庫管理モジュール > オペレーション > 廃棄 > 対象レコード > 詳細表示 を選択してアクセスする。

**主要な操作・処理内容**：
1. 廃棄伝票の詳細情報の閲覧
2. 関連する移動明細（moves）の確認
3. チャット・アクティビティログの確認（ChatterAction）
4. 検証操作（下書き状態の場合）
5. 印刷アクション
6. キャンセル・削除操作（下書き状態の場合）

**画面遷移**：
- 遷移元：廃棄一覧画面、廃棄編集画面
- 遷移先：廃棄編集画面

**権限による表示制御**：削除ボタンは廃棄の状態が「完了（DONE）」の場合は非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-010 | 廃棄詳細表示 | 主機能 | 廃棄詳細情報の表示 |
| FN-INV-009 | 廃棄検証 | 関連機能 | 廃棄の確定処理 |

## 画面種別

詳細（ViewRecord）

## URL/ルーティング

`/inventories/operations/scraps/{record}/view`

## 画面構成

- ヘッダーアクション
  - ChatterAction（チャット・アクティビティログ）
  - 検証ボタン
  - 印刷アクショングループ
  - キャンセルボタン
  - 削除ボタン
- サブナビゲーション
  - 詳細表示
  - 編集
- 状態表示バッジ
- 一般情報セクション
- 追加情報セクション
- 移動明細セクション（存在する場合）

## 入出力項目

本画面は詳細表示画面のため、入力項目はない。

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| 参照番号 | テキスト | 廃棄伝票番号（SP/{id}形式） |
| 状態 | バッジ | 下書き/完了 |
| 商品 | テキスト | 廃棄対象商品名 |
| 数量 | 数値 | 廃棄数量 |
| 単位 | テキスト | 数量の単位 |
| 出発地ロケーション | テキスト | 廃棄元ロケーション名 |
| 行先ロケーション | テキスト | 廃棄先ロケーション名 |
| ロット/シリアル番号 | テキスト | ロットまたはシリアル番号（トレーサビリティ有効時） |
| パッケージ | テキスト | パッケージ名（パッケージ機能有効時） |
| オペレーション | テキスト | 関連オペレーション名 |
| パートナー | テキスト | 関連パートナー名 |
| オリジン | テキスト | 元伝票の参照番号 |
| 補充する | アイコン | 在庫補充フラグ |
| 完了日時 | 日時 | 廃棄完了日時 |
| 会社 | テキスト | 所属会社名 |
| 作成者 | テキスト | 作成者名 |
| 移動明細 | テーブル | 関連する在庫移動のリスト |

## イベント仕様

### 1-ChatterAction

ChatterActionをクリックすると、右側からスライドオーバーが表示され、チャットメッセージやアクティビティログを確認できる。

### 2-検証（Validate）ボタン押下

**表示条件**：状態が「下書き（DRAFT）」の場合のみ表示

検証ボタンをクリックすると以下の処理が実行される：
1. 廃棄の在庫移動処理が実行される
2. 状態が「完了（DONE）」に更新される
3. 完了日時（closed_at）が現在日時で設定される
4. 成功通知が表示される
5. 画面がリフレッシュされる

### 3-印刷アクション

印刷ドロップダウンから帳票を選択すると、対応する帳票が生成・印刷される。

### 4-キャンセルボタン押下

**表示条件**：状態が「下書き（DRAFT）」の場合のみ表示

確認ダイアログが表示され、確定すると：
1. 関連する移動レコードがキャンセルされる
2. 廃棄レコードが削除される
3. 成功通知が表示される
4. 廃棄一覧画面にリダイレクトされる

### 5-削除ボタン押下

**表示条件**：状態が「完了（DONE）」以外の場合のみ表示

削除確認ダイアログが表示され、確定すると：
1. 廃棄レコードが削除される
2. 成功通知が表示される
3. 廃棄一覧画面にリダイレクトされる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 検証ボタン押下 | inventories_scraps | UPDATE | 状態を完了に更新 |
| 検証ボタン押下 | inventories_moves | INSERT | 在庫移動レコードの作成 |
| 検証ボタン押下 | inventories_move_lines | INSERT | 在庫移動明細の作成 |
| キャンセルボタン押下 | inventories_scraps | DELETE | 廃棄レコードの削除 |
| キャンセルボタン押下 | inventories_moves | UPDATE | 移動レコードのキャンセル |
| 削除ボタン押下 | inventories_scraps | DELETE | 廃棄レコードの削除 |

### テーブル別更新項目詳細

#### inventories_scraps

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | state | 'done' | 検証時 |
| UPDATE | closed_at | now() | 検証時 |
| DELETE | - | WHERE id = {record_id} | キャンセル/削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| header-actions.validate.notification.success.title | 成功 | 検証成功タイトル | 検証成功時 |
| header-actions.validate.notification.success.body | 成功 | 検証成功メッセージ | 検証成功時 |
| header-actions.cancel.notification.title | 成功 | キャンセル成功タイトル | キャンセル成功時 |
| header-actions.cancel.notification.body | 成功 | キャンセル成功メッセージ | キャンセル成功時 |
| header-actions.delete.notification.success.title | 成功 | 削除成功タイトル | 削除成功時 |
| header-actions.delete.notification.success.body | 成功 | 削除成功メッセージ | 削除成功時 |
| header-actions.delete.notification.error.title | エラー | 削除エラータイトル | 削除失敗時 |
| header-actions.delete.notification.error.body | エラー | 削除エラーメッセージ | 削除失敗時 |

## 例外処理

- **検証処理エラー**：在庫移動処理中にエラーが発生した場合、例外がスローされロールバックされる。
- **削除時のエラー**：QueryExceptionが発生した場合、エラー通知が表示される。
- **レコード不存在**：指定されたIDのレコードが存在しない場合、404エラーページが表示される。
- **権限不足**：閲覧権限がない場合、403エラーが返される。

## 備考

- 本画面はFilament PHPのViewRecordクラスを継承している
- HasRecordNavigationTabsトレイトによりサブナビゲーションが実装されている
- 検証処理はInventoryファサードのprocessScrapメソッドを呼び出す
- キャンセル処理はInventoryファサードのcancelScrapメソッドを呼び出す
- ロケーション表示はWarehouseSettingsのenable_locationsフラグにより制御される
- ロット/シリアル番号表示はTraceabilitySettingsのenable_lots_serial_numbersフラグにより制御される
- パッケージ表示はOperationSettingsのenable_packagesフラグにより制御される
- 単位表示はProductSettingsのenable_uomフラグにより制御される
