# 画面設計書 166-内部移動一覧

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「内部移動一覧」画面の設計仕様を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：内部移動一覧画面は、倉庫内または倉庫間での在庫移動オペレーションを管理するための画面である。保管場所の変更、棚替え、ロケーション間移動などの内部オペレーションを一覧で確認・管理でき、在庫の正確な位置管理に活用される。

**画面へのアクセス方法**：在庫管理モジュール > オペレーション > 内部移動 を選択してアクセスする。

**主要な操作・処理内容**：
1. 内部移動一覧の閲覧とフィルタリング
2. 内部移動伝票の検索（参照番号、連絡先、元伝票）
3. 新規内部移動の作成
4. 既存内部移動の詳細表示・編集・削除
5. 一括削除操作
6. お気に入り登録

**画面遷移**：
- 遷移元：在庫管理モジュールメニュー
- 遷移先：内部移動作成画面、内部移動詳細画面、内部移動編集画面

**権限による表示制御**：削除アクションは内部移動の状態が「完了（DONE）」の場合は非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-011 | 内部移動管理 | 主機能 | 内部移動一覧の表示・管理 |
| FN-INV-012 | 内部移動作成 | 遷移先機能 | 新規内部移動の登録 |

## 画面種別

一覧（ListRecords）

## URL/ルーティング

`/inventories/operations/internals`

## 画面構成

- ヘッダーアクション
  - 新規作成ボタン
- プリセットビュータブ
  - TODO
  - マイ
  - スター付き
  - 下書き
  - 待機中
  - 準備完了
  - 完了
  - キャンセル済み
- テーブル
  - お気に入りアイコン
  - カラム並べ替え可能
  - カラム表示/非表示管理
  - グループ化機能
- フィルター（モーダル表示）
- 一括アクション（削除）

## 入出力項目

### フィルター項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| 参照番号 | テキスト | - | 内部移動伝票の参照番号で検索 |
| 状態 | 選択（複数） | - | 下書き/確認済/割当済/完了/キャンセルでフィルタリング |
| パートナー | 選択（複数） | - | 関連パートナーでフィルタリング |
| 担当者 | 選択（複数） | - | 担当ユーザーでフィルタリング |
| オーナー | 選択（複数） | - | 在庫オーナーでフィルタリング |
| 出発地ロケーション | 選択（複数） | - | 移動元ロケーションでフィルタリング |
| 行先ロケーション | 選択（複数） | - | 移動先ロケーションでフィルタリング |
| 期限 | 日付範囲 | - | 期限日でフィルタリング |
| 予定日時 | 日付範囲 | - | 予定日時でフィルタリング |
| 完了日時 | 日付範囲 | - | 完了日時でフィルタリング |
| 作成日時 | 日付範囲 | - | レコード作成日時でフィルタリング |
| 更新日時 | 日付範囲 | - | レコード更新日時でフィルタリング |
| 会社 | 選択（複数） | - | 会社でフィルタリング |
| 作成者 | 選択（複数） | - | 作成者でフィルタリング |

## 表示項目

| 項目名 | 表示形式 | ソート | 説明 |
|--------|----------|--------|------|
| お気に入り | アイコン | - | スター付きフラグ（クリックで切替可能） |
| 参照番号 | テキスト（リンク） | ○ | 内部移動伝票番号 |
| 出発地 | テキスト | ○ | 移動元ロケーション名（トグル表示） |
| 行先 | テキスト | ○ | 移動先ロケーション名（トグル表示） |
| 連絡先 | テキスト | ○ | 関連パートナー名 |
| 担当者 | テキスト | ○ | 担当ユーザー名（トグル表示） |
| 予定日時 | 日時 | ○ | 移動予定日時 |
| 期限 | 日時 | ○ | 期限日時（トグル表示） |
| 完了日時 | 日時 | ○ | 完了日時（トグル表示） |
| 元伝票 | テキスト | ○ | 元となる伝票番号 |
| オペレーションタイプ | テキスト | ○ | オペレーションタイプ名（トグル表示） |
| 会社 | テキスト | ○ | 所属会社名 |
| 状態 | バッジ | ○ | 下書き/確認済/割当済/完了/キャンセル |

## イベント仕様

### 1-新規作成

ヘッダーの「新規作成」ボタンをクリックすると、内部移動作成画面に遷移する。

### 2-お気に入り切替

お気に入りアイコンをクリックすると、is_favoriteフラグが切り替わる。スター付きビューで絞り込み可能。

### 3-行アクション

各行のアクションメニューから以下の操作が可能：
- **詳細表示**：内部移動詳細画面に遷移
- **編集**：内部移動編集画面に遷移
- **削除**：削除確認ダイアログを表示し、確定で削除実行（完了状態以外）

### 4-一括削除

チェックボックスで複数レコードを選択し、一括削除を実行できる。完了状態のレコードは選択不可。

### 5-フィルター

フィルターボタンをクリックするとスライドオーバーでフィルターフォームが表示される。QueryBuilderによる高度なフィルタリングが可能。

### 6-グループ化

以下の項目でレコードをグループ化可能：
- 状態
- 元伝票
- オペレーションタイプ
- 予定日時（日別）
- 作成日時（日別）

### 7-プリセットビュー

各タブをクリックすると、対応するフィルター条件でデータが絞り込まれる：
- TODO：未完了・未キャンセルのレコード
- マイ：現在ユーザーが担当のレコード
- スター付き：お気に入り登録されたレコード
- 下書き：下書き状態のレコード
- 待機中：確認済み状態のレコード
- 準備完了：割当済み状態のレコード
- 完了：完了状態のレコード
- キャンセル済み：キャンセル状態のレコード

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| お気に入り切替 | inventories_operations | UPDATE | is_favoriteフラグの更新 |
| 削除ボタン押下 | inventories_operations | DELETE | 内部移動レコードの削除 |
| 削除ボタン押下 | inventories_moves | DELETE | 関連する移動レコードのカスケード削除 |
| 削除ボタン押下 | inventories_move_lines | DELETE | 関連する移動明細のカスケード削除 |
| 一括削除 | inventories_operations | DELETE | 複数レコードの一括削除 |

### テーブル別更新項目詳細

#### inventories_operations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | is_favorite | !current_value | お気に入りトグル時 |
| DELETE | - | WHERE id = {record_id} AND state != 'done' | 完了状態以外のみ削除可能 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| table.actions.delete.notification.success.title | 成功 | 削除成功タイトル | 削除成功時 |
| table.actions.delete.notification.success.body | 成功 | 削除成功メッセージ | 削除成功時 |
| table.actions.delete.notification.error.title | エラー | 削除エラータイトル | 削除失敗時 |
| table.actions.delete.notification.error.body | エラー | 削除エラーメッセージ | 削除失敗時 |
| table.bulk-actions.delete.notification.success.title | 成功 | 一括削除成功タイトル | 一括削除成功時 |
| table.bulk-actions.delete.notification.success.body | 成功 | 一括削除成功メッセージ | 一括削除成功時 |
| table.bulk-actions.delete.notification.error.title | エラー | 一括削除エラータイトル | 一括削除失敗時 |
| table.bulk-actions.delete.notification.error.body | エラー | 一括削除エラーメッセージ | 一括削除失敗時 |

## 例外処理

- **削除時のエラー**：QueryExceptionが発生した場合（外部キー制約違反など）、エラー通知が表示され、削除処理が中断される。
- **検索結果なし**：フィルター条件に一致するレコードがない場合、空の一覧が表示される。
- **権限不足**：閲覧権限がない場合、403エラーが返される。

## 備考

- 本画面はFilament PHPのListRecordsクラスを継承している
- 本画面はWarehouseSettingsのenable_locationsがtrueの場合のみナビゲーションに表示される
- モデルはInternalTransferクラスを使用し、Operationクラスを継承している
- OperationType.type = 'internal' のオペレーションのみ表示される
- テーブルはidの降順でソートされている
- 完了状態のレコードはチェックボックスで選択不可（checkIfRecordIsSelectableUsing）
- ロケーション表示はWarehouseSettingsのenable_locationsフラグにより制御される
