# 画面設計書 167-内部移動作成

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「内部移動作成」画面の設計仕様を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：内部移動作成画面は、倉庫内または倉庫間での在庫移動オペレーションを新規登録するための画面である。保管場所の変更、棚替え、ロケーション間移動などを記録し、在庫の正確な位置管理を実現する。移動元・移動先のロケーション、移動商品、数量などを指定して内部移動伝票を作成する。

**画面へのアクセス方法**：在庫管理モジュール > オペレーション > 内部移動 > 新規作成ボタン をクリックしてアクセスする。

**主要な操作・処理内容**：
1. オペレーションタイプの選択
2. 出発地・行先ロケーションの指定
3. 移動商品明細の登録
4. 担当者・予定日時の設定
5. 内部移動伝票の保存

**画面遷移**：
- 遷移元：内部移動一覧画面
- 遷移先：内部移動詳細画面、内部移動編集画面

**権限による表示制御**：作成権限がないユーザーには本画面へのアクセスが制限される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-012 | 内部移動作成 | 主機能 | 新規内部移動の登録 |
| FN-INV-011 | 内部移動管理 | 遷移元機能 | 内部移動一覧からの遷移 |

## 画面種別

作成（CreateRecord）

## URL/ルーティング

`/inventories/operations/internals/create`

## 画面構成

- ヘッダーアクション
  - 作成ボタン
  - キャンセルボタン
- 状態ステッパー
- フォーム
  - 一般情報セクション
  - オペレーションタブ（移動明細）
  - 追加情報タブ
  - メモタブ

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 初期値 | 説明 |
|--------|-----|------|--------|------|
| 連絡先 | 選択 | - | - | 関連パートナーを選択 |
| オペレーションタイプ | 選択 | ○ | - | 内部移動タイプを選択（type = 'internal'のもの） |
| 出発地ロケーション | 選択 | ○ | オペレーションタイプのデフォルト値 | 移動元ロケーションを選択 |
| 行先ロケーション | 選択 | ○ | オペレーションタイプのデフォルト値 | 移動先ロケーションを選択 |

### オペレーションタブ - 移動明細（繰り返し項目）

| 項目名 | 型 | 必須 | 初期値 | 説明 |
|--------|-----|------|--------|------|
| 商品 | 選択 | ○ | - | 移動対象商品を選択 |
| 最終ロケーション | 選択 | - | - | 最終配置先ロケーション |
| 説明 | テキスト | - | - | ピッキング説明 |
| 予定日時 | 日時 | - | 現在日時 | 予定日時 |
| 期限 | 日時 | - | - | 期限日時 |
| パッケージング | 選択 | - | - | 商品パッケージング（設定有効時） |
| 需要 | 数値 | ○ | 0 | 要求数量 |
| 単位 | 選択 | ○ | 商品のデフォルト単位 | 数量の単位 |
| ピック済 | トグル | - | false | ピック済みフラグ |

### 追加情報タブ

| 項目名 | 型 | 必須 | 初期値 | 説明 |
|--------|-----|------|--------|------|
| 担当者 | 選択 | - | 現在ユーザー | 担当ユーザー |
| 出荷ポリシー | 選択 | - | 直接配送 | 移動タイプ（部分配送/一括配送） |
| 予定日時 | 日時 | - | 現在日時 | オペレーション予定日時 |
| 元伝票 | テキスト | - | - | 元となる伝票番号 |

### メモタブ

| 項目名 | 型 | 必須 | 初期値 | 説明 |
|--------|-----|------|--------|------|
| 説明 | リッチエディタ | - | - | オペレーションの説明・メモ |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| 状態ステッパー | ProgressStepper | 下書き状態で表示 |

## イベント仕様

### 1-オペレーションタイプ選択時

オペレーションタイプを選択すると以下の処理が実行される：
- 出発地ロケーションがオペレーションタイプのデフォルト値で設定される
- 行先ロケーションがオペレーションタイプのデフォルト値で設定される

### 2-商品選択時（移動明細）

商品を選択すると以下の処理が実行される：
- 商品のデフォルト単位が自動設定される
- product_qtyが計算される
- 最適なパッケージングが自動選択される

### 3-需要数量変更時

需要数量を変更すると以下の処理が実行される：
- product_qtyが再計算される
- パッケージングが再選択される

### 4-保存ボタン押下

フォームのバリデーションが実行される。バリデーション成功時：
- inventories_operationsテーブルにレコードが作成される
- inventories_movesテーブルに移動明細が作成される
- 伝票番号が自動生成される
- 成功通知が表示される
- 内部移動詳細画面または内部移動編集画面に遷移する

### 5-キャンセルボタン押下

入力内容を破棄し、内部移動一覧画面に戻る。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | inventories_operations | INSERT | 新規オペレーションレコードの作成 |
| 保存ボタン押下 | inventories_moves | INSERT | 移動明細レコードの作成 |

### テーブル別更新項目詳細

#### inventories_operations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | {warehouse_code}/{operation_type_code}/{id} | 自動生成 |
| INSERT | state | 'draft' | 下書き状態で作成 |
| INSERT | move_type | フォーム入力値 | デフォルト: 'direct' |
| INSERT | partner_id | フォーム入力値 | オプション |
| INSERT | operation_type_id | フォーム入力値 | 必須 |
| INSERT | source_location_id | フォーム入力値 | 必須 |
| INSERT | destination_location_id | フォーム入力値 | 必須 |
| INSERT | user_id | フォーム入力値 | デフォルト: Auth::id() |
| INSERT | scheduled_at | フォーム入力値 | デフォルト: now() |
| INSERT | origin | フォーム入力値 | オプション |
| INSERT | description | フォーム入力値 | オプション |
| INSERT | company_id | Auth::user()->default_company_id | 自動設定 |
| INSERT | creator_id | Auth::id() | 自動設定 |

#### inventories_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | product_id | フォーム入力値 | 必須 |
| INSERT | name | 商品名 | 自動設定 |
| INSERT | state | 親オペレーションの状態 | 自動設定 |
| INSERT | product_uom_qty | フォーム入力値 | 必須 |
| INSERT | uom_id | フォーム入力値 | 必須 |
| INSERT | source_location_id | 親オペレーションの出発地 | 自動設定 |
| INSERT | destination_location_id | 親オペレーションの行先 | 自動設定 |
| INSERT | operation_type_id | 親オペレーションのタイプ | 自動設定 |
| INSERT | scheduled_at | 親オペレーションの予定日時 | 自動設定 |
| INSERT | reference | 親オペレーションの名前 | 自動設定 |
| INSERT | company_id | 親オペレーションの会社 | 自動設定 |
| INSERT | creator_id | Auth::id() | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| notification.created.title | 成功 | 作成成功タイトル | 作成成功時 |
| notification.created.body | 成功 | 作成成功メッセージ | 作成成功時 |
| validation.required | エラー | 必須項目エラー | 必須項目未入力時 |

## 例外処理

- **バリデーションエラー**：必須項目が未入力の場合、該当フィールドにエラーメッセージが表示される。
- **データベースエラー**：レコード作成に失敗した場合、エラー通知が表示される。
- **権限不足**：作成権限がない場合、403エラーが返される。

## 備考

- 本画面はFilament PHPのCreateRecordクラスを継承している
- フォーム定義はOperationResourceから継承される
- 移動明細はRepeaterコンポーネントで実装されている
- 商品選択は商品タイプがGOODS（物品）かつ設定可能でないもののみ表示される
- ロケーション表示はWarehouseSettingsのenable_locationsフラグにより制御される
- 単位フィールドはProductSettingsのenable_uomフラグにより表示が制御される
- パッケージングフィールドはProductSettingsのenable_packagingsフラグにより表示が制御される
- 伝票番号はモデルのsavingイベントで自動生成される
- 移動明細の作成時にmutateRelationshipDataBeforeCreateUsingで追加フィールドが設定される
