# 画面設計書 168-内部移動編集

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「内部移動編集」画面の設計仕様を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：内部移動編集画面は、既存の内部移動オペレーションの内容を修正・更新するための画面である。移動商品の追加・削除、数量の変更、ロケーションの修正、ステータス管理などを行うことができる。内部移動のワークフロー操作（確認、割当、処理、キャンセル）も本画面から実行可能。

**画面へのアクセス方法**：在庫管理モジュール > オペレーション > 内部移動 > 対象レコード > 編集 を選択してアクセスする。

**主要な操作・処理内容**：
1. 内部移動オペレーション情報の編集
2. 移動明細の追加・編集・削除
3. 可用性確認（Check Availability）
4. 検証（Validate）操作
5. 戻り注文（Return）の作成
6. 印刷アクション
7. キャンセル・削除操作

**画面遷移**：
- 遷移元：内部移動一覧画面、内部移動詳細画面
- 遷移先：内部移動詳細画面、移動管理画面

**権限による表示制御**：編集権限がないユーザーには本画面へのアクセスが制限される。状態が「完了（DONE）」または「キャンセル（CANCELED）」の場合は編集不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-013 | 内部移動編集 | 主機能 | 内部移動の編集・更新 |
| FN-INV-014 | 内部移動検証 | 関連機能 | 内部移動の確定処理 |
| FN-INV-015 | 戻り注文作成 | 関連機能 | 内部移動の返品処理 |

## 画面種別

編集（EditRecord）

## URL/ルーティング

`/inventories/operations/internals/{record}/edit`

## 画面構成

- ヘッダーアクション
  - ChatterAction（チャット・アクティビティログ）
  - 確認ボタン
  - 可用性確認ボタン
  - 検証ボタン
  - 戻りボタン
  - 印刷アクショングループ
  - キャンセルボタン
  - 削除ボタン
- サブナビゲーション
  - 詳細表示
  - 編集
  - 移動管理
- 状態ステッパー
- フォーム
  - 一般情報セクション
  - オペレーションタブ（移動明細）
  - 追加情報タブ
  - メモタブ

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 初期値 | 状態による制御 | 説明 |
|--------|-----|------|--------|--------------|------|
| 連絡先 | 選択 | - | 現在値 | 完了/キャンセル時：無効 | 関連パートナー |
| オペレーションタイプ | 選択 | ○ | 現在値 | 完了/キャンセル時：無効 | 内部移動タイプ |
| 出発地ロケーション | 選択 | ○ | 現在値 | 完了/キャンセル時：無効 | 移動元ロケーション |
| 行先ロケーション | 選択 | ○ | 現在値 | 完了/キャンセル時：無効 | 移動先ロケーション |

### オペレーションタブ - 移動明細（繰り返し項目）

| 項目名 | 型 | 必須 | 初期値 | 状態による制御 | 説明 |
|--------|-----|------|--------|--------------|------|
| 商品 | 選択 | ○ | 現在値 | 下書き以外：無効 | 移動対象商品 |
| 最終ロケーション | 選択 | - | 現在値 | 完了/キャンセル時：無効 | 最終配置先 |
| 説明 | テキスト | - | 現在値 | 完了/キャンセル時：無効 | ピッキング説明 |
| 予定日時 | 日時 | - | 現在値 | 完了/キャンセル時：無効 | 予定日時 |
| 期限 | 日時 | - | 現在値 | 完了/キャンセル時：無効 | 期限日時 |
| パッケージング | 選択 | - | 現在値 | 完了/キャンセル時：無効 | 商品パッケージング |
| 需要 | 数値 | ○ | 現在値 | 下書き以外：無効 | 要求数量 |
| 数量 | 数値 | ○ | 現在値 | 完了/キャンセル時：無効 | 実際の数量 |
| 単位 | 選択 | ○ | 現在値 | 完了/キャンセル時：無効 | 数量の単位 |
| ピック済 | トグル | - | 現在値 | 完了/キャンセル時：無効 | ピック済みフラグ |

### 追加情報タブ

| 項目名 | 型 | 必須 | 初期値 | 状態による制御 | 説明 |
|--------|-----|------|--------|--------------|------|
| 担当者 | 選択 | - | 現在値 | 完了/キャンセル時：無効 | 担当ユーザー |
| 出荷ポリシー | 選択 | - | 現在値 | 完了/キャンセル時：無効 | 移動タイプ |
| 予定日時 | 日時 | - | 現在値 | 完了/キャンセル時：無効 | オペレーション予定日時 |
| 元伝票 | テキスト | - | 現在値 | 完了/キャンセル時：無効 | 元となる伝票番号 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| 状態ステッパー | ProgressStepper | 現在の状態を視覚的に表示 |
| 参照番号 | テキスト | 内部移動伝票番号 |

## イベント仕様

### 1-確認（Confirm）ボタン押下

**表示条件**：状態が「下書き（DRAFT）」の場合のみ表示

確認ボタンをクリックすると以下の処理が実行される：
1. オペレーション情報のバリデーション
2. 状態が「確認済（CONFIRMED）」または「割当済（ASSIGNED）」に更新される
3. 成功通知が表示される

### 2-可用性確認（Check Availability）ボタン押下

**表示条件**：状態が「確認済（CONFIRMED）」の場合のみ表示

可用性確認ボタンをクリックすると以下の処理が実行される：
1. 在庫可用性のチェック
2. 十分な在庫がある場合、状態が「割当済（ASSIGNED）」に更新される
3. 成功通知が表示される

### 3-検証（Validate）ボタン押下

**表示条件**：状態が「割当済（ASSIGNED）」の場合のみ表示

検証ボタンをクリックすると以下の処理が実行される：
1. 移動処理の実行（在庫の実際の移動）
2. 状態が「完了（DONE）」に更新される
3. 完了日時（closed_at）が現在日時で設定される
4. 成功通知が表示される

### 4-戻り（Return）ボタン押下

**表示条件**：状態が「完了（DONE）」の場合のみ表示

戻りボタンをクリックすると確認モーダルが表示され、確定すると：
1. 新しい戻り注文（内部移動）が作成される
2. 元のオペレーションへの参照が設定される
3. 成功通知が表示される
4. 新しい戻り注文の編集画面にリダイレクトされる

### 5-キャンセルボタン押下

**表示条件**：状態が「完了（DONE）」以外の場合のみ表示

確認ダイアログが表示され、確定すると：
1. 状態が「キャンセル（CANCELED）」に更新される
2. 成功通知が表示される

### 6-削除ボタン押下

**表示条件**：状態が「完了（DONE）」以外の場合のみ表示

削除確認ダイアログが表示され、確定すると：
1. オペレーションレコードが削除される
2. 成功通知が表示される
3. 内部移動一覧画面にリダイレクトされる

### 7-保存ボタン押下

フォームのバリデーションが実行され、成功時：
1. inventories_operationsテーブルのレコードが更新される
2. inventories_movesテーブルの移動明細が更新される
3. 成功通知が表示される

### 8-ChatterAction

チャット・アクティビティログのサイドパネルが表示される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | inventories_operations | UPDATE | オペレーションレコードの更新 |
| 保存ボタン押下 | inventories_moves | UPDATE/INSERT/DELETE | 移動明細の更新 |
| 確認ボタン押下 | inventories_operations | UPDATE | 状態を確認済に更新 |
| 確認ボタン押下 | inventories_moves | UPDATE | 移動明細の状態を更新 |
| 可用性確認ボタン押下 | inventories_operations | UPDATE | 状態を割当済に更新 |
| 検証ボタン押下 | inventories_operations | UPDATE | 状態を完了に更新 |
| 検証ボタン押下 | inventories_move_lines | INSERT/UPDATE | 移動明細ラインの処理 |
| 検証ボタン押下 | inventories_product_quantities | UPDATE | 在庫数量の更新 |
| 戻りボタン押下 | inventories_operations | INSERT | 新規戻りオペレーションの作成 |
| 戻りボタン押下 | inventories_moves | INSERT | 戻り移動明細の作成 |
| キャンセルボタン押下 | inventories_operations | UPDATE | 状態をキャンセルに更新 |
| キャンセルボタン押下 | inventories_moves | UPDATE | 移動明細の状態をキャンセルに更新 |
| 削除ボタン押下 | inventories_operations | DELETE | オペレーションレコードの削除 |

### テーブル別更新項目詳細

#### inventories_operations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | 各フィールド | フォーム入力値 | 保存時 |
| UPDATE | state | 'confirmed' or 'assigned' | 確認時 |
| UPDATE | state | 'assigned' | 可用性確認成功時 |
| UPDATE | state | 'done' | 検証時 |
| UPDATE | closed_at | now() | 検証時 |
| UPDATE | state | 'canceled' | キャンセル時 |
| DELETE | - | WHERE id = {record_id} | 削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| header-actions.confirm.notification.title | 成功 | 確認成功タイトル | 確認成功時 |
| header-actions.confirm.notification.body | 成功 | 確認成功メッセージ | 確認成功時 |
| header-actions.check-availability.notification.title | 成功 | 可用性確認成功タイトル | 可用性確認成功時 |
| header-actions.check-availability.notification.body | 成功 | 可用性確認成功メッセージ | 可用性確認成功時 |
| header-actions.validate.notification.title | 成功 | 検証成功タイトル | 検証成功時 |
| header-actions.validate.notification.body | 成功 | 検証成功メッセージ | 検証成功時 |
| header-actions.return.notification.title | 成功 | 戻り作成成功タイトル | 戻り作成成功時 |
| header-actions.return.notification.body | 成功 | 戻り作成成功メッセージ | 戻り作成成功時 |
| header-actions.cancel.notification.title | 成功 | キャンセル成功タイトル | キャンセル成功時 |
| header-actions.cancel.notification.body | 成功 | キャンセル成功メッセージ | キャンセル成功時 |
| header-actions.delete.notification.success.title | 成功 | 削除成功タイトル | 削除成功時 |
| header-actions.delete.notification.success.body | 成功 | 削除成功メッセージ | 削除成功時 |
| header-actions.delete.notification.error.title | エラー | 削除エラータイトル | 削除失敗時 |
| header-actions.delete.notification.error.body | エラー | 削除エラーメッセージ | 削除失敗時 |

## 例外処理

- **バリデーションエラー**：必須項目が未入力の場合、該当フィールドにエラーメッセージが表示される。
- **在庫不足**：可用性確認時に在庫が不足している場合、状態は「確認済」のまま維持される。
- **検証処理エラー**：在庫移動処理中にエラーが発生した場合、例外がスローされロールバックされる。
- **削除時のエラー**：QueryExceptionが発生した場合、エラー通知が表示される。
- **レコード不存在**：指定されたIDのレコードが存在しない場合、404エラーページが表示される。
- **権限不足**：編集権限がない場合、403エラーが返される。

## 備考

- 本画面はFilament PHPのEditRecordクラスを継承している
- HasRecordNavigationTabsトレイトによりサブナビゲーションが実装されている
- フォーム定義はOperationResourceから継承される
- 確認処理はInventoryファサードのconfirmTransferメソッドを呼び出す
- 可用性確認処理はInventoryファサードのcheckAvailabilityメソッドを呼び出す
- 検証処理はInventoryファサードのvalidateTransferメソッドを呼び出す
- 戻り注文作成はInventoryファサードのcreateReturnメソッドを呼び出す
- 状態が「完了（DONE）」または「キャンセル（CANCELED）」の場合、全フィールドが編集不可となる
- 移動明細のRepeaterは状態に応じて追加・削除の可否が制御される
