# 画面設計書 169-内部移動詳細

## 概要

本ドキュメントは、Aureus ERPシステムの在庫管理モジュールにおける「内部移動詳細」画面の設計仕様を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：内部移動詳細画面は、内部移動オペレーションの完全な情報を確認するための画面である。移動商品、数量、ロケーション情報、状態、移動明細などを一目で把握でき、内部移動処理の確認・監査に活用される。本画面により、倉庫内移動業務の透明性と追跡可能性が確保される。

**画面へのアクセス方法**：在庫管理モジュール > オペレーション > 内部移動 > 対象レコード > 詳細表示 を選択してアクセスする。

**主要な操作・処理内容**：
1. 内部移動オペレーションの詳細情報の閲覧
2. 関連する移動明細（moves）の確認
3. チャット・アクティビティログの確認（ChatterAction）
4. ワークフローアクション（確認、可用性確認、検証、戻り）の実行
5. 印刷アクション
6. キャンセル・削除操作

**画面遷移**：
- 遷移元：内部移動一覧画面、内部移動編集画面
- 遷移先：内部移動編集画面、移動管理画面

**権限による表示制御**：削除ボタンは内部移動の状態が「完了（DONE）」の場合は非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-016 | 内部移動詳細表示 | 主機能 | 内部移動詳細情報の表示 |
| FN-INV-014 | 内部移動検証 | 関連機能 | 内部移動の確定処理 |
| FN-INV-015 | 戻り注文作成 | 関連機能 | 内部移動の返品処理 |

## 画面種別

詳細（ViewRecord）

## URL/ルーティング

`/inventories/operations/internals/{record}/view`

## 画面構成

- ヘッダーアクション
  - ChatterAction（チャット・アクティビティログ）
  - 確認ボタン
  - 可用性確認ボタン
  - 検証ボタン
  - 戻りボタン
  - 印刷アクショングループ
  - キャンセルボタン
  - 削除ボタン
- サブナビゲーション
  - 詳細表示
  - 編集
  - 移動管理
- 状態表示バッジ
- 一般情報セクション
- 詳細タブ
  - オペレーションタブ（移動明細テーブル）
  - 追加情報タブ
  - メモタブ

## 入出力項目

本画面は詳細表示画面のため、入力項目はない。

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| 状態 | バッジ | オペレーションの状態（下書き、確認済、割当済、完了、キャンセル） |
| 連絡先 | テキスト | 関連パートナー名 |
| オペレーションタイプ | テキスト | オペレーションタイプ名 |
| 出発地ロケーション | テキスト | 移動元ロケーション完全名 |
| 行先ロケーション | テキスト | 移動先ロケーション完全名 |
| 移動明細（商品） | テキスト | 商品名 |
| 移動明細（最終ロケーション） | テキスト | 最終配置先ロケーション名 |
| 移動明細（説明） | テキスト | ピッキング説明 |
| 移動明細（予定日） | 日付 | 予定日時 |
| 移動明細（期限） | 日付 | 期限日時 |
| 移動明細（パッケージング） | テキスト | 商品パッケージング名 |
| 移動明細（需要数量） | 数値 | 要求数量 |
| 移動明細（実数量） | 数値 | 実際の数量 |
| 移動明細（単位） | テキスト | 単位名 |
| 移動明細（ピック済） | アイコン | ピック済みフラグ |
| 担当者 | テキスト | 担当ユーザー名 |
| 出荷ポリシー | テキスト | 移動タイプ |
| 予定日時 | 日時 | オペレーション予定日時 |
| 元伝票 | テキスト | 元となる伝票番号 |
| 説明 | マークダウン | オペレーションの説明・メモ |

## イベント仕様

### 1-ChatterAction

ChatterActionをクリックすると、右側からスライドオーバーが表示され、チャットメッセージやアクティビティログを確認できる。

### 2-確認（Confirm）ボタン押下

**表示条件**：状態が「下書き（DRAFT）」の場合のみ表示

確認ボタンをクリックすると以下の処理が実行される：
1. オペレーション情報のバリデーション
2. 状態が「確認済（CONFIRMED）」または「割当済（ASSIGNED）」に更新される
3. 成功通知が表示される
4. 画面がリフレッシュされる

### 3-可用性確認（Check Availability）ボタン押下

**表示条件**：状態が「確認済（CONFIRMED）」の場合のみ表示

可用性確認ボタンをクリックすると以下の処理が実行される：
1. 在庫可用性のチェック
2. 十分な在庫がある場合、状態が「割当済（ASSIGNED）」に更新される
3. 成功通知が表示される
4. 画面がリフレッシュされる

### 4-検証（Validate）ボタン押下

**表示条件**：状態が「割当済（ASSIGNED）」の場合のみ表示

検証ボタンをクリックすると以下の処理が実行される：
1. 移動処理の実行（在庫の実際の移動）
2. 状態が「完了（DONE）」に更新される
3. 完了日時（closed_at）が現在日時で設定される
4. 成功通知が表示される
5. 画面がリフレッシュされる

### 5-戻り（Return）ボタン押下

**表示条件**：状態が「完了（DONE）」の場合のみ表示

戻りボタンをクリックすると確認モーダルが表示され、確定すると：
1. 新しい戻り注文（内部移動）が作成される
2. 元のオペレーションへの参照が設定される
3. 成功通知が表示される
4. 新しい戻り注文の編集画面にリダイレクトされる

### 6-印刷アクション

印刷ドロップダウンから各種帳票を選択すると、対応する帳票が生成・印刷される。
- ピッキングオペレーション
- 配送伝票
- パッケージ
- ラベル

### 7-キャンセルボタン押下

**表示条件**：状態が「完了（DONE）」以外の場合のみ表示

確認ダイアログが表示され、確定すると：
1. 状態が「キャンセル（CANCELED）」に更新される
2. 成功通知が表示される
3. 画面がリフレッシュされる

### 8-削除ボタン押下

**表示条件**：状態が「完了（DONE）」以外の場合のみ表示

削除確認ダイアログが表示され、確定すると：
1. オペレーションレコードが削除される
2. 成功通知が表示される
3. 内部移動一覧画面にリダイレクトされる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 確認ボタン押下 | inventories_operations | UPDATE | 状態を確認済に更新 |
| 確認ボタン押下 | inventories_moves | UPDATE | 移動明細の状態を更新 |
| 可用性確認ボタン押下 | inventories_operations | UPDATE | 状態を割当済に更新 |
| 検証ボタン押下 | inventories_operations | UPDATE | 状態を完了に更新 |
| 検証ボタン押下 | inventories_move_lines | INSERT/UPDATE | 移動明細ラインの処理 |
| 検証ボタン押下 | inventories_product_quantities | UPDATE | 在庫数量の更新 |
| 戻りボタン押下 | inventories_operations | INSERT | 新規戻りオペレーションの作成 |
| 戻りボタン押下 | inventories_moves | INSERT | 戻り移動明細の作成 |
| キャンセルボタン押下 | inventories_operations | UPDATE | 状態をキャンセルに更新 |
| キャンセルボタン押下 | inventories_moves | UPDATE | 移動明細の状態をキャンセルに更新 |
| 削除ボタン押下 | inventories_operations | DELETE | オペレーションレコードの削除 |
| 削除ボタン押下 | inventories_moves | DELETE | 関連する移動レコードのカスケード削除 |
| 削除ボタン押下 | inventories_move_lines | DELETE | 関連する移動明細のカスケード削除 |

### テーブル別更新項目詳細

#### inventories_operations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | state | 'confirmed' or 'assigned' | 確認時 |
| UPDATE | state | 'assigned' | 可用性確認成功時 |
| UPDATE | state | 'done' | 検証時 |
| UPDATE | closed_at | now() | 検証時 |
| UPDATE | state | 'canceled' | キャンセル時 |
| DELETE | - | WHERE id = {record_id} | 削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| header-actions.confirm.notification.title | 成功 | 確認成功タイトル | 確認成功時 |
| header-actions.confirm.notification.body | 成功 | 確認成功メッセージ | 確認成功時 |
| header-actions.check-availability.notification.title | 成功 | 可用性確認成功タイトル | 可用性確認成功時 |
| header-actions.check-availability.notification.body | 成功 | 可用性確認成功メッセージ | 可用性確認成功時 |
| header-actions.validate.notification.title | 成功 | 検証成功タイトル | 検証成功時 |
| header-actions.validate.notification.body | 成功 | 検証成功メッセージ | 検証成功時 |
| header-actions.return.notification.title | 成功 | 戻り作成成功タイトル | 戻り作成成功時 |
| header-actions.return.notification.body | 成功 | 戻り作成成功メッセージ | 戻り作成成功時 |
| header-actions.cancel.notification.title | 成功 | キャンセル成功タイトル | キャンセル成功時 |
| header-actions.cancel.notification.body | 成功 | キャンセル成功メッセージ | キャンセル成功時 |
| header-actions.delete.notification.success.title | 成功 | 削除成功タイトル | 削除成功時 |
| header-actions.delete.notification.success.body | 成功 | 削除成功メッセージ | 削除成功時 |
| header-actions.delete.notification.error.title | エラー | 削除エラータイトル | 削除失敗時 |
| header-actions.delete.notification.error.body | エラー | 削除エラーメッセージ | 削除失敗時 |

## 例外処理

- **確認処理エラー**：バリデーションに失敗した場合、エラー通知が表示される。
- **在庫不足**：可用性確認時に在庫が不足している場合、状態は「確認済」のまま維持される。
- **検証処理エラー**：在庫移動処理中にエラーが発生した場合、例外がスローされロールバックされる。
- **削除時のエラー**：QueryExceptionが発生した場合、エラー通知が表示される。
- **レコード不存在**：指定されたIDのレコードが存在しない場合、404エラーページが表示される。
- **権限不足**：閲覧権限がない場合、403エラーが返される。

## 備考

- 本画面はFilament PHPのViewRecordクラスを継承している
- HasRecordNavigationTabsトレイトによりサブナビゲーションが実装されている
- HasRepeatableEntryColumnManagerトレイトにより移動明細のカラム管理が可能
- infolist定義はOperationResourceから継承される
- 確認処理はInventoryファサードのconfirmTransferメソッドを呼び出す
- 可用性確認処理はInventoryファサードのcheckAvailabilityメソッドを呼び出す
- 検証処理はInventoryファサードのvalidateTransferメソッドを呼び出す
- 戻り注文作成はInventoryファサードのcreateReturnメソッドを呼び出す
- ロケーション表示はWarehouseSettingsのenable_locationsフラグにより制御される
- 単位表示はProductSettingsのenable_uomフラグにより制御される
- パッケージング表示はProductSettingsのenable_packagingsフラグにより制御される
