# 画面設計書 17-クレジットノート編集

## 概要

本ドキュメントは、Aureus ERPシステムにおける「クレジットノート編集」画面の設計仕様を定義するものである。

### 本画面の処理概要

クレジットノート編集画面は、会計モジュールにおいて既存のクレジットノート（返品伝票・貸方票）の内容を変更するための画面である。

**業務上の目的・背景**：作成済みのクレジットノートの内容を修正する必要がある場合に使用する。下書き状態のクレジットノートは自由に編集可能だが、転記済み・キャンセル済みの場合は一部フィールドが編集不可となる。顧客情報の変更、明細の修正、金額の調整などを行う。

**画面へのアクセス方法**：
1. クレジットノート一覧画面の各行の「編集」アクションから遷移
2. クレジットノート詳細画面のヘッダーの「編集」ボタンから遷移
3. URL直接入力でもアクセス可能

**主要な操作・処理内容**：
1. クレジットノートのヘッダー情報の編集
2. 明細行の追加・編集・削除
3. ワークフローアクション（確認、キャンセル、下書きに戻す等）の実行
4. プレビュー表示
5. 印刷・送信
6. 保存ボタンで変更を確定

**画面遷移**：
- 保存成功時：クレジットノート詳細画面（ViewCreditNote）へ自動遷移
- プレビューアクション：モーダルでプレビュー表示
- 削除成功時：クレジットノート一覧画面へ遷移

**権限による表示制御**：Filament Resourceの標準的な権限管理に従い、編集権限を持つユーザーのみが画面にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-ACC-031 | クレジットノート管理 | 主機能 | クレジットノートの編集 |
| FN-ACC-052 | クレジットノート管理 | 主機能 | 編集/削除処理 |

## 画面種別

編集

## URL/ルーティング

`/admin/accounts/credit-notes/{record}/edit`

## 画面構成

1. **ヘッダーアクションエリア**
   - Chatterアクション（コメント・アクティビティ）
   - 支払アクション（PayAction）
   - 確認アクション（ConfirmAction）
   - キャンセルアクション（CancelAction）
   - 下書きに戻すアクション（ResetToDraftAction）
   - プレビューアクション（PreviewAction）- クレジットノート専用テンプレート
   - 印刷・送信アクション（PrintAndSendAction）
   - 削除アクション（DeleteAction）
   - ※「確認済みに設定」と「クレジットノート」アクションは除外

2. **ステータスステッパー**
   - ProgressStepper（現在の状態を表示）

3. **一般情報セクション**
   - 顧客選択（下書き以外は編集不可）
   - 請求日（下書き以外は編集不可）
   - 支払期日/支払条件

4. **タブエリア**
   - 作成画面と同一構成

5. **アクションエリア**
   - 保存ボタン（Filament標準）
   - キャンセルボタン（Filament標準）

## 入出力項目

### 一般セクション

| 項目名 | 物理名 | データ型 | 必須 | 編集可否 | 説明 |
|--------|--------|----------|------|----------|------|
| 状態 | state | enum | - | 不可 | ステータス表示のみ |
| 顧客 | partner_id | integer | 任意 | 条件付き | POSTED/CANCEL時は編集不可 |
| 請求日 | invoice_date | date | 任意 | 条件付き | POSTED/CANCEL時は編集不可 |
| 支払期日 | invoice_date_due | date | 条件付き | 可 | 支払条件未設定時は必須 |
| 支払条件 | invoice_payment_term_id | integer | 条件付き | 可 | 支払期日未設定時は必須 |

### 明細行・その他情報

作成画面と同一の入出力項目。ただし、POSTED/CANCEL状態では商品関連フィールドが編集不可となる。

## 表示項目

該当なし（編集画面のため出力専用項目なし）

## イベント仕様

### 1-保存ボタン押下

フォーム内容をバリデーション後、データベースのレコードを更新する。更新後にAccount::computeAccountMoveで会計再計算が実行される。成功時は詳細画面へ遷移。

### 2-Chatterアクション

サイドパネルでコメント・アクティビティを表示・追加できる。

### 3-支払アクション

支払処理を開始するモーダルを表示する。

### 4-確認アクション

クレジットノートを転記済み状態に変更する。

### 5-キャンセルアクション

クレジットノートをキャンセル状態に変更する。

### 6-下書きに戻すアクション

転記済み/キャンセル状態のクレジットノートを下書きに戻す。

### 7-プレビューアクション

クレジットノート専用テンプレートでプレビューをモーダル表示する。

### 8-印刷・送信アクション

クレジットノートの印刷または送信処理を実行する。

### 9-削除アクション

レコードを削除し、一覧画面へ遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_account_moves | UPDATE | ヘッダーレコードの更新 |
| 保存ボタン押下 | accounts_account_move_lines | INSERT/UPDATE/DELETE | 明細レコードの変更 |
| 確認アクション | accounts_account_moves | UPDATE | state→POSTEDに変更 |
| キャンセルアクション | accounts_account_moves | UPDATE | state→CANCELに変更 |
| 下書きに戻す | accounts_account_moves | UPDATE | state→DRAFTに変更 |
| 削除アクション | accounts_account_moves | DELETE | レコード削除 |

### テーブル別更新項目詳細

#### accounts_account_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | partner_id | フォーム入力値またはレコード値 | null合体演算子で既存値をフォールバック |
| UPDATE | invoice_date | フォーム入力値またはレコード値 | null合体演算子で既存値をフォールバック |
| UPDATE | name | フォーム入力値またはレコード値 | null合体演算子で既存値をフォールバック |
| UPDATE | auto_post | フォーム入力値またはレコード値 | null合体演算子で既存値をフォールバック |
| UPDATE | invoice_currency_rate | 1.0（デフォルト） | - |
| UPDATE | updated_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 成功 | 更新成功通知（タイトル・本文） | レコード更新成功時 |
| エラー | バリデーションエラー | 必須項目未入力時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| レコードが存在しない | 404エラー表示 |
| バリデーションエラー | エラーメッセージを該当フィールドに表示 |
| データベースエラー | Filament標準のエラー処理 |
| 権限不足 | アクセス拒否エラー表示 |

## 備考

- EditCreditNoteはEditInvoiceを継承しており、多くの機能を請求書編集から引き継いでいる
- ヘッダーアクションから「確認済みに設定（set-as-checked）」と「クレジットノート（credit-note）」アクションは除外されている
- プレビューアクションはクレジットノート専用テンプレート（accounts::credit-note/actions/preview.index）を使用
- mutateFormDataBeforeSaveで既存値とのマージ処理が行われる
- 保存後にAccount::computeAccountMoveメソッドで会計再計算が実行される
- 状態がPOSTEDまたはCANCELの場合、顧客選択や商品フィールドなど一部フィールドが編集不可になる
