# 画面設計書 171-出庫作成

## 概要

本ドキュメントは、Aureus ERPシステムにおける「出庫作成」画面の設計書です。在庫モジュール（Inventories）のオペレーション機能の一部として、新規出庫処理を作成するための画面について詳述します。

### 本画面の処理概要

**業務上の目的・背景**：出庫作成画面は、倉庫から顧客や外部ロケーションへの商品出荷を管理するために必要な画面です。販売注文に基づく出荷処理や、倉庫間移動の出庫処理など、在庫の出庫オペレーションを新規に作成する業務課題を解決します。出庫処理を正確に記録することで、在庫管理の精度を維持し、顧客への配送追跡を可能にします。

**画面へのアクセス方法**：サイドナビゲーションの「在庫」モジュール内の「オペレーション」クラスターから「出庫」を選択し、一覧画面の「新規作成」ボタンをクリックすることでアクセスできます。URLは `/inventories/operations/deliveries/create` です。

**主要な操作・処理内容**：
1. 配送先（パートナー）の選択：出庫先の顧客や配送先住所を選択
2. オペレーションタイプの選択：出庫タイプを指定（デフォルトはOUTGOINGタイプ）
3. ソースロケーションの選択：出庫元となる倉庫内のロケーションを指定
4. 出庫対象商品の追加：Repeaterコンポーネントを使用して複数の商品・数量を追加
5. 追加情報の入力：担当者、配送ポリシー、予定日時、ソースドキュメント等を入力
6. ノートの追加：リッチエディタでメモを追加

**画面遷移**：
- この画面から：作成完了後、出庫編集画面（/inventories/operations/deliveries/{id}/edit）へ遷移
- この画面に：出庫一覧画面の「新規作成」ボタンから遷移

**権限による表示制御**：出庫の作成権限を持つユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-007 | 出荷作成 | 主機能 | 新規出庫オペレーションの作成 |
| FN-INV-006 | 出荷一覧 | 遷移元機能 | 一覧画面からの遷移 |

## 画面種別

登録画面（CreateRecord）

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/inventories/operations/deliveries/create` |
| ルート名 | `filament.inventories.resources.deliveries.create` |
| Resource | `DeliveryResource` |
| Page | `CreateDelivery` |

## 画面構成

```
+----------------------------------------------------------+
| [サブナビゲーション]                                      |
+----------------------------------------------------------+
| タイトル: 出庫作成                                        |
+----------------------------------------------------------+
| [ProgressStepper: 状態表示] Draft → Confirmed → ...       |
+----------------------------------------------------------+
| ┌─ 一般情報セクション ─────────────────────────────┐      |
| │ 配送先         [Select]  オペレーションタイプ [Select] │ |
| │ ソースロケーション [Select]                           │ |
| └──────────────────────────────────────────────────────┘  |
+----------------------------------------------------------+
| ┌─ タブコンポーネント ──────────────────────────────┐     |
| │ [オペレーション] [追加情報] [ノート]                   │ |
| │ ┌─ 商品Repeater ────────────────────────────────┐      │ |
| │ │ 商品名 | ロケーション | 数量 | 単位 | ピック済   │   │ |
| │ │ [+行追加]                                      │      │ |
| │ └──────────────────────────────────────────────────┘    │ |
| └──────────────────────────────────────────────────────┘  |
+----------------------------------------------------------+
| [保存ボタン]                                              |
+----------------------------------------------------------+
```

## 入出力項目

### 一般情報セクション

| No | 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|----|--------|--------|-----|------|-----------|------|
| 1 | 配送先 | partner_id | Select | - | 入力 | 配送先パートナーを選択 |
| 2 | オペレーションタイプ | operation_type_id | Select | ○ | 入力 | 出庫オペレーションタイプ（デフォルト：OUTGOING） |
| 3 | ソースロケーション | source_location_id | Select | ○ | 入力 | 出庫元のロケーション |
| 4 | 出庫先ロケーション | destination_location_id | Select | ○ | 入力 | 出庫先のロケーション（OUTGOING時は非表示） |

### オペレーションタブ（商品Repeater）

| No | 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|----|--------|--------|-----|------|-----------|------|
| 1 | 商品 | product_id | Select | ○ | 入力 | 出庫対象の商品を選択 |
| 2 | 最終ロケーション | final_location_id | Select | - | 入力 | 最終配送先ロケーション |
| 3 | 説明 | description_picking | TextInput | - | 入力 | ピッキング説明 |
| 4 | 予定日時 | scheduled_at | DateTimePicker | - | 入力 | 出庫予定日時 |
| 5 | 期限 | deadline | DateTimePicker | - | 入力 | 出庫期限 |
| 6 | パッケージング | product_packaging_id | Select | - | 入力 | 商品パッケージング |
| 7 | 要求数量 | product_uom_qty | TextInput | ○ | 入力 | 要求される数量 |
| 8 | 数量 | quantity | TextInput | ○ | 入力 | 実際の出庫数量 |
| 9 | 単位 | uom_id | Select | ○ | 入力 | 数量単位 |
| 10 | ピック済 | is_picked | Toggle | - | 入力 | ピッキング完了フラグ |

### 追加情報タブ

| No | 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|----|--------|--------|-----|------|-----------|------|
| 1 | 担当者 | user_id | Select | - | 入力 | 担当ユーザー（デフォルト：ログインユーザー） |
| 2 | 配送ポリシー | move_type | Select | - | 入力 | DIRECT/ONE配送ポリシー |
| 3 | 予定日時 | scheduled_at | DateTimePicker | - | 入力 | 出庫予定日時 |
| 4 | ソースドキュメント | origin | TextInput | - | 入力 | 元となるドキュメント参照 |

### ノートタブ

| No | 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|----|--------|--------|-----|------|-----------|------|
| 1 | 説明 | description | RichEditor | - | 入力 | 出庫に関するノート |

## 表示項目

| No | 項目名 | 表示形式 | 説明 |
|----|--------|----------|------|
| 1 | 状態 | ProgressStepper | 出庫処理の状態（Draft/Confirmed/Assigned/Done/Canceled） |

## イベント仕様

### 1-保存ボタン押下

保存ボタン押下時に新規出庫レコードを作成し、編集画面へ遷移します。

**処理フロー**：
1. フォームバリデーションを実行
2. `mutateFormDataBeforeCreate`で以下のデータを設定：
   - `company_id`：オペレーションタイプのソースロケーションの会社ID
   - `source_location_id`：オペレーションタイプのソースロケーションID
   - `destination_location_id`：オペレーションタイプの出庫先ロケーションID
   - `state`：DRAFT（下書き状態）
   - `creator_id`：ログインユーザーID
3. Deliveryモデルを作成
4. 成功通知を表示
5. 編集画面へリダイレクト

### 2-オペレーションタイプ変更

オペレーションタイプを変更すると、関連するロケーションが自動設定されます。

**処理フロー**：
1. 選択されたオペレーションタイプを取得
2. ソースロケーションIDを自動設定
3. 出庫先ロケーションIDを自動設定

### 3-商品選択

商品を選択すると、関連する情報が自動設定されます。

**処理フロー**：
1. 選択した商品の情報を取得
2. 単位（UOM）を商品の単位に設定
3. 商品数量を計算
4. 最適なパッケージングを自動選択

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | inventories_operations | INSERT | 出庫オペレーションレコードを作成 |
| 商品追加 | inventories_moves | INSERT | 出庫移動レコードを作成 |

### テーブル別更新項目詳細

#### inventories_operations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | オペレーションタイプのシーケンスコード + ID | 自動生成 |
| INSERT | operation_type_id | フォーム入力値 | 必須 |
| INSERT | partner_id | フォーム入力値 | 配送先 |
| INSERT | source_location_id | オペレーションタイプから取得 | - |
| INSERT | destination_location_id | オペレーションタイプから取得 | - |
| INSERT | state | 'draft' | 初期状態 |
| INSERT | move_type | フォーム入力値またはDIRECT | - |
| INSERT | scheduled_at | フォーム入力値またはnow() | - |
| INSERT | origin | フォーム入力値 | - |
| INSERT | description | フォーム入力値 | - |
| INSERT | user_id | フォーム入力値 | - |
| INSERT | company_id | ソースロケーションの会社ID | - |
| INSERT | creator_id | Auth::id() | ログインユーザー |

#### inventories_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | product_id | Repeaterの入力値 | 必須 |
| INSERT | product_uom_qty | Repeaterの入力値 | 要求数量 |
| INSERT | quantity | Repeaterの入力値 | 実数量 |
| INSERT | uom_id | Repeaterの入力値 | 単位 |
| INSERT | operation_id | 親オペレーションID | - |
| INSERT | state | 親オペレーションの状態 | - |
| INSERT | source_location_id | 親オペレーションから継承 | - |
| INSERT | destination_location_id | 親オペレーションから継承 | - |
| INSERT | scheduled_at | Repeaterの入力値またはnow() | - |
| INSERT | creator_id | Auth::id() | - |

## メッセージ仕様

| No | 種別 | タイミング | メッセージ内容 | 備考 |
|----|------|----------|---------------|------|
| 1 | 成功 | 出庫作成成功時 | 出庫が正常に作成されました | 通知で表示 |
| 2 | エラー | バリデーションエラー時 | 各フィールドに応じたエラーメッセージ | フォームバリデーション |

## 例外処理

| No | 例外条件 | 処理内容 | 表示メッセージ |
|----|----------|----------|---------------|
| 1 | 必須項目未入力 | フォームバリデーションエラー | 各フィールドの必須エラーメッセージ |
| 2 | オペレーションタイプ未設定 | 作成処理を中止 | オペレーションタイプを選択してください |
| 3 | 権限不足 | アクセス拒否 | この操作を行う権限がありません |

## 備考

- 出庫オペレーションはDeliveryモデルとして扱われますが、内部的にはOperationモデルを継承しています
- オペレーションタイプがOUTGOING（出庫）の場合、出庫先ロケーション選択は非表示になります
- ロケーション機能が無効化されている場合、ロケーション関連のフィールドは非表示になります
- パッケージング機能が有効な場合のみパッケージング選択が表示されます
- UOM（単位）機能が有効な場合のみ単位選択が表示されます
