# 画面設計書 172-出庫編集

## 概要

本ドキュメントは、Aureus ERPシステムにおける「出庫編集」画面の設計書です。在庫モジュール（Inventories）のオペレーション機能の一部として、既存の出庫処理を編集するための画面について詳述します。

### 本画面の処理概要

**業務上の目的・背景**：出庫編集画面は、作成済みの出庫オペレーションを編集し、出庫処理のワークフローを進めるために必要な画面です。下書き状態の出庫の詳細情報を変更したり、在庫可用性を確認したり、出庫を確定（バリデート）したりする業務課題を解決します。

**画面へのアクセス方法**：出庫一覧画面から対象レコードの編集ボタンをクリック、または出庫作成後のリダイレクト、詳細画面からの遷移でアクセスできます。URLは `/inventories/operations/deliveries/{record}/edit` です。

**主要な操作・処理内容**：
1. 出庫情報の編集：配送先、商品、数量などの変更
2. 在庫可用性確認：CheckAvailabilityアクションで在庫状況を確認
3. 出庫の確定（バリデート）：ValidateActionで出庫を確定し、在庫を更新
4. 返品処理：ReturnActionで返品オペレーションを作成
5. キャンセル：CancelActionで出庫処理をキャンセル
6. 印刷：ピッキングリスト、配送伝票、パッケージ、ラベルの印刷

**画面遷移**：
- この画面から：出庫一覧、出庫詳細、移動管理へ遷移可能
- この画面に：出庫一覧、出庫作成完了後、出庫詳細から遷移

**権限による表示制御**：出庫の編集権限を持つユーザーのみがこの画面にアクセス可能です。状態がDONE（完了）の場合、削除ボタンは非表示になります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-008 | 出荷編集 | 主機能 | 出庫オペレーションの編集 |
| FN-INV-006 | 出荷一覧 | 遷移元/遷移先 | 一覧画面との遷移 |
| FN-INV-009 | 出荷詳細 | 遷移先 | 詳細画面への遷移 |

## 画面種別

編集画面（EditRecord）

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/inventories/operations/deliveries/{record}/edit` |
| ルート名 | `filament.inventories.resources.deliveries.edit` |
| Resource | `DeliveryResource` |
| Page | `EditDelivery` |

## 画面構成

```
+----------------------------------------------------------+
| [サブナビゲーション] [詳細] [編集] [移動管理]             |
+----------------------------------------------------------+
| タイトル: {出庫名}                                        |
+----------------------------------------------------------+
| [ヘッダーアクション]                                      |
| [チャット] [Todo] [在庫確認] [確定] [キャンセル]          |
| [返品] [印刷メニュー] [削除]                              |
+----------------------------------------------------------+
| [ProgressStepper: 状態表示] Draft → Confirmed → ...       |
+----------------------------------------------------------+
| ┌─ 一般情報セクション ─────────────────────────────┐      |
| │ 配送先         [Select]  オペレーションタイプ [Select] │ |
| │ ソースロケーション [Select]                           │ |
| └──────────────────────────────────────────────────────┘  |
+----------------------------------------------------------+
| ┌─ タブコンポーネント ──────────────────────────────┐     |
| │ [オペレーション] [追加情報] [ノート]                   │ |
| │ ┌─ 商品Repeater ────────────────────────────────┐      │ |
| │ │ 商品名 | ロケーション | 数量 | 単位 | ピック済   │   │ |
| │ │ [+行追加]                                      │      │ |
| │ └──────────────────────────────────────────────────┘    │ |
| └──────────────────────────────────────────────────────┘  |
+----------------------------------------------------------+
| [保存ボタン]                                              |
+----------------------------------------------------------+
```

## ヘッダーアクション

| No | アクション名 | アイコン | 表示条件 | 説明 |
|----|------------|---------|----------|------|
| 1 | チャット | ChatterAction | 常時 | 出庫に関するコメント・コミュニケーション |
| 2 | Todo | TodoAction | 常時 | 関連タスクの管理 |
| 3 | 在庫確認 | CheckAvailabilityAction | 確定前 | 在庫可用性を確認 |
| 4 | 確定 | ValidateAction | Draft/Confirmed状態 | 出庫を確定し在庫を更新 |
| 5 | キャンセル | CancelAction | 完了以外 | 出庫処理をキャンセル |
| 6 | 返品 | ReturnAction | 完了後 | 返品オペレーションを作成 |
| 7 | 印刷 | ActionGroup | 常時 | 各種帳票の印刷メニュー |
| 8 | 削除 | DeleteAction | state != DONE | 出庫を削除 |

### 印刷アクショングループ

| No | アクション名 | 説明 |
|----|------------|------|
| 1 | ピッキングオペレーション | PickingOperationAction - ピッキングリストの印刷 |
| 2 | 配送伝票 | DeliverySlipAction - 配送伝票の印刷 |
| 3 | パッケージ | PackageAction - パッケージラベルの印刷 |
| 4 | ラベル | LabelsAction - 商品ラベルの印刷 |

## 入出力項目

### 一般情報セクション

| No | 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|----|--------|--------|-----|------|-----------|------|
| 1 | 配送先 | partner_id | Select | - | 入力 | 配送先パートナーを選択 |
| 2 | オペレーションタイプ | operation_type_id | Select | ○ | 入力 | 出庫オペレーションタイプ |
| 3 | ソースロケーション | source_location_id | Select | ○ | 入力 | 出庫元のロケーション |
| 4 | 出庫先ロケーション | destination_location_id | Select | ○ | 入力 | 出庫先のロケーション（OUTGOING時は非表示） |

### オペレーションタブ（商品Repeater）

| No | 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|----|--------|--------|-----|------|-----------|------|
| 1 | 商品 | product_id | Select | ○ | 入力 | 出庫対象の商品を選択 |
| 2 | 最終ロケーション | final_location_id | Select | - | 入力 | 最終配送先ロケーション |
| 3 | 説明 | description_picking | TextInput | - | 入力 | ピッキング説明 |
| 4 | 予定日時 | scheduled_at | DateTimePicker | - | 入力 | 出庫予定日時 |
| 5 | 期限 | deadline | DateTimePicker | - | 入力 | 出庫期限 |
| 6 | パッケージング | product_packaging_id | Select | - | 入力 | 商品パッケージング |
| 7 | 要求数量 | product_uom_qty | TextInput | ○ | 入力 | 要求される数量 |
| 8 | 数量 | quantity | TextInput | ○ | 入力 | 実際の出庫数量 |
| 9 | 単位 | uom_id | Select | ○ | 入力 | 数量単位 |
| 10 | ピック済 | is_picked | Toggle | - | 入力 | ピッキング完了フラグ |

### 追加情報タブ

| No | 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|----|--------|--------|-----|------|-----------|------|
| 1 | 担当者 | user_id | Select | - | 入力 | 担当ユーザー |
| 2 | 配送ポリシー | move_type | Select | - | 入力 | DIRECT/ONE配送ポリシー |
| 3 | 予定日時 | scheduled_at | DateTimePicker | - | 入力 | 出庫予定日時 |
| 4 | ソースドキュメント | origin | TextInput | - | 入力 | 元となるドキュメント参照 |

### ノートタブ

| No | 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|----|--------|--------|-----|------|-----------|------|
| 1 | 説明 | description | RichEditor | - | 入力 | 出庫に関するノート |

## 表示項目

| No | 項目名 | 表示形式 | 説明 |
|----|--------|----------|------|
| 1 | 状態 | ProgressStepper | 出庫処理の状態（Draft/Confirmed/Assigned/Done/Canceled） |
| 2 | 出庫名 | タイトル | 画面タイトルとして表示 |

## イベント仕様

### 1-保存ボタン押下

保存ボタン押下時に出庫レコードを更新します。

**処理フロー**：
1. フォームバリデーションを実行
2. Deliveryモデルを更新
3. 関連するMovesを更新
4. 成功通知を表示
5. 編集画面をリフレッシュ

### 2-在庫確認アクション（CheckAvailabilityAction）

在庫の可用性を確認し、予約可能な在庫を割り当てます。

**処理フロー**：
1. 各移動アイテムの在庫可用性を確認
2. 利用可能な在庫を予約
3. 状態を更新（Assigned等）
4. 結果を通知

### 3-確定アクション（ValidateAction）

出庫を確定し、在庫を更新します。

**処理フロー**：
1. 出庫可能かのバリデーション
2. 在庫数量を減少
3. 状態をDONEに更新
4. closed_atを現在時刻に設定
5. 成功通知を表示

### 4-キャンセルアクション（CancelAction）

出庫処理をキャンセルします。

**処理フロー**：
1. キャンセル可能かの確認
2. 予約された在庫を解放
3. 状態をCANCELEDに更新
4. 成功通知を表示

### 5-返品アクション（ReturnAction）

返品オペレーションを作成します。

**処理フロー**：
1. 返品対象の選択ダイアログを表示
2. 返品オペレーションを作成
3. return_idに元のオペレーションIDを設定
4. 返品オペレーションの編集画面へ遷移

### 6-削除アクション（DeleteAction）

出庫を削除します。状態がDONEの場合は非表示になります。

**処理フロー**：
1. 削除確認ダイアログを表示
2. 関連するMovesを削除
3. Deliveryを削除
4. 成功通知を表示
5. 一覧画面へリダイレクト

**例外処理**：
- QueryException発生時：エラー通知を表示し、削除を中止

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | inventories_operations | UPDATE | 出庫オペレーションレコードを更新 |
| 保存ボタン押下 | inventories_moves | UPDATE/INSERT/DELETE | 商品移動レコードを更新 |
| 確定アクション | inventories_operations | UPDATE | 状態をDONEに更新 |
| 確定アクション | inventories_product_quantities | UPDATE | 在庫数量を更新 |
| キャンセルアクション | inventories_operations | UPDATE | 状態をCANCELEDに更新 |
| 返品アクション | inventories_operations | INSERT | 返品オペレーションを作成 |
| 削除アクション | inventories_operations | DELETE | 出庫を削除 |

### テーブル別更新項目詳細

#### inventories_operations（保存時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | partner_id | フォーム入力値 | - |
| UPDATE | operation_type_id | フォーム入力値 | - |
| UPDATE | source_location_id | フォーム入力値 | - |
| UPDATE | destination_location_id | フォーム入力値 | - |
| UPDATE | move_type | フォーム入力値 | - |
| UPDATE | scheduled_at | フォーム入力値 | - |
| UPDATE | origin | フォーム入力値 | - |
| UPDATE | description | フォーム入力値 | - |
| UPDATE | user_id | フォーム入力値 | - |
| UPDATE | updated_at | now() | 自動 |

#### inventories_operations（確定時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | state | 'done' | - |
| UPDATE | closed_at | now() | - |
| UPDATE | updated_at | now() | 自動 |

## メッセージ仕様

| No | 種別 | タイミング | メッセージ内容 | 備考 |
|----|------|----------|---------------|------|
| 1 | 成功 | 保存成功時 | 出庫が正常に更新されました | 通知で表示 |
| 2 | 成功 | 削除成功時 | 出庫が正常に削除されました | 通知で表示 |
| 3 | エラー | 削除エラー時 | この出庫は削除できません | 関連データ存在時 |
| 4 | エラー | バリデーションエラー時 | 各フィールドに応じたエラーメッセージ | - |

## 例外処理

| No | 例外条件 | 処理内容 | 表示メッセージ |
|----|----------|----------|---------------|
| 1 | 必須項目未入力 | フォームバリデーションエラー | 各フィールドの必須エラーメッセージ |
| 2 | 削除時のQueryException | 削除処理を中止 | この出庫は削除できません |
| 3 | 権限不足 | アクセス拒否 | この操作を行う権限がありません |
| 4 | 完了済み出庫の削除試行 | 削除ボタン非表示 | - |

## 備考

- HasRecordNavigationTabsトレイトを使用してサブナビゲーションを実装
- 保存後は同じ編集画面にリダイレクトされる（getRedirectUrl）
- updateFormメソッドでフォームの再読み込みが可能
- 印刷アクションはActionGroupでグループ化されている
- 状態がDONEの場合、削除ボタンは非表示になる
- ChatterActionでコメント機能が利用可能
