# 画面設計書 175-オペレーション移動管理

## 概要

本ドキュメントは、Aureus ERPシステムにおける「オペレーション移動管理」画面の設計書です。在庫モジュール（Inventories）のオペレーション機能の一部として、個々のオペレーションに紐づく移動明細（MoveLines）を管理するための画面について詳述します。

### 本画面の処理概要

**業務上の目的・背景**：オペレーション移動管理画面は、入庫・出庫・内部移動などのオペレーションに関連する在庫移動の詳細を確認・管理するための画面です。各商品の移動履歴、ロット情報、パッケージ情報、処理状態などを一覧で確認できます。

**画面へのアクセス方法**：各オペレーション（入庫、出庫、内部移動等）の詳細画面または編集画面のサブナビゲーションから「移動」タブをクリックしてアクセスします。URLは `/inventories/operations/{operation-type}/{record}/moves` です。

**主要な操作・処理内容**：
1. 移動明細の確認：オペレーションに紐づく全ての移動明細を一覧表示
2. 移動明細の削除：完了していない移動明細を削除
3. ソート・フィルタ：各列でのソートとフィルタリング

**画面遷移**：
- この画面から：特になし（関連レコード管理画面）
- この画面に：オペレーション詳細、オペレーション編集から遷移

**権限による表示制御**：オペレーションの閲覧権限を持つユーザーがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-011 | 移動管理 | 主機能 | 移動明細の管理 |

## 画面種別

関連レコード管理画面（ManageRelatedRecords）

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/inventories/operations/{operation-type}/{record}/moves` |
| ルート名 | `filament.inventories.resources.{operation-type}.moves` |
| Resource | `OperationResource`（およびその派生リソース） |
| Page | `ManageMoves` |

## 画面構成

```
+----------------------------------------------------------+
| [サブナビゲーション] [詳細] [編集] [移動管理]             |
+----------------------------------------------------------+
| タイトル: 移動管理                                        |
| ナビゲーションアイコン: arrows-right-left                 |
+----------------------------------------------------------+
| ┌─ テーブル ─────────────────────────────────────────┐    |
| │ 予定日時 | 参照 | ロット | パッケージ | ソースロケ     │ |
| │ ション | 出庫先ロケーション | 数量 | 状態 | 処理者 |    │ |
| │ [削除]                                               │ |
| └──────────────────────────────────────────────────────┘  |
+----------------------------------------------------------+
```

## 関連付け

| 項目 | 値 |
|------|-----|
| 親リソース | OperationResource |
| リレーション名 | moveLines |
| 関連モデル | MoveLine |

## テーブル表示項目

| No | 項目名 | 項目ID | 型 | ソート | 検索 | 表示条件 | 説明 |
|----|--------|--------|-----|--------|------|----------|------|
| 1 | 予定日時 | scheduled_at | TextColumn | ○ | - | 常時 | 移動予定日時（dateTime形式） |
| 2 | 参照 | reference | TextColumn | ○ | ○ | 常時 | 移動の参照番号 |
| 3 | ロット | lot.name | TextColumn | ○ | - | enable_lots_serial_numbers有効時かつ商品がQTYトラッキング以外 | ロット/シリアル番号 |
| 4 | パッケージ | package.name | TextColumn | ○ | - | enable_packages有効時 | パッケージ名 |
| 5 | ソースロケーション | sourceLocation.full_name | TextColumn | - | - | enable_locations有効時 | 移動元ロケーション |
| 6 | 出庫先ロケーション | destinationLocation.full_name | TextColumn | - | - | enable_locations有効時 | 移動先ロケーション |
| 7 | 数量 | uom_qty | TextColumn | ○ | - | 常時 | 移動数量（出庫先がINTERNALなら緑、それ以外は赤） |
| 8 | 状態 | state | TextColumn | ○ | - | 常時（デフォルト非表示） | 移動状態（バッジ表示） |
| 9 | 処理者 | creator.name | TextColumn | ○ | - | 常時 | 処理を行ったユーザー |

## レコードアクション

| No | アクション名 | アイコン | 表示条件 | 説明 |
|----|------------|---------|----------|------|
| 1 | 削除 | DeleteAction | state != DONE | 移動明細を削除 |

## イベント仕様

### 1-削除アクション（DeleteAction）

移動明細を削除します。状態がDONEの場合は非表示になります。

**処理フロー**：
1. 削除確認ダイアログを表示
2. MoveLineを削除
3. 成功通知を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | inventories_move_lines | DELETE | 移動明細を削除 |

## メッセージ仕様

| No | 種別 | タイミング | メッセージ内容 | 備考 |
|----|------|----------|---------------|------|
| 1 | 成功 | 削除成功時 | 移動明細が正常に削除されました | 通知で表示 |

## 例外処理

| No | 例外条件 | 処理内容 | 表示メッセージ |
|----|----------|----------|---------------|
| 1 | 完了済み移動明細の削除試行 | 削除ボタン非表示 | - |
| 2 | 権限不足 | アクセス拒否 | この操作を行う権限がありません |

## 設定による表示制御

| 設定名 | 設定クラス | 影響する項目 |
|--------|----------|-------------|
| enable_lots_serial_numbers | TraceabilitySettings | ロット列の表示 |
| enable_packages | OperationSettings | パッケージ列の表示 |
| enable_locations | WarehouseSettings | ソースロケーション・出庫先ロケーション列の表示 |

## 備考

- HasRecordNavigationTabsトレイトを使用してサブナビゲーションを実装
- 親オペレーションのtracking属性がProductTracking::QTYの場合、ロット列は非表示
- テーブルはcreated_atの降順でデフォルトソート
- 数量列の色は出庫先ロケーションのタイプに基づく：
  - INTERNAL（内部ロケーション）：緑（success）= 在庫増加
  - その他：赤（danger）= 在庫減少
- ナビゲーションアイコンはheroicon-o-arrows-right-left
- 検索はreference列のみ（inventories_moves.referenceで検索）
