# 画面設計書 176-補充管理

## 概要

本ドキュメントは、Aureus ERPシステムにおける「補充管理」画面の設計書です。在庫モジュール（Inventories）のオペレーション機能の一部として、在庫補充ルール（オーダーポイント）を管理するための画面について詳述します。

### 本画面の処理概要

**業務上の目的・背景**：補充管理画面は、在庫の自動補充ルールを管理するための画面です。最小在庫、最大在庫、リードタイムなどを設定し、在庫が最小値を下回った際に自動または手動で補充オーダーを作成します。

**画面へのアクセス方法**：サイドナビゲーションの「在庫」モジュール内の「オペレーション」クラスターから「補充」を選択してアクセスします。URLは `/inventories/operations/replenishment` です。

**主要な操作・処理内容**：
1. 補充ルールの一覧表示：オーダーポイント設定を一覧表示
2. 補充ルールの作成：新規オーダーポイントを作成
3. プリセットビューによるフィルタリング：手動トリガー/自動トリガーでフィルタ

**画面遷移**：
- この画面から：補充ルール詳細、作成画面
- この画面に：サイドナビゲーションから遷移

**権限による表示制御**：補充管理の権限を持つユーザーのみがアクセス可能です。

**注記**：現在この画面は開発中（shouldRegisterNavigation = false）のため、ナビゲーションには表示されません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-012 | 補充管理 | 主機能 | オーダーポイントの管理 |

## 画面種別

管理画面（ManageRecords）

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/inventories/operations/replenishment` |
| ルート名 | `filament.inventories.resources.replenishment.index` |
| Resource | `ReplenishmentResource` |
| Page | `ManageReplenishment` |

## 画面構成

```
+----------------------------------------------------------+
| タイトル: 補充管理                                        |
+----------------------------------------------------------+
| [プリセットビュータブ]                                    |
| [手動トリガー] [自動トリガー]                             |
+----------------------------------------------------------+
| [ヘッダーアクション] [新規作成]                           |
+----------------------------------------------------------+
| [フィルター]                                              |
+----------------------------------------------------------+
| ┌─ テーブル ─────────────────────────────────────────┐    |
| │ （現在カラム未定義）                                   │ |
| └──────────────────────────────────────────────────────┘  |
+----------------------------------------------------------+
```

## プリセットビュー

| No | ビュー名 | アイコン | フィルタ条件 | 説明 |
|----|---------|---------|-------------|------|
| 1 | 手動トリガー | building-office | trigger = MANUAL | 手動でトリガーする補充ルール |
| 2 | 自動トリガー | building-office | trigger = AUTOMATIC | 自動でトリガーされる補充ルール |

## 入出力項目

### 新規作成フォーム

| No | 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|----|--------|--------|-----|------|-----------|------|
| - | （現在フォーム項目未定義） | - | - | - | - | 開発中のため未定義 |

## テーブル表示項目

| No | 項目名 | 項目ID | 型 | ソート | 検索 | 説明 |
|----|--------|--------|-----|--------|------|------|
| - | （現在カラム未定義） | - | - | - | - | 開発中のため未定義 |

## イベント仕様

### 1-新規作成

補充ルールを新規作成します。

**処理フロー**：
1. フォームバリデーションを実行
2. mutateDataUsingでデータを変換（現在空実装）
3. OrderPointを作成
4. 成功通知を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | inventories_order_points | INSERT | オーダーポイントを作成 |

## メッセージ仕様

| No | 種別 | タイミング | メッセージ内容 | 備考 |
|----|------|----------|---------------|------|
| 1 | 成功 | 新規作成成功時 | 補充ルールが正常に作成されました | 通知で表示 |

## 例外処理

| No | 例外条件 | 処理内容 | 表示メッセージ |
|----|----------|----------|---------------|
| 1 | 必須項目未入力 | フォームバリデーションエラー | 各フィールドの必須エラーメッセージ |
| 2 | 権限不足 | アクセス拒否 | この操作を行う権限がありません |

## 備考

- **開発中の画面**：`shouldRegisterNavigation = false`により、現在ナビゲーションには表示されません
- HasTableViewsトレイトを使用してプリセットビューを実装
- フォーム項目とテーブルカラムは現在未定義（開発中）
- フィルターはQueryBuilderを使用するが、constraintsは現在空
- SubNavigationPositionはTopに設定
- 対象モデルはOrderPoint（オーダーポイント）
- OrderPointTrigger enumを使用してトリガータイプを管理（MANUAL/AUTOMATIC）
