# 画面設計書 177-ドロップシップ一覧

## 概要

本ドキュメントは、Aureus ERPシステムにおける「ドロップシップ一覧」画面の設計書です。在庫モジュール（Inventories）のオペレーション機能の一部として、ドロップシップ（直送）オペレーションの一覧を表示・管理するための画面について詳述します。

### 本画面の処理概要

**業務上の目的・背景**：ドロップシップ一覧画面は、サプライヤーから顧客への直送オペレーションを管理するための画面です。自社倉庫を経由せずに、仕入先から直接顧客へ商品を発送するドロップシッピングの処理を一覧で確認・管理できます。

**画面へのアクセス方法**：サイドナビゲーションの「在庫」モジュール内の「オペレーション」クラスターから「ドロップシップ」を選択してアクセスします。URLは `/inventories/operations/dropships` です。ただし、LogisticSettingsのenable_dropshippingが有効な場合のみ表示されます。

**主要な操作・処理内容**：
1. ドロップシップ一覧の表示：ドロップシップオペレーションを一覧表示
2. 新規作成：ドロップシップ作成画面へ遷移
3. 詳細表示・編集：各レコードの詳細画面・編集画面へ遷移
4. 削除：完了していないドロップシップの削除
5. 一括削除：複数レコードの一括削除
6. プリセットビュー：OperationResourceから継承したフィルタ表示

**画面遷移**：
- この画面から：ドロップシップ作成、ドロップシップ編集、ドロップシップ詳細へ遷移
- この画面に：サイドナビゲーションから遷移

**権限による表示制御**：ドロップシップの閲覧権限を持つユーザーがアクセス可能です。状態がDONE（完了）の場合、削除アクションは非表示になります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-013 | ドロップシップ一覧 | 主機能 | ドロップシップオペレーションの一覧表示 |
| FN-INV-014 | ドロップシップ作成 | 遷移先 | 新規作成画面への遷移 |
| FN-INV-015 | ドロップシップ編集 | 遷移先 | 編集画面への遷移 |
| FN-INV-016 | ドロップシップ詳細 | 遷移先 | 詳細画面への遷移 |

## 画面種別

一覧画面（ListRecords）

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/inventories/operations/dropships` |
| ルート名 | `filament.inventories.resources.dropships.index` |
| Resource | `DropshipResource` |
| Page | `ListDropships` |

## 画面構成

```
+----------------------------------------------------------+
| タイトル: ドロップシップ                                  |
+----------------------------------------------------------+
| [プリセットビュータブ]                                    |
| （OperationResourceから継承）                             |
+----------------------------------------------------------+
| [ヘッダーアクション] [新規作成]                           |
+----------------------------------------------------------+
| [フィルター] [検索] [列表示設定]                          |
+----------------------------------------------------------+
| [一括操作] [削除]                                         |
+----------------------------------------------------------+
| ┌─ テーブル ─────────────────────────────────────────┐    |
| │ （OperationResourceから継承したカラム）                │ |
| │ 参照 | パートナー | 予定日 | ソース | 出庫先 | 状態    │ |
| │ [表示] [編集] [削除]                                 │ |
| └──────────────────────────────────────────────────────┘  |
+----------------------------------------------------------+
```

## 表示条件

| 条件 | 設定クラス | 説明 |
|------|----------|------|
| enable_dropshipping | LogisticSettings | ドロップシッピングが有効な場合のみ画面が表示される |

## プリセットビュー

OperationResourceから継承されるプリセットビューが使用されます。

## テーブル表示項目

OperationResourceから継承されるテーブルカラムが使用されます。加えて、以下のフィルタが適用されます：

| フィルタ | 条件 | 説明 |
|---------|------|------|
| operationType.type | DROPSHIP | ドロップシップタイプのオペレーションのみ表示 |

## ヘッダーアクション

| No | アクション名 | アイコン | 説明 |
|----|------------|---------|------|
| 1 | 新規作成 | plus-circle | ドロップシップ作成画面へ遷移 |

## レコードアクション

| No | アクション名 | 表示条件 | 説明 |
|----|------------|----------|------|
| 1 | 表示 | 常時 | 詳細画面へ遷移 |
| 2 | 編集 | 常時 | 編集画面へ遷移 |
| 3 | 削除 | state != DONE | ドロップシップを削除 |

## 一括アクション

| No | アクション名 | 説明 |
|----|------------|------|
| 1 | 一括削除 | 選択したレコードを一括削除 |

## イベント仕様

### 1-新規作成ボタン押下

ドロップシップ作成画面へ遷移します。

**処理フロー**：
1. `/inventories/operations/dropships/create` へ遷移

### 2-表示アクション

ドロップシップ詳細画面へ遷移します。

**処理フロー**：
1. `/inventories/operations/dropships/{record}/view` へ遷移

### 3-編集アクション

ドロップシップ編集画面へ遷移します。

**処理フロー**：
1. `/inventories/operations/dropships/{record}/edit` へ遷移

### 4-削除アクション

ドロップシップを削除します。状態がDONEの場合は非表示になります。

**処理フロー**：
1. 削除確認ダイアログを表示
2. Dropshipを削除
3. 成功通知を表示

**例外処理**：
- QueryException発生時：エラー通知を表示し、削除を中止

### 5-一括削除アクション

選択した複数のドロップシップを一括削除します。

**処理フロー**：
1. 削除確認ダイアログを表示
2. 選択された全てのDropshipを削除
3. 成功通知を表示

**例外処理**：
- QueryException発生時：エラー通知を表示し、削除を中止

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | inventories_operations | DELETE | ドロップシップを削除 |
| 一括削除アクション | inventories_operations | DELETE | 複数のドロップシップを削除 |

## メッセージ仕様

| No | 種別 | タイミング | メッセージ内容 | 備考 |
|----|------|----------|---------------|------|
| 1 | 成功 | 削除成功時 | ドロップシップが正常に削除されました | 通知で表示 |
| 2 | 成功 | 一括削除成功時 | ドロップシップが正常に削除されました | 通知で表示 |
| 3 | エラー | 削除エラー時 | ドロップシップを削除できませんでした | 関連データ存在時 |
| 4 | エラー | 一括削除エラー時 | ドロップシップを削除できませんでした | 関連データ存在時 |

## 例外処理

| No | 例外条件 | 処理内容 | 表示メッセージ |
|----|----------|----------|---------------|
| 1 | 削除時のQueryException | 削除処理を中止 | ドロップシップを削除できませんでした |
| 2 | 権限不足 | アクセス拒否 | この操作を行う権限がありません |
| 3 | 完了済みドロップシップの削除試行 | 削除ボタン非表示 | - |

## 備考

- HasTableViewsトレイトを使用してプリセットビューを実装
- テーブル定義はOperationResourceから継承（OperationResource::table($table)）
- 削除アクションはActionGroupでグループ化されている
- ドロップシップタイプのオペレーションのみ表示するため、whereHasでoperationType.type = DROPSHIPをフィルタ
- ナビゲーションアイコンはheroicon-o-truck
- ナビゲーションの並び順は4番目（navigationSort = 4）
- recordTitleAttributeはname
- デフォルトソートはid降順（orderByDesc('id')）
- LogisticSettings.enable_dropshippingが無効の場合、この画面は表示されない（isDiscovered = false）
