# 画面設計書 178-ドロップシップ作成

## 概要

本ドキュメントは、Aureus ERPシステムにおける「ドロップシップ作成」画面の設計書です。在庫モジュール（Inventories）のオペレーション機能の一部として、新規ドロップシップ（直送）オペレーションを作成するための画面について詳述します。

### 本画面の処理概要

**業務上の目的・背景**：ドロップシップ作成画面は、サプライヤーから顧客への直送オペレーションを新規作成するための画面です。自社倉庫を経由せずに、仕入先から直接顧客へ商品を発送するドロップシッピングの処理を作成します。

**画面へのアクセス方法**：ドロップシップ一覧画面の「新規作成」ボタンをクリックしてアクセスします。URLは `/inventories/operations/dropships/create` です。

**主要な操作・処理内容**：
1. オペレーションタイプの自動設定：DROPSHIPタイプが自動で設定される
2. ソース/出庫先ロケーションの自動設定：オペレーションタイプから継承
3. 配送先の選択：顧客や配送先パートナーを選択
4. 商品の追加：Repeaterで複数の商品・数量を追加
5. 追加情報の入力：担当者、配送ポリシー、予定日時等を入力

**画面遷移**：
- この画面から：作成完了後、ドロップシップ編集画面へ遷移
- この画面に：ドロップシップ一覧の「新規作成」ボタンから遷移

**権限による表示制御**：ドロップシップの作成権限を持つユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-014 | ドロップシップ作成 | 主機能 | 新規ドロップシップオペレーションの作成 |
| FN-INV-013 | ドロップシップ一覧 | 遷移元機能 | 一覧画面からの遷移 |

## 画面種別

登録画面（CreateRecord）

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/inventories/operations/dropships/create` |
| ルート名 | `filament.inventories.resources.dropships.create` |
| Resource | `DropshipResource` |
| Page | `CreateDropship` |

## 画面構成

```
+----------------------------------------------------------+
| [サブナビゲーション]                                      |
+----------------------------------------------------------+
| タイトル: ドロップシップ作成                              |
+----------------------------------------------------------+
| [ProgressStepper: 状態表示] Draft → Confirmed → ...       |
+----------------------------------------------------------+
| ┌─ 一般情報セクション ─────────────────────────────┐      |
| │ 配送先         [Select]  オペレーションタイプ [固定]   │ |
| │ ソースロケーション [自動設定]                          │ |
| └──────────────────────────────────────────────────────┘  |
+----------------------------------------------------------+
| ┌─ タブコンポーネント ──────────────────────────────┐     |
| │ [オペレーション] [追加情報] [ノート]                   │ |
| │ ┌─ 商品Repeater ────────────────────────────────┐      │ |
| │ │ 商品名 | ロケーション | 数量 | 単位 | ピック済   │   │ |
| │ │ [+行追加]                                      │      │ |
| │ └──────────────────────────────────────────────────┘    │ |
| └──────────────────────────────────────────────────────┘  |
+----------------------------------------------------------+
| [保存ボタン]                                              |
+----------------------------------------------------------+
```

## 入出力項目

### 一般情報セクション

| No | 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|----|--------|--------|-----|------|-----------|------|
| 1 | 配送先 | partner_id | Select | - | 入力 | 配送先パートナーを選択 |
| 2 | オペレーションタイプ | operation_type_id | Select | ○ | 出力 | DROPSHIPタイプが自動設定 |
| 3 | ソースロケーション | source_location_id | Select | ○ | 出力 | オペレーションタイプから自動設定 |
| 4 | 出庫先ロケーション | destination_location_id | Select | ○ | 出力 | オペレーションタイプから自動設定 |

### オペレーションタブ（商品Repeater）

| No | 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|----|--------|--------|-----|------|-----------|------|
| 1 | 商品 | product_id | Select | ○ | 入力 | ドロップシップ対象の商品を選択 |
| 2 | 最終ロケーション | final_location_id | Select | - | 入力 | 最終配送先ロケーション |
| 3 | 説明 | description_picking | TextInput | - | 入力 | ピッキング説明 |
| 4 | 予定日時 | scheduled_at | DateTimePicker | - | 入力 | 予定日時 |
| 5 | 期限 | deadline | DateTimePicker | - | 入力 | 期限 |
| 6 | パッケージング | product_packaging_id | Select | - | 入力 | 商品パッケージング |
| 7 | 要求数量 | product_uom_qty | TextInput | ○ | 入力 | 要求される数量 |
| 8 | 数量 | quantity | TextInput | ○ | 入力 | 実際の数量 |
| 9 | 単位 | uom_id | Select | ○ | 入力 | 数量単位 |
| 10 | ピック済 | is_picked | Toggle | - | 入力 | ピッキング完了フラグ |

### 追加情報タブ

| No | 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|----|--------|--------|-----|------|-----------|------|
| 1 | 担当者 | user_id | Select | - | 入力 | 担当ユーザー（デフォルト：ログインユーザー） |
| 2 | 配送ポリシー | move_type | Select | - | 入力 | DIRECT/ONE配送ポリシー |
| 3 | 予定日時 | scheduled_at | DateTimePicker | - | 入力 | 予定日時 |
| 4 | ソースドキュメント | origin | TextInput | - | 入力 | 元となるドキュメント参照 |

### ノートタブ

| No | 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 |
|----|--------|--------|-----|------|-----------|------|
| 1 | 説明 | description | RichEditor | - | 入力 | ドロップシップに関するノート |

## 表示項目

| No | 項目名 | 表示形式 | 説明 |
|----|--------|----------|------|
| 1 | 状態 | ProgressStepper | 処理の状態（Draft/Confirmed/Assigned/Done/Canceled） |

## イベント仕様

### 1-マウント時（mount）

画面表示時にDROPSHIPタイプのオペレーションタイプを自動設定します。

**処理フロー**：
1. parent::mount()を呼び出し
2. OperationType::where('type', Enums\OperationType::DROPSHIP)でDROPSHIPタイプを取得
3. operation_type_idを設定
4. source_location_idを設定
5. destination_location_idを設定
6. フォームに値を反映

### 2-保存ボタン押下

保存ボタン押下時に新規ドロップシップレコードを作成し、編集画面へ遷移します。

**処理フロー**：
1. フォームバリデーションを実行
2. `mutateFormDataBeforeCreate`で以下のデータを設定：
   - `company_id`：オペレーションタイプの出庫先ロケーションの会社ID
   - `source_location_id`：オペレーションタイプのソースロケーションID
   - `destination_location_id`：オペレーションタイプの出庫先ロケーションID
   - `state`：DRAFT（下書き状態）
   - `creator_id`：ログインユーザーID
3. Dropshipモデルを作成
4. 成功通知を表示
5. 編集画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | inventories_operations | INSERT | ドロップシップオペレーションレコードを作成 |
| 商品追加 | inventories_moves | INSERT | 移動レコードを作成 |

### テーブル別更新項目詳細

#### inventories_operations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | オペレーションタイプのシーケンスコード + ID | 自動生成 |
| INSERT | operation_type_id | DROPSHIPタイプのID | 自動設定 |
| INSERT | partner_id | フォーム入力値 | 配送先 |
| INSERT | source_location_id | オペレーションタイプから取得 | - |
| INSERT | destination_location_id | オペレーションタイプから取得 | - |
| INSERT | state | 'draft' | 初期状態 |
| INSERT | move_type | フォーム入力値またはDIRECT | - |
| INSERT | scheduled_at | フォーム入力値またはnow() | - |
| INSERT | origin | フォーム入力値 | - |
| INSERT | description | フォーム入力値 | - |
| INSERT | user_id | フォーム入力値 | - |
| INSERT | company_id | 出庫先ロケーションの会社ID | - |
| INSERT | creator_id | Auth::id() | ログインユーザー |

## メッセージ仕様

| No | 種別 | タイミング | メッセージ内容 | 備考 |
|----|------|----------|---------------|------|
| 1 | 成功 | 作成成功時 | ドロップシップが正常に作成されました | 通知で表示 |
| 2 | エラー | バリデーションエラー時 | 各フィールドに応じたエラーメッセージ | フォームバリデーション |

## 例外処理

| No | 例外条件 | 処理内容 | 表示メッセージ |
|----|----------|----------|---------------|
| 1 | 必須項目未入力 | フォームバリデーションエラー | 各フィールドの必須エラーメッセージ |
| 2 | DROPSHIPオペレーションタイプ未定義 | 作成処理でエラー | システムエラー |
| 3 | 権限不足 | アクセス拒否 | この操作を行う権限がありません |

## 備考

- ドロップシップオペレーションはDropshipモデルとして扱われますが、内部的にはOperationモデルを継承しています
- DROPSHIPタイプのオペレーションタイプが事前に設定されている必要があります
- オペレーションタイプ、ソースロケーション、出庫先ロケーションはマウント時に自動設定されます
- フォームはOperationResourceから共有されます
- getSubNavigationメソッドでサブナビゲーションを生成します
- company_idは出庫先ロケーションの会社IDが使用されます（出庫作成とは異なる点に注意）
