# 画面設計書 18-クレジットノート詳細

## 概要

本ドキュメントは、Aureus ERPシステムにおける「クレジットノート詳細」画面の設計仕様を定義するものである。

### 本画面の処理概要

クレジットノート詳細画面は、会計モジュールにおいて既存のクレジットノート（返品伝票・貸方票）の詳細情報を表示するための画面である。

**業務上の目的・背景**：クレジットノートの全情報を読み取り専用で確認する。顧客情報、請求日、明細行、金額、支払状態などを一覧表示し、必要に応じてワークフローアクション（確認、キャンセル、支払等）を実行できる。監査や問い合わせ対応時の情報確認に使用される。

**画面へのアクセス方法**：
1. クレジットノート一覧画面の各行の「表示」アクションから遷移
2. クレジットノート作成画面で保存成功後に自動遷移
3. クレジットノート編集画面で保存成功後に自動遷移
4. URL直接入力でもアクセス可能

**主要な操作・処理内容**：
1. クレジットノートの詳細情報を表示（読み取り専用）
2. ワークフローアクション（確認、キャンセル、下書きに戻す等）の実行
3. プレビュー表示
4. 印刷・送信
5. 支払処理

**画面遷移**：
- 編集アクション（ヘッダー内）：クレジットノート編集画面へ遷移
- プレビューアクション：モーダルでプレビュー表示
- 削除成功時：クレジットノート一覧画面へ遷移

**権限による表示制御**：Filament Resourceの標準的な権限管理に従い、表示権限を持つユーザーのみが画面にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-ACC-031 | クレジットノート管理 | 主機能 | クレジットノートの詳細表示 |
| FN-ACC-052 | クレジットノート管理 | 主機能 | 表示/削除/ワークフロー処理 |

## 画面種別

詳細

## URL/ルーティング

`/admin/accounts/credit-notes/{record}`

## 画面構成

1. **ヘッダーアクションエリア**
   - Chatterアクション（コメント・アクティビティ）
   - 支払アクション（PayAction）
   - 確認アクション（ConfirmAction）
   - キャンセルアクション（CancelAction）
   - 下書きに戻すアクション（ResetToDraftAction）
   - プレビューアクション（PreviewAction）- クレジットノート専用テンプレート
   - 印刷・送信アクション（PrintAndSendAction）
   - 削除アクション（DeleteAction）
   - ※「確認済みに設定」と「クレジットノート」アクションは除外

2. **支払状態セクション**
   - 支払状態のバッジ表示

3. **一般情報セクション**
   - クレジットノート番号（太字・大きいフォント）
   - 顧客名
   - 請求日
   - 支払期日/支払条件

4. **タブエリア**
   - **明細タブ**：商品明細のRepeatableEntry、合計サマリー
   - **その他情報タブ**：請求書詳細、会計情報、追加情報、マーケティング情報
   - **利用規約タブ**：備考・メモ

## 入出力項目

該当なし（詳細表示画面のため入力項目なし）

## 表示項目

### 一般セクション

| 項目名 | 物理名 | データ型 | アイコン | 説明 |
|--------|--------|----------|---------|------|
| 支払状態 | payment_state | enum | - | バッジ表示 |
| クレジットノート番号 | name | string | heroicon-o-document | ドキュメント番号 |
| 顧客 | partner.name / invoice_partner_display_name | string | heroicon-o-user | 顧客名 |
| 請求日 | invoice_date | date | heroicon-o-calendar | 請求日 |
| 支払期日 | invoice_date_due | date | heroicon-o-clock | 支払期限 |
| 支払条件 | invoicePaymentTerm.name | string | heroicon-o-calendar-days | 支払条件名 |

### 明細タブ

| 項目名 | 物理名 | データ型 | 説明 |
|--------|--------|----------|------|
| 商品名 | name | string | 商品/サービス名 |
| 数量 | quantity | numeric | 数量 |
| 単位 | uom.name | string | 単位名 |
| 単価 | price_unit | money | 単価（通貨フォーマット） |
| 割引 | discount | numeric | 割引率（%） |
| 税率 | taxes | array | 適用税率（バッジ表示） |
| 小計 | price_subtotal | money | 小計（通貨フォーマット） |

### その他情報タブ

| 項目名 | 物理名 | データ型 | アイコン | 説明 |
|--------|--------|----------|---------|------|
| 顧客参照 | reference | string | heroicon-o-hashtag | 顧客参照番号 |
| 担当者 | invoiceUser.name | string | heroicon-o-user | 営業担当者名 |
| 受取銀行 | partnerBank.account_number | string | heroicon-o-building-library | 銀行口座番号 |
| 支払参照 | payment_reference | string | heroicon-o-identification | 支払参照 |
| 納品日 | delivery_date | date | heroicon-o-truck | 納品日 |
| インコターム | invoiceIncoterm.name | string | heroicon-o-globe-alt | インコターム |
| インコターム場所 | incoterm_location | string | heroicon-o-map-pin | インコターム適用場所 |
| 支払方法 | paymentMethodLine.name | string | heroicon-o-credit-card | 支払方法 |
| 自動転記 | auto_post | boolean | heroicon-o-arrow-path | 自動転記フラグ |
| 確認済み | checked | boolean | heroicon-o-check-circle | 確認フラグ |
| 会社 | company.name | string | heroicon-o-building-office | 会社名 |
| 通貨 | currency.name | string | heroicon-o-banknotes | 通貨名 |
| キャンペーン | campaign.name | string | heroicon-o-presentation-chart-line | キャンペーン名 |
| メディア | medium.name | string | heroicon-o-device-phone-mobile | メディア名 |
| ソース | source.name | string | heroicon-o-link | ソース名 |

### 利用規約タブ

| 項目名 | 物理名 | データ型 | 説明 |
|--------|--------|----------|------|
| 備考 | narration | html | 備考・メモ（HTMLレンダリング） |

## イベント仕様

### 1-Chatterアクション

サイドパネルでコメント・アクティビティを表示・追加できる。

### 2-支払アクション

支払処理を開始するモーダルを表示する。

### 3-確認アクション

クレジットノートを転記済み状態に変更する。

### 4-キャンセルアクション

クレジットノートをキャンセル状態に変更する。

### 5-下書きに戻すアクション

転記済み/キャンセル状態のクレジットノートを下書きに戻す。

### 6-プレビューアクション

クレジットノート専用テンプレートでプレビューをモーダル表示する。

### 7-印刷・送信アクション

クレジットノートの印刷または送信処理を実行する。

### 8-削除アクション

確認後にレコードを削除し、一覧画面へ遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 表示時 | accounts_account_moves | SELECT | レコード情報の取得 |
| 確認アクション | accounts_account_moves | UPDATE | state→POSTEDに変更 |
| キャンセルアクション | accounts_account_moves | UPDATE | state→CANCELに変更 |
| 下書きに戻す | accounts_account_moves | UPDATE | state→DRAFTに変更 |
| 削除アクション | accounts_account_moves | DELETE | レコード削除 |

### テーブル別更新項目詳細

#### accounts_account_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE id = レコードID | 全フィールド取得 |
| UPDATE | state | POSTED/CANCEL/DRAFT | ワークフローアクションによる |
| DELETE | - | WHERE id = レコードID | 物理削除 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 成功 | 削除成功通知（タイトル・本文） | レコード削除成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| レコードが存在しない | 404エラー表示 |
| 権限不足 | アクセス拒否エラー表示 |

## 備考

- ViewCreditNoteはViewInvoiceを継承しており、多くの機能を請求書詳細から引き継いでいる
- ヘッダーアクションから「確認済みに設定（set-as-checked）」と「クレジットノート（credit-note）」アクションは除外されている
- プレビューアクションはクレジットノート専用テンプレート（accounts::credit-note/actions/preview.index）を使用
- 明細表示にはRepeatableEntryコンポーネントが使用され、テーブル形式で表示される
- InvoiceSummaryはLivewireコンポーネントで、合計金額をリアルタイム計算・表示する
- 各項目には適切なアイコンとプレースホルダー（'-'）が設定されている
