# 画面設計書 180-ドロップシップ詳細

## 概要

本ドキュメントは、Aureus ERPシステムにおける「ドロップシップ詳細」画面の設計書です。在庫モジュール（Inventories）のオペレーション機能の一部として、ドロップシップ（直送）オペレーションの詳細情報を参照するための画面について詳述します。

### 本画面の処理概要

**業務上の目的・背景**：ドロップシップ詳細画面は、作成済みのドロップシップオペレーションの内容を閲覧するための画面です。ドロップシップの状態、配送先、商品明細、処理履歴などを確認し、印刷や削除などの操作を行うことができます。

**画面へのアクセス方法**：ドロップシップ一覧画面から対象レコードの詳細ボタンをクリック、または編集画面のサブナビゲーションから遷移できます。URLは `/inventories/operations/dropships/{record}/view` です。

**主要な操作・処理内容**：
1. ドロップシップ情報の閲覧：配送先、オペレーションタイプ、商品明細などを表示
2. 印刷：ピッキングリスト、配送伝票、パッケージ、ラベルの印刷
3. コミュニケーション：Chatterでコメントを追加
4. 削除：完了していないドロップシップの削除

**画面遷移**：
- この画面から：ドロップシップ編集、移動管理へ遷移可能
- この画面に：ドロップシップ一覧、ドロップシップ編集から遷移

**権限による表示制御**：ドロップシップの閲覧権限を持つユーザーがアクセス可能です。状態がDONE（完了）の場合、削除ボタンは非表示になります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-016 | ドロップシップ詳細 | 主機能 | ドロップシップオペレーションの詳細表示 |
| FN-INV-013 | ドロップシップ一覧 | 遷移元/遷移先 | 一覧画面との遷移 |
| FN-INV-015 | ドロップシップ編集 | 遷移先 | 編集画面への遷移 |

## 画面種別

詳細画面（ViewRecord）

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/inventories/operations/dropships/{record}/view` |
| ルート名 | `filament.inventories.resources.dropships.view` |
| Resource | `DropshipResource` |
| Page | `ViewDropship` |

## 画面構成

```
+----------------------------------------------------------+
| [サブナビゲーション] [詳細] [編集] [移動管理]             |
+----------------------------------------------------------+
| タイトル: {ドロップシップ名}                              |
+----------------------------------------------------------+
| [ヘッダーアクション]                                      |
| [チャット] [印刷メニュー] [削除]                          |
+----------------------------------------------------------+
| [ProgressStepper: 状態表示] Draft → Confirmed → ...       |
+----------------------------------------------------------+
| ┌─ 一般情報セクション ─────────────────────────────┐      |
| │ 配送先: {パートナー名}                                 │ |
| │ オペレーションタイプ: {タイプ名}                       │ |
| │ ソースロケーション: {ロケーション名}                   │ |
| └──────────────────────────────────────────────────────┘  |
+----------------------------------------------------------+
| ┌─ タブコンポーネント ──────────────────────────────┐     |
| │ [オペレーション] [追加情報] [ノート]                   │ |
| │ ┌─ 商品一覧（RepeatableEntry） ─────────────────┐      │ |
| │ │ 商品名 | ロケーション | 数量 | 単位 | ピック済   │   │ |
| │ └──────────────────────────────────────────────────┘    │ |
| └──────────────────────────────────────────────────────┘  |
+----------------------------------------------------------+
```

## ヘッダーアクション

| No | アクション名 | アイコン | 表示条件 | 説明 |
|----|------------|---------|----------|------|
| 1 | チャット | ChatterAction | 常時 | コメント・コミュニケーション |
| 2 | 印刷 | ActionGroup | 常時 | 各種帳票の印刷メニュー |
| 3 | 削除 | DeleteAction | state != DONE | ドロップシップを削除 |

### 印刷アクショングループ

| No | アクション名 | 説明 |
|----|------------|------|
| 1 | ピッキングオペレーション | PickingOperationAction - ピッキングリストの印刷 |
| 2 | 配送伝票 | DeliverySlipAction - 配送伝票の印刷 |
| 3 | パッケージ | PackageAction - パッケージラベルの印刷 |
| 4 | ラベル | LabelsAction - 商品ラベルの印刷 |

## 表示項目

### 一般情報セクション

| No | 項目名 | 項目ID | 表示形式 | 説明 |
|----|--------|--------|----------|------|
| 1 | 配送先 | partner_id | TextEntry | 配送先パートナー名 |
| 2 | オペレーションタイプ | operation_type_id | TextEntry | ドロップシップオペレーションタイプ名 |
| 3 | ソースロケーション | source_location_id | TextEntry | ソースロケーション名 |
| 4 | 出庫先ロケーション | destination_location_id | TextEntry | 出庫先ロケーション名 |

### オペレーションタブ（商品RepeatableEntry）

| No | 項目名 | 項目ID | 表示形式 | 説明 |
|----|--------|--------|----------|------|
| 1 | 商品 | product_id | TextEntry | 商品名 |
| 2 | 最終ロケーション | final_location_id | TextEntry | 最終配送先ロケーション名 |
| 3 | 説明 | description_picking | TextEntry | ピッキング説明 |
| 4 | 予定日時 | scheduled_at | TextEntry | 予定日時 |
| 5 | 期限 | deadline | TextEntry | 期限 |
| 6 | 要求数量 | product_uom_qty | TextEntry | 要求される数量 |
| 7 | 数量 | quantity | TextEntry | 実際の数量 |
| 8 | 単位 | uom_id | TextEntry | 数量単位名 |
| 9 | ピック済 | is_picked | IconEntry | ピッキング完了アイコン |

### 追加情報タブ

| No | 項目名 | 項目ID | 表示形式 | 説明 |
|----|--------|--------|----------|------|
| 1 | 担当者 | user_id | TextEntry | 担当ユーザー名 |
| 2 | 配送ポリシー | move_type | TextEntry | 配送ポリシー（DIRECT/ONE） |
| 3 | 予定日時 | scheduled_at | TextEntry | 予定日時 |
| 4 | ソースドキュメント | origin | TextEntry | 元となるドキュメント参照 |

### ノートタブ

| No | 項目名 | 項目ID | 表示形式 | 説明 |
|----|--------|--------|----------|------|
| 1 | 説明 | description | HtmlEntry | ノート |

### ステータス表示

| No | 項目名 | 表示形式 | 説明 |
|----|--------|----------|------|
| 1 | 状態 | ProgressStepper | 処理の状態（Draft/Confirmed/Assigned/Done/Canceled） |

## イベント仕様

### 1-削除アクション（DeleteAction）

ドロップシップを削除します。状態がDONEの場合は非表示になります。

**処理フロー**：
1. 削除確認ダイアログを表示
2. 関連するMovesを削除
3. Dropshipを削除
4. 成功通知を表示
5. 一覧画面へリダイレクト

**例外処理**：
- QueryException発生時：エラー通知を表示し、削除を中止

### 2-印刷アクション

各種帳票を印刷します。

**処理フロー**：
1. 印刷対象の帳票を選択
2. PDF生成処理を実行
3. ダウンロードまたはプレビューを表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | inventories_operations | DELETE | ドロップシップを削除 |
| 削除アクション | inventories_moves | DELETE | 関連する移動レコードを削除 |

## メッセージ仕様

| No | 種別 | タイミング | メッセージ内容 | 備考 |
|----|------|----------|---------------|------|
| 1 | 成功 | 削除成功時 | ドロップシップが正常に削除されました | 通知で表示 |
| 2 | エラー | 削除エラー時 | ドロップシップを削除できませんでした | 関連データ存在時 |

## 例外処理

| No | 例外条件 | 処理内容 | 表示メッセージ |
|----|----------|----------|---------------|
| 1 | 削除時のQueryException | 削除処理を中止 | ドロップシップを削除できませんでした |
| 2 | 権限不足 | アクセス拒否 | この操作を行う権限がありません |
| 3 | 完了済みドロップシップの削除試行 | 削除ボタン非表示 | - |

## 備考

- HasRecordNavigationTabsトレイトを使用してサブナビゲーションを実装
- HasRepeatableEntryColumnManagerを使用して列表示を管理
- 閲覧専用画面のため、入力フィールドは表示されない
- infolistメソッドでOperationResourceから共有される表示定義を使用
- 状態がDONEの場合、削除ボタンは非表示になる
- ChatterActionでコメント機能が利用可能
- 出庫詳細画面と同様の構成だが、ドロップシップ専用のモデル（Dropship）を使用
