# 画面設計書 181-物流設定

## 概要

本ドキュメントは、Aureus ERPシステムの在庫モジュールにおける「物流設定」画面の設計書です。

### 本画面の処理概要

この画面では、在庫管理システムの物流関連設定を行うことができます。

**業務上の目的・背景**：企業の物流戦略に応じた配送オプションを設定するための画面です。特にドロップシッピング（直送）機能の有効化・無効化を制御することで、倉庫を経由せずに仕入先から顧客へ直接商品を配送するビジネスモデルに対応できます。これにより在庫コストの削減や配送効率の向上を実現します。

**画面へのアクセス方法**：メインナビゲーションから「設定」クラスターを選択し、「Inventory」グループ内の「Logistics」を選択することでアクセスできます。URLは `/admin/settings/inventory/manage-logistics` です。

**主要な操作・処理内容**：
1. ドロップシッピング機能の有効化トグルを切り替える
2. 設定を保存して物流オペレーションタイプに反映する

**画面遷移**：設定クラスターの一部として、他の在庫設定画面（オペレーション設定、トレーサビリティ設定、商品設定、倉庫設定）と同じ階層に存在します。保存後は同一画面に留まります。

**権限による表示制御**：`HasPageShield`トレイトにより、Filament Shieldの権限管理に基づいてアクセス制御されます。適切な権限を持つユーザーのみがこの設定画面にアクセスできます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-LOGISTICS-001 | ドロップシッピング設定 | 主機能 | ドロップシッピング機能の有効化・無効化 |
| FN-INV-LOGISTICS-002 | オペレーションタイプ連動 | 補助機能 | 設定保存時にドロップシップオペレーションタイプの論理削除・復元 |

## 画面種別

設定

## URL/ルーティング

- URL: `/admin/settings/inventory/manage-logistics`
- Slug: `inventory/manage-logistics`
- ナビゲーショングループ: Inventory
- ナビゲーションソート: 5

## 画面構成

- ページタイトル（パンくずリスト含む）
- 設定フォーム
  - ドロップシッピング有効化トグル

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 初期値 | 説明 |
|--------|--------|-----|----------|------|--------|------|
| ドロップシッピングを有効にする | enable_dropshipping | boolean | 入力 | - | false | ドロップシッピング機能の有効化フラグ |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「Logistics」（多言語対応） |
| パンくずリスト | 現在のページ位置を示す |
| ヘルパーテキスト | ドロップシッピング機能の説明 |

## イベント仕様

### 1-設定保存

フォームの保存ボタン押下時に、設定値をデータベースに保存し、関連するオペレーションタイプの状態を更新します。

**処理フロー**：
1. フォームデータのバリデーション
2. `LogisticSettings`への設定値保存
3. `afterSave`フックにて、ドロップシップタイプのオペレーションタイプを論理削除または復元

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定保存 | settings | UPDATE | 物流設定の保存 |
| 設定保存 | operation_types | UPDATE | ドロップシップオペレーションタイプの論理削除状態を更新 |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | enable_dropshipping | トグルの状態（true/false） | Spatie Laravel Settingsパッケージで管理 |

#### operation_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | deleted_at | enable_dropshipping=trueの場合null、falseの場合now() | 論理削除フラグ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | 設定が保存されました | 設定保存成功時 |

## 例外処理

| 例外 | 対応 |
|------|------|
| 権限不足 | 403エラーページへリダイレクト |
| データベースエラー | エラー通知を表示し、設定は保存されない |

## 備考

- この画面はFilamentの`SettingsPage`を継承しており、Spatie Laravel Settingsパッケージを使用して設定値を永続化しています。
- `HasPageShield`トレイトにより、Filament Shieldとの統合でロールベースのアクセス制御が適用されています。
- ドロップシッピングを無効にすると、既存のドロップシップオペレーションタイプは論理削除されますが、データは保持されます。
