# 画面設計書 182-オペレーション設定

## 概要

本ドキュメントは、Aureus ERPシステムの在庫モジュールにおける「オペレーション設定」画面の設計書です。

### 本画面の処理概要

この画面では、在庫オペレーションに関する各種設定を行うことができます。

**業務上の目的・背景**：在庫管理業務における日常オペレーションの効率化と標準化を図るための設定画面です。パッケージ管理機能の有効化により複数商品の一括管理が可能になり、年次棚卸日の設定により定期的な在庫確認業務のスケジューリングが可能になります。これにより在庫精度の向上と業務効率化を実現します。

**画面へのアクセス方法**：メインナビゲーションから「設定」クラスターを選択し、「Inventory」グループ内の「Operations」を選択することでアクセスできます。URLは `/admin/settings/inventory/manage-operations` です。

**主要な操作・処理内容**：
1. パッケージ機能の有効化トグルを切り替える
2. 年次棚卸日（日付）を設定する
3. 年次棚卸月を選択する
4. 設定を保存する

**画面遷移**：設定クラスターの一部として、他の在庫設定画面と同じ階層に存在します。パッケージ機能有効時は、パッケージ管理画面へのリンクが表示されます。

**権限による表示制御**：`HasPageShield`トレイトにより、Filament Shieldの権限管理に基づいてアクセス制御されます。適切な権限を持つユーザーのみがこの設定画面にアクセスできます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-OPS-001 | パッケージ機能設定 | 主機能 | パッケージ機能の有効化・無効化 |
| FN-INV-OPS-002 | 年次棚卸設定 | 主機能 | 年次棚卸日・月の設定 |
| SCR-INV-010 | パッケージ一覧 | 遷移先機能 | パッケージ管理画面へのリンク |

## 画面種別

設定

## URL/ルーティング

- URL: `/admin/settings/inventory/manage-operations`
- Slug: `inventory/manage-operations`
- ナビゲーショングループ: Inventory
- ナビゲーションソート: 1

## 画面構成

- ページタイトル（パンくずリスト含む）
- 設定フォーム
  - パッケージ有効化トグル（リンク付きヘルパーテキスト）
  - 年次棚卸日入力フィールド
  - 年次棚卸月選択フィールド

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 初期値 | 説明 |
|--------|--------|-----|----------|------|--------|------|
| パッケージを有効にする | enable_packages | boolean | 入力 | - | false | パッケージ機能の有効化フラグ |
| 年次棚卸日 | annual_inventory_day | integer | 入力 | ○ | - | 年次棚卸の日（1-31） |
| 年次棚卸月 | annual_inventory_month | integer | 入力 | ○ | - | 年次棚卸の月（1-12） |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「Operations」（多言語対応） |
| パンくずリスト | 現在のページ位置を示す |
| パッケージ設定リンク | パッケージ管理画面へのリンク |
| ヘルパーテキスト | 各設定項目の説明 |
| 月選択オプション | 1月〜12月の選択肢（多言語対応） |

## イベント仕様

### 1-設定保存

フォームの保存ボタン押下時に、設定値をデータベースに保存します。

**処理フロー**：
1. 入力値のバリデーション（日付: 1-31、月: 1-12）
2. `OperationSettings`への設定値保存
3. 保存成功通知の表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定保存 | settings | UPDATE | オペレーション設定の保存 |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | enable_packages | トグルの状態（true/false） | Spatie Laravel Settingsパッケージで管理 |
| UPDATE | annual_inventory_day | 入力値（1-31） | 整数値 |
| UPDATE | annual_inventory_month | 選択値（1-12） | 整数値 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | 設定が保存されました | 設定保存成功時 |
| MSG-002 | エラー | 入力値が無効です | バリデーションエラー時 |

## 例外処理

| 例外 | 対応 |
|------|------|
| 権限不足 | 403エラーページへリダイレクト |
| バリデーションエラー | エラーメッセージを表示し、設定は保存されない |

## 備考

- この画面はFilamentの`SettingsPage`を継承しており、Spatie Laravel Settingsパッケージを使用して設定値を永続化しています。
- パッケージ機能のヘルパーテキストにはパッケージ管理画面へのリンクが含まれています。
- 年次棚卸日は1から31までの値のみ入力可能です（月によっては存在しない日付も入力可能なため、実際の棚卸日は別途計算が必要な場合があります）。
