# 画面設計書 183-トレーサビリティ設定

## 概要

本ドキュメントは、Aureus ERPシステムの在庫モジュールにおける「トレーサビリティ設定」画面の設計書です。

### 本画面の処理概要

この画面では、在庫管理におけるトレーサビリティ（追跡可能性）に関する設定を行うことができます。

**業務上の目的・背景**：製品の品質管理、リコール対応、法規制遵守のためにロット番号やシリアル番号による追跡機能を設定する画面です。食品業界、製薬業界、電子機器業界など、製品の出所や流通経路の追跡が必要な業種において重要な機能です。これにより製品の安全性確保と品質問題発生時の迅速な対応が可能になります。

**画面へのアクセス方法**：メインナビゲーションから「設定」クラスターを選択し、「Inventory」グループ内の「Traceability」を選択することでアクセスできます。URLは `/admin/settings/inventory/manage-traceability` です。

**主要な操作・処理内容**：
1. ロット/シリアル番号機能の有効化トグルを切り替える
2. 配送伝票への表示オプションを設定する（ロット/シリアル番号が有効な場合のみ）
3. 設定を保存する

**画面遷移**：設定クラスターの一部として、他の在庫設定画面と同じ階層に存在します。ロット機能有効時は、ロット管理画面へのリンクが表示されます。

**権限による表示制御**：`HasPageShield`トレイトにより、Filament Shieldの権限管理に基づいてアクセス制御されます。適切な権限を持つユーザーのみがこの設定画面にアクセスできます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-TRACE-001 | ロット/シリアル番号設定 | 主機能 | ロット/シリアル番号機能の有効化・無効化 |
| FN-INV-TRACE-002 | 配送伝票表示設定 | 主機能 | 配送伝票へのロット/シリアル番号表示設定 |
| SCR-INV-011 | ロット一覧 | 遷移先機能 | ロット管理画面へのリンク |

## 画面種別

設定

## URL/ルーティング

- URL: `/admin/settings/inventory/manage-traceability`
- Slug: `inventory/manage-traceability`
- ナビゲーショングループ: Inventory
- ナビゲーションソート: 4

## 画面構成

- ページタイトル（パンくずリスト含む）
- 設定フォーム
  - ロット/シリアル番号有効化トグル（リンク付きヘルパーテキスト）
  - 配送伝票表示トグル（条件付き表示）

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 初期値 | 説明 |
|--------|--------|-----|----------|------|--------|------|
| ロット/シリアル番号を有効にする | enable_lots_serial_numbers | boolean | 入力 | - | false | ロット/シリアル番号機能の有効化フラグ |
| 配送伝票に表示する | display_on_delivery_slips | boolean | 入力 | - | false | 配送伝票へのロット/シリアル番号表示フラグ |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「Traceability」（多言語対応） |
| パンくずリスト | 現在のページ位置を示す |
| ロット設定リンク | ロット管理画面へのリンク |
| ヘルパーテキスト | 各設定項目の説明 |

## イベント仕様

### 1-設定保存

フォームの保存ボタン押下時に、設定値をデータベースに保存します。ただし、既にロット/シリアル追跡が設定された商品が存在する場合は保存がブロックされます。

**処理フロー**：
1. `beforeSave`フックにて既存商品のトラッキング設定チェック
2. ロット/シリアル追跡設定済み商品が存在する場合、警告通知を表示して保存を中止
3. 問題がなければ`TraceabilitySettings`への設定値保存
4. 保存成功通知の表示

### 2-ロット/シリアル番号トグル変更

ロット/シリアル番号有効化トグルの状態変更時に、配送伝票表示オプションの表示/非表示を切り替えます。

**処理フロー**：
1. トグルの状態をリアルタイムで監視
2. 有効の場合：配送伝票表示オプションを表示
3. 無効の場合：配送伝票表示オプションを非表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定保存 | settings | UPDATE | トレーサビリティ設定の保存 |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | enable_lots_serial_numbers | トグルの状態（true/false） | Spatie Laravel Settingsパッケージで管理 |
| UPDATE | display_on_delivery_slips | トグルの状態（true/false） | Spatie Laravel Settingsパッケージで管理 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | 設定が保存されました | 設定保存成功時 |
| MSG-002 | 警告 | 既にロット/シリアル追跡が設定された商品があります | 設定変更不可時 |

## 例外処理

| 例外 | 対応 |
|------|------|
| 権限不足 | 403エラーページへリダイレクト |
| 既存データ競合 | 警告通知を表示し、フォームをリセットして保存を中止 |

## 備考

- この画面はFilamentの`SettingsPage`を継承しており、Spatie Laravel Settingsパッケージを使用して設定値を永続化しています。
- ロット/シリアル番号機能を無効化しようとする際、既に`SERIAL`または`LOT`トラッキングが設定された商品が存在する場合は設定変更がブロックされます。
- 配送伝票表示オプションは、ロット/シリアル番号機能が有効な場合のみ表示される条件付きフィールドです。
- ヘルパーテキストにはロット管理画面へのリンクが含まれています。
