# 画面設計書 184-商品設定

## 概要

本ドキュメントは、Aureus ERPシステムの在庫モジュールにおける「商品設定」画面の設計書です。

### 本画面の処理概要

この画面では、在庫管理における商品に関する各種設定を行うことができます。

**業務上の目的・背景**：商品管理の柔軟性と効率性を高めるための設定画面です。バリエーション機能により色やサイズなどの属性を持つ商品の管理が可能になり、単位（UOM）機能により異なる計量単位での在庫管理が可能になります。パッケージング機能により販売単位とは異なる梱包単位での管理も実現します。

**画面へのアクセス方法**：メインナビゲーションから「設定」クラスターを選択し、「Inventory」グループ内の「Products」を選択することでアクセスできます。URLは `/admin/settings/inventory/manage-products` です。

**主要な操作・処理内容**：
1. バリエーション機能の有効化トグルを切り替える
2. 単位（UOM）機能の有効化トグルを切り替える
3. パッケージング機能の有効化トグルを切り替える
4. 設定を保存する

**画面遷移**：設定クラスターの一部として、他の在庫設定画面と同じ階層に存在します。パッケージング機能有効時は、パッケージング管理画面へのリンクが表示されます。

**権限による表示制御**：`HasPageShield`トレイトにより、Filament Shieldの権限管理に基づいてアクセス制御されます。適切な権限を持つユーザーのみがこの設定画面にアクセスできます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-PROD-001 | バリエーション設定 | 主機能 | 商品バリエーション機能の有効化・無効化 |
| FN-INV-PROD-002 | 単位（UOM）設定 | 主機能 | 単位機能の有効化・無効化 |
| FN-INV-PROD-003 | パッケージング設定 | 主機能 | パッケージング機能の有効化・無効化 |
| SCR-INV-133 | パッケージング管理 | 遷移先機能 | パッケージング管理画面へのリンク |

## 画面種別

設定

## URL/ルーティング

- URL: `/admin/settings/inventory/manage-products`
- Slug: `inventory/manage-products`
- ナビゲーショングループ: Inventory
- ナビゲーションソート: 2

## 画面構成

- ページタイトル（パンくずリスト含む）
- 設定フォーム
  - バリエーション有効化トグル
  - 単位（UOM）有効化トグル
  - パッケージング有効化トグル（リンク付きヘルパーテキスト）

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 初期値 | 説明 |
|--------|--------|-----|----------|------|--------|------|
| バリエーションを有効にする | enable_variants | boolean | 入力 | - | false | 商品バリエーション機能の有効化フラグ |
| 単位（UOM）を有効にする | enable_uom | boolean | 入力 | - | false | 単位機能の有効化フラグ |
| パッケージングを有効にする | enable_packagings | boolean | 入力 | - | false | パッケージング機能の有効化フラグ |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「Products」（多言語対応） |
| パンくずリスト | 現在のページ位置を示す |
| パッケージング設定リンク | パッケージング管理画面へのリンク |
| ヘルパーテキスト | 各設定項目の説明 |

## イベント仕様

### 1-設定保存

フォームの保存ボタン押下時に、設定値をデータベースに保存します。

**処理フロー**：
1. フォームデータのバリデーション
2. `ProductSettings`への設定値保存
3. 保存成功通知の表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定保存 | settings | UPDATE | 商品設定の保存 |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | enable_variants | トグルの状態（true/false） | Spatie Laravel Settingsパッケージで管理 |
| UPDATE | enable_uom | トグルの状態（true/false） | Spatie Laravel Settingsパッケージで管理 |
| UPDATE | enable_packagings | トグルの状態（true/false） | Spatie Laravel Settingsパッケージで管理 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | 設定が保存されました | 設定保存成功時 |

## 例外処理

| 例外 | 対応 |
|------|------|
| 権限不足 | 403エラーページへリダイレクト |
| データベースエラー | エラー通知を表示し、設定は保存されない |

## 備考

- この画面はFilamentの`SettingsPage`を継承しており、Spatie Laravel Settingsパッケージを使用して設定値を永続化しています。
- バリエーション機能を有効にすると、商品に対して色やサイズなどの属性を設定し、バリアント商品を作成できるようになります。
- UOM（Unit of Measure）機能を有効にすると、同じ商品を異なる計量単位（個、ダース、箱など）で管理できるようになります。
- パッケージング機能を有効にすると、商品の梱包単位を定義し、販売単位とは異なる単位での在庫管理が可能になります。
- パッケージング機能のヘルパーテキストにはパッケージング管理画面へのリンクが含まれています。
