# 画面設計書 185-倉庫設定

## 概要

本ドキュメントは、Aureus ERPシステムの在庫モジュールにおける「倉庫設定」画面の設計書です。

### 本画面の処理概要

この画面では、倉庫管理に関する各種設定を行うことができます。

**業務上の目的・背景**：複雑な倉庫運用と物流フローを効率的に管理するための設定画面です。ロケーション機能により倉庫内の棚やエリアを細かく管理でき、マルチステップルート機能により入庫→保管→出庫などの複数段階の在庫移動フローを定義できます。これにより大規模倉庫や複数拠点運用に対応した柔軟な在庫管理が可能になります。

**画面へのアクセス方法**：メインナビゲーションから「設定」クラスターを選択し、「Inventory」グループ内の「Warehouses」を選択することでアクセスできます。URLは `/admin/settings/inventory/manage-warehouses` です。

**主要な操作・処理内容**：
1. ロケーション機能の有効化トグルを切り替える
2. マルチステップルート機能の有効化トグルを切り替える
3. 設定を保存する

**画面遷移**：設定クラスターの一部として、他の在庫設定画面と同じ階層に存在します。ロケーション機能有効時はロケーション管理画面へ、マルチステップルート機能有効時は倉庫管理画面へのリンクが表示されます。

**権限による表示制御**：`HasPageShield`トレイトにより、Filament Shieldの権限管理に基づいてアクセス制御されます。適切な権限を持つユーザーのみがこの設定画面にアクセスできます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-WH-001 | ロケーション設定 | 主機能 | ロケーション機能の有効化・無効化 |
| FN-INV-WH-002 | マルチステップルート設定 | 主機能 | マルチステップルート機能の有効化・無効化 |
| FN-INV-WH-003 | オペレーションタイプ連動 | 補助機能 | 設定保存時に内部移動オペレーションタイプの論理削除・復元 |
| SCR-INV-129 | ロケーション一覧 | 遷移先機能 | ロケーション管理画面へのリンク |
| SCR-INV-107 | 倉庫一覧 | 遷移先機能 | 倉庫管理画面へのリンク |

## 画面種別

設定

## URL/ルーティング

- URL: `/admin/settings/inventory/manage-warehouses`
- Slug: `inventory/manage-warehouses`
- ナビゲーショングループ: Inventory
- ナビゲーションソート: 3

## 画面構成

- ページタイトル（パンくずリスト含む）
- 設定フォーム
  - ロケーション有効化トグル（リンク付きヘルパーテキスト）
  - マルチステップルート有効化トグル（リンク付きヘルパーテキスト）

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 初期値 | 説明 |
|--------|--------|-----|----------|------|--------|------|
| ロケーションを有効にする | enable_locations | boolean | 入力 | - | false | ロケーション機能の有効化フラグ |
| マルチステップルートを有効にする | enable_multi_steps_routes | boolean | 入力 | - | false | マルチステップルート機能の有効化フラグ |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「Warehouses」（多言語対応） |
| パンくずリスト | 現在のページ位置を示す |
| ロケーション設定リンク | ロケーション管理画面へのリンク |
| ルート設定リンク | 倉庫管理画面へのリンク |
| ヘルパーテキスト | 各設定項目の説明 |

## イベント仕様

### 1-ロケーショントグル変更

ロケーション有効化トグルの状態変更時に、マルチステップルートの状態を連動して更新します。

**処理フロー**：
1. トグルの状態をリアルタイムで監視
2. ロケーションを無効にした場合：マルチステップルートも自動的に無効に設定

### 2-マルチステップルートトグル変更

マルチステップルート有効化トグルの状態変更時に、ロケーションの状態を連動して更新します。

**処理フロー**：
1. トグルの状態をリアルタイムで監視
2. マルチステップルートを有効にした場合：ロケーションも自動的に有効に設定

### 3-設定保存

フォームの保存ボタン押下時に、設定値をデータベースに保存します。ただし、複数の倉庫が存在する場合は保存がブロックされます。

**処理フロー**：
1. `beforeSave`フックにて倉庫数のチェック
2. 倉庫が2つ以上存在する場合、警告通知を表示して保存を中止
3. 問題がなければ`WarehouseSettings`への設定値保存
4. `afterSave`フックにて、各倉庫の内部移動オペレーションタイプを論理削除または復元
5. 保存成功通知の表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定保存 | settings | UPDATE | 倉庫設定の保存 |
| 設定保存 | operation_types | UPDATE | 内部移動オペレーションタイプの論理削除状態を更新 |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | enable_locations | トグルの状態（true/false） | Spatie Laravel Settingsパッケージで管理 |
| UPDATE | enable_multi_steps_routes | トグルの状態（true/false） | Spatie Laravel Settingsパッケージで管理 |

#### operation_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | deleted_at | enable_locations=trueの場合null、falseの場合now() | 各倉庫の内部移動タイプに対して |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | 設定が保存されました | 設定保存成功時 |
| MSG-002 | 警告 | 複数の倉庫が存在するため設定を変更できません | 設定変更不可時 |

## 例外処理

| 例外 | 対応 |
|------|------|
| 権限不足 | 403エラーページへリダイレクト |
| 複数倉庫存在 | 警告通知を表示し、フォームをリセットして保存を中止 |

## 備考

- この画面はFilamentの`SettingsPage`を継承しており、Spatie Laravel Settingsパッケージを使用して設定値を永続化しています。
- ロケーション機能とマルチステップルート機能は相互に依存関係があり、マルチステップルートを有効にするとロケーションも自動的に有効になり、ロケーションを無効にするとマルチステップルートも自動的に無効になります。
- 複数の倉庫が存在する場合、この設定画面での変更はブロックされます。これはデータの整合性を保つための安全策です。
- ロケーション機能を有効/無効にすると、各倉庫の内部移動オペレーションタイプの論理削除状態が自動的に更新されます。
