# 画面設計書 186-仕入先請求書一覧

## 概要

本ドキュメントは、Aureus ERPシステムの請求書モジュールにおける「仕入先請求書一覧」画面の設計書です。

### 本画面の処理概要

この画面では、仕入先（ベンダー）から受け取った請求書の一覧表示と管理を行うことができます。

**業務上の目的・背景**：仕入先からの請求書を一元管理し、支払い業務を効率化するための画面です。発注に対する請求書の照合、支払期日の管理、支払状況の追跡など、買掛金管理の中核となる機能を提供します。これにより支払い遅延の防止やキャッシュフロー管理の最適化を実現します。

**画面へのアクセス方法**：メインナビゲーションから「Invoices」モジュールを選択し、「Vendors」クラスター内の「Bills」を選択することでアクセスできます。

**主要な操作・処理内容**：
1. 仕入先請求書の一覧を表示する
2. 検索・フィルタ・ソート機能で目的の請求書を絞り込む
3. プリセットビュー（タブ）で請求書の状態別に表示を切り替える
4. 新規請求書を作成する
5. 請求書の詳細画面へ遷移する

**画面遷移**：一覧画面から作成画面、詳細画面、編集画面へ遷移できます。詳細画面からは編集画面へ遷移可能です。

**権限による表示制御**：Filament Shieldの権限管理に基づいてアクセス制御されます。適切な権限を持つユーザーのみが閲覧・操作できます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-VE-001 | 仕入請求書一覧 | 主機能 | 仕入請求書の一覧表示、検索、フィルタ |
| FN-INV-VE-002 | 仕入請求書作成 | 遷移先機能 | 新規請求書作成画面への遷移 |
| FN-INV-VE-003 | 仕入請求書詳細 | 遷移先機能 | 請求書詳細画面への遷移 |

## 画面種別

一覧

## URL/ルーティング

- URL: `/admin/invoices/vendors/bills`
- ナビゲーションアイコン: heroicon-o-credit-card
- ナビゲーションソート: 1

## 画面構成

- ページヘッダー
  - タイトル
  - 新規作成ボタン
- プリセットビュータブ
  - 仕入先請求書（デフォルト）
  - その他継承されたビュー
- データテーブル
  - ソート可能なカラム
  - フィルタ機能
  - 検索機能
  - ページネーション

## 入出力項目

なし（一覧画面のため、入力項目はフィルタ・検索のみ）

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 請求書番号 | 請求書の一意識別子 |
| 仕入先名 | 請求書の発行元仕入先 |
| 請求日 | 請求書の発行日 |
| 支払期日 | 支払期限日 |
| 金額 | 請求金額 |
| 支払状態 | 支払済み/未払い/一部支払済みなど |
| 状態 | ドラフト/確認済み/キャンセルなど |

## イベント仕様

### 1-新規作成ボタン押下

新規作成ボタン押下時に、仕入先請求書作成画面へ遷移します。

**処理フロー**：
1. 作成画面URLへリダイレクト

### 2-行クリック

テーブル行クリック時に、該当請求書の詳細画面へ遷移します。

**処理フロー**：
1. 選択されたレコードのIDを取得
2. 詳細画面URLへリダイレクト

### 3-プリセットビュー切り替え

プリセットビュータブ切り替え時に、表示データをフィルタリングします。

**処理フロー**：
1. 選択されたビューのクエリ条件を適用
2. 「仕入先請求書」ビューでは `move_type = IN_INVOICE` でフィルタ

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | account_moves | SELECT | 仕入先請求書データの取得 |

### テーブル別更新項目詳細

この画面ではデータの更新は行いません。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 情報 | データがありません | 検索結果が0件の場合 |

## 例外処理

| 例外 | 対応 |
|------|------|
| 権限不足 | 403エラーページへリダイレクト |
| データ取得エラー | エラー通知を表示 |

## 備考

- この画面は`Webkul\Account\Filament\Resources\BillResource\Pages\ListBills`を継承しており、会計モジュールの請求書一覧機能を再利用しています。
- `HasTableViews`トレイトによりプリセットビュー機能が提供されています。
- 「仕入先請求書」ビューがデフォルトで選択され、お気に入りとして設定されています。
- フィルタ条件として`move_type = IN_INVOICE`が適用され、仕入先請求書のみが表示されます。
