# 画面設計書 187-仕入先請求書作成

## 概要

本ドキュメントは、Aureus ERPシステムの請求書モジュールにおける「仕入先請求書作成」画面の設計書です。

### 本画面の処理概要

この画面では、仕入先（ベンダー）からの新規請求書を登録することができます。

**業務上の目的・背景**：仕入先から受け取った請求書をシステムに登録し、支払い管理を開始するための画面です。発注に対する請求書の紐付け、請求明細の入力、税金計算などを行い、買掛金として計上します。これにより正確な財務データの記録と支払い計画の策定が可能になります。

**画面へのアクセス方法**：仕入先請求書一覧画面の「新規作成」ボタンから遷移します。または直接URLでアクセスすることも可能です。

**主要な操作・処理内容**：
1. 仕入先を選択する
2. 請求日・支払期日を入力する
3. 請求明細（商品、数量、単価、税）を入力する
4. 支払条件やその他情報を入力する
5. 請求書を保存する

**画面遷移**：作成完了後は詳細画面へ自動遷移します。キャンセル時は一覧画面へ戻ります。

**権限による表示制御**：Filament Shieldの権限管理に基づいてアクセス制御されます。作成権限を持つユーザーのみが操作できます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-006 | 仕入請求書作成 | 主機能 | 新規仕入請求書の作成 |
| FN-ACC-005 | 仕入請求書一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-ACC-008 | 仕入請求書表示 | 遷移先機能 | 作成後の詳細画面への遷移 |

## 画面種別

登録

## URL/ルーティング

- URL: `/admin/invoices/vendors/bills/create`

## 画面構成

- ページヘッダー
  - タイトル
  - サブナビゲーション
- ステータスステッパー（Draft状態）
- メインフォーム
  - 基本情報セクション
    - 仕入先選択
    - 請求日
    - 請求書参照
    - 会計日
    - 支払参照
    - 受取銀行口座
    - 支払期日/支払条件
  - タブ
    - 請求明細タブ（商品リピーター + サマリー）
    - その他情報タブ
    - 利用規約タブ

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 初期値 | 説明 |
|--------|--------|-----|----------|------|--------|------|
| 仕入先 | partner_id | integer | 入力 | - | - | 仕入先パートナーの選択 |
| 請求日 | invoice_date | date | 入力 | - | 今日 | 請求書の日付 |
| 請求書参照 | reference | string | 入力 | - | - | 仕入先の請求書番号 |
| 会計日 | date | date | 入力 | - | 今日 | 会計処理日 |
| 支払参照 | payment_reference | string | 入力 | - | - | 支払時の参照番号 |
| 受取銀行口座 | partner_bank_id | integer | 入力 | - | - | 支払先銀行口座 |
| 支払期日 | invoice_date_due | date | 入力 | 条件付き | 今日 | 支払条件未設定時に必須 |
| 支払条件 | invoice_payment_term_id | integer | 入力 | 条件付き | - | 支払期日未設定時に必須 |
| 商品ID | products.*.product_id | integer | 入力 | ○ | - | 請求対象商品 |
| 数量 | products.*.quantity | decimal | 入力 | ○ | 1 | 数量 |
| 単位 | products.*.uom_id | integer | 入力 | ○ | - | 計量単位 |
| 税 | products.*.taxes | array | 入力 | - | - | 適用税 |
| 割引 | products.*.discount | decimal | 入力 | - | 0 | 割引率（%） |
| 単価 | products.*.price_unit | decimal | 入力 | ○ | 0 | 単位あたり価格 |
| インコタームズ | invoice_incoterm_id | integer | 入力 | - | - | 国際貿易条件 |
| インコタームズ場所 | incoterm_location | string | 入力 | - | - | 引渡場所 |
| 支払方法 | preferred_payment_method_line_id | integer | 入力 | - | - | 優先支払方法 |
| 自動転記 | auto_post | boolean | 入力 | - | false | 自動転記フラグ |
| チェック済み | checked | boolean | 入力 | - | false | 確認済みフラグ |
| 会社 | company_id | integer | 入力 | - | ログインユーザーのデフォルト会社 | 所属会社 |
| 通貨 | currency_id | integer | 入力 | ○ | 会社のデフォルト通貨 | 請求通貨 |
| 備考 | narration | text | 入力 | - | - | 利用規約・備考 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ステータスステッパー | Draft → Posted → Cancelの状態遷移を表示 |
| 小計 | 各明細の小計金額 |
| 税額 | 計算された税額 |
| 合計 | 請求書合計金額 |
| サマリーウィジェット | 請求明細のサマリー表示（Livewire） |

## イベント仕様

### 1-仕入先選択時

仕入先選択時に、関連情報を自動設定します。

**処理フロー**：
1. 選択された仕入先のパートナー情報を取得
2. 銀行口座を自動設定（partner.bankAccounts.first）
3. 優先支払方法を自動設定（partner.propertyOutboundPaymentMethodLine）
4. 支払条件を自動設定（partner.propertySupplierPaymentTerm）

### 2-商品選択時

商品選択時に、商品情報に基づいて関連項目を自動設定します。

**処理フロー**：
1. 選択された商品の情報を取得
2. 単位を自動設定（product.uom_id）
3. 単価を自動設定（product.costまたはproduct.price）
4. 税を自動設定（product.productTaxes）
5. 小計を自動計算

### 3-数量・単価・割引・税変更時

金額関連項目の変更時に、小計・税額・合計を再計算します。

**処理フロー**：
1. 変更された値を取得
2. 小計を計算（単価 × 数量 - 割引）
3. 税額を計算（Tax::collect()）
4. 合計を計算（小計 + 税額）

### 4-保存ボタン押下

フォーム送信時に、請求書データをデータベースに保存します。

**処理フロー**：
1. フォームデータのバリデーション
2. `mutateFormDataBeforeCreate`でmove_typeをIN_INVOICEに設定、dateを現在日時に設定
3. 請求書レコードの作成
4. `afterCreate`でAccount::computeAccountMove()を実行
5. 詳細画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | account_moves | INSERT | 請求書ヘッダの作成 |
| 保存 | account_move_lines | INSERT | 請求書明細の作成 |
| 保存 | account_move_line_taxes | INSERT | 明細に紐づく税の関連 |

### テーブル別更新項目詳細

#### account_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | move_type | IN_INVOICE | 仕入請求書タイプ |
| INSERT | date | now() | 作成時の現在日時 |
| INSERT | partner_id | フォーム入力値 | 仕入先 |
| INSERT | invoice_date | フォーム入力値 | 請求日 |
| INSERT | invoice_date_due | フォーム入力値または計算値 | 支払期日 |
| INSERT | currency_id | フォーム入力値 | 通貨 |
| INSERT | company_id | フォーム入力値 | 会社 |
| INSERT | state | draft | 初期状態 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | 仕入先請求書が作成されました | 作成成功時 |
| MSG-002 | エラー | 入力内容に誤りがあります | バリデーションエラー時 |

## 例外処理

| 例外 | 対応 |
|------|------|
| 権限不足 | 403エラーページへリダイレクト |
| バリデーションエラー | エラーメッセージを表示し、フォームを維持 |
| データベースエラー | エラー通知を表示 |

## 備考

- この画面は`Webkul\Account\Filament\Resources\BillResource\Pages\CreateBill`を継承しています。
- 商品リピーターでは既に選択された商品を再度選択できないようになっています。
- 削除された商品も選択肢に表示されますが、選択不可（Deleted表示）となっています。
- UOM（単位）機能はProductSettings.enable_uomの設定に応じて表示/非表示が切り替わります。
- 税計算はTax Facade（Tax::collect）を使用して行われます。
- 保存後、Account Facade（Account::computeAccountMove）で会計仕訳が自動生成されます。
