# 画面設計書 188-仕入先請求書編集

## 概要

本ドキュメントは、Aureus ERPシステムの請求書モジュールにおける「仕入先請求書編集」画面の設計書です。

### 本画面の処理概要

この画面では、既存の仕入先請求書の内容を編集することができます。

**業務上の目的・背景**：登録済みの仕入先請求書に誤りがあった場合や、情報の更新が必要な場合に修正を行うための画面です。ただし、確認済み（Posted）やキャンセル済みの請求書は編集が制限されます。これにより会計データの整合性を保ちながら、必要な修正を適切に行うことができます。

**画面へのアクセス方法**：仕入先請求書詳細画面のサブナビゲーションから「編集」を選択するか、一覧画面から直接編集画面へ遷移できます。

**主要な操作・処理内容**：
1. 請求書の基本情報を編集する
2. 請求明細を追加・編集・削除する
3. 支払処理を実行する
4. 請求書を確認（Posted）状態に遷移する
5. 請求書をキャンセルする
6. クレジットノートを発行する
7. 変更を保存する

**画面遷移**：保存後は詳細画面へ遷移します。各種アクションボタンからは関連画面やモーダルが開きます。

**権限による表示制御**：Filament Shieldの権限管理に基づいてアクセス制御されます。編集権限を持つユーザーのみが操作できます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-007 | 仕入請求書編集 | 主機能 | 請求書内容の編集 |
| FN-ACC-008 | 仕入請求書表示 | 遷移先機能 | 保存後の詳細画面への遷移 |
| FN-ACC-009 | 支払処理 | 補助機能 | 支払アクション |
| FN-ACC-010 | 請求書確認 | 補助機能 | 確認（Posted）アクション |
| FN-ACC-011 | クレジットノート発行 | 補助機能 | クレジットノートアクション |

## 画面種別

編集

## URL/ルーティング

- URL: `/admin/invoices/vendors/bills/{record}/edit`

## 画面構成

- ページヘッダー
  - タイトル
  - サブナビゲーション（詳細/編集）
  - アクションボタン群
- ステータスステッパー
- メインフォーム（作成画面と同様）
  - 基本情報セクション
  - タブ（請求明細/その他情報/利用規約）

## 入出力項目

作成画面（187-仕入先請求書作成）と同様の項目に加え、以下の状態依存項目があります。

| 項目名 | 編集可否条件 |
|--------|-------------|
| 全フォーム項目 | Posted/Cancel状態では編集不可 |

## 表示項目

作成画面と同様

## イベント仕様

### 1-保存ボタン押下

フォーム送信時に、請求書データを更新します。

**処理フロー**：
1. フォームデータのバリデーション
2. `mutateFormDataBeforeSave`で必須項目のデフォルト値設定
3. 請求書レコードの更新
4. `afterSave`でAccount::computeAccountMove()を実行
5. 詳細画面へリダイレクト

### 2-支払アクション（Pay）

支払処理モーダルを開き、支払を登録します。

### 3-確認アクション（Confirm）

請求書をDraft状態からPosted状態に遷移させます。

### 4-キャンセルアクション（Cancel）

請求書をキャンセル状態に遷移させます。

### 5-ドラフトに戻すアクション（Reset to Draft）

Posted状態の請求書をDraft状態に戻します。

### 6-チェック済みにするアクション（Set as Checked）

請求書にチェック済みフラグを設定します。

### 7-クレジットノートアクション

クレジットノートを発行します。

### 8-削除アクション

請求書を削除します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | account_moves | UPDATE | 請求書ヘッダの更新 |
| 保存 | account_move_lines | INSERT/UPDATE/DELETE | 請求書明細の更新 |
| 確認 | account_moves | UPDATE | stateをpostedに更新 |
| キャンセル | account_moves | UPDATE | stateをcancelに更新 |
| 削除 | account_moves | DELETE | 請求書の削除 |

### テーブル別更新項目詳細

#### account_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | 各フォーム項目 | フォーム入力値 | 編集内容を保存 |
| UPDATE | state | posted/cancel/draft | 状態遷移アクション時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | 仕入先請求書が更新されました | 保存成功時 |
| MSG-002 | 成功 | 請求書が確認されました | 確認アクション成功時 |
| MSG-003 | 成功 | 請求書がキャンセルされました | キャンセルアクション成功時 |
| MSG-004 | エラー | 入力内容に誤りがあります | バリデーションエラー時 |

## 例外処理

| 例外 | 対応 |
|------|------|
| 権限不足 | 403エラーページへリダイレクト |
| バリデーションエラー | エラーメッセージを表示し、フォームを維持 |
| 状態遷移エラー | エラー通知を表示 |

## 備考

- この画面は`Webkul\Account\Filament\Resources\BillResource\Pages\EditBill`を継承しています。
- `HasRecordNavigationTabs`トレイトによりレコード間のナビゲーションが提供されます。
- `HasRepeaterColumnManager`トレイトにより商品リピーターのカラム管理が提供されます。
- Posted状態またはCancel状態の請求書は、ほとんどのフォーム項目が編集不可（disabled）になります。
- Chatterアクションにより、請求書に対するコメントやアクティビティの記録が可能です。
- 各アクションボタンは請求書の状態に応じて表示/非表示が制御されます。
