# 画面設計書 189-仕入先請求書詳細

## 概要

本ドキュメントは、Aureus ERPシステムの請求書モジュールにおける「仕入先請求書詳細」画面の設計書です。

### 本画面の処理概要

この画面では、登録済みの仕入先請求書の詳細情報を閲覧することができます。

**業務上の目的・背景**：仕入先請求書の内容を確認し、支払処理や状態遷移などのアクションを実行するための画面です。請求書のヘッダ情報、明細情報、関連する会計情報などを一覧でき、請求書の確認・承認プロセスを支援します。

**画面へのアクセス方法**：仕入先請求書一覧画面から任意の請求書行をクリックするか、作成・編集後に自動遷移します。

**主要な操作・処理内容**：
1. 請求書の詳細情報を閲覧する
2. 支払処理を実行する
3. 請求書を確認（Posted）状態に遷移する
4. 請求書をキャンセルする
5. クレジットノートを発行する
6. 編集画面へ遷移する
7. 請求書を削除する

**画面遷移**：サブナビゲーションから編集画面へ遷移できます。各種アクションボタンからは関連画面やモーダルが開きます。

**権限による表示制御**：Filament Shieldの権限管理に基づいてアクセス制御されます。閲覧権限を持つユーザーのみがアクセスできます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-008 | 仕入請求書表示 | 主機能 | 請求書詳細の表示 |
| FN-ACC-007 | 仕入請求書編集 | 遷移先機能 | 編集画面への遷移 |
| FN-ACC-009 | 支払処理 | 補助機能 | 支払アクション |
| FN-ACC-010 | 請求書確認 | 補助機能 | 確認（Posted）アクション |
| FN-ACC-011 | クレジットノート発行 | 補助機能 | クレジットノートアクション |

## 画面種別

詳細

## URL/ルーティング

- URL: `/admin/invoices/vendors/bills/{record}`

## 画面構成

- ページヘッダー
  - タイトル
  - サブナビゲーション（詳細/編集）
  - アクションボタン群
- 支払状態バッジセクション
- 基本情報セクション
  - 請求書番号
  - 仕入先名
  - 請求日
  - 請求書参照
  - 会計日
  - 支払参照
  - 受取銀行口座
  - 支払期日
  - 支払条件
- タブ
  - 請求明細タブ（リピータブル形式 + サマリー）
  - その他情報タブ
  - 利用規約タブ

## 入出力項目

なし（詳細表示画面のため）

## 表示項目

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 支払状態バッジ | payment_state | badge | 支払状態（Paid/Reversed等） |
| 請求書番号 | name | text | 請求書の識別番号 |
| 仕入先名 | partner.name | text | 仕入先パートナー名 |
| 請求日 | invoice_date | date | 請求書発行日 |
| 請求書参照 | reference | text | 仕入先の請求書番号 |
| 会計日 | date | date | 会計処理日 |
| 支払参照 | payment_reference | text | 支払時の参照番号 |
| 受取銀行口座 | partnerBank.account_number | text | 支払先銀行口座 |
| 支払期日 | invoice_date_due | date | 支払期限日 |
| 支払条件 | invoicePaymentTerm.name | text | 適用された支払条件 |
| 商品名 | lines.*.name | text | 請求明細の商品名 |
| 数量 | lines.*.quantity | number | 数量 |
| 単位 | lines.*.uom.name | text | 計量単位 |
| 単価 | lines.*.price_unit | money | 単位あたり価格 |
| 割引 | lines.*.discount | percentage | 割引率 |
| 税 | lines.*.taxes | badges | 適用された税 |
| 小計 | lines.*.price_subtotal | money | 明細小計 |
| インコタームズ | invoiceIncoterm.name | text | 国際貿易条件 |
| インコタームズ場所 | incoterm_location | text | 引渡場所 |
| 支払方法 | paymentMethodLine.name | text | 優先支払方法 |
| 自動転記 | auto_post | boolean | 自動転記フラグ |
| 会社 | company.name | text | 所属会社 |
| 通貨 | currency.name | text | 請求通貨 |
| 備考 | narration | html | 利用規約・備考 |

## イベント仕様

### 1-支払アクション（Pay）

支払処理モーダルを開き、支払を登録します。

### 2-確認アクション（Confirm）

請求書をDraft状態からPosted状態に遷移させます。

### 3-キャンセルアクション（Cancel）

請求書をキャンセル状態に遷移させます。

### 4-ドラフトに戻すアクション（Reset to Draft）

Posted状態の請求書をDraft状態に戻します。

### 5-チェック済みにするアクション（Set as Checked）

請求書にチェック済みフラグを設定します。

### 6-クレジットノートアクション

クレジットノートを発行します。

### 7-削除アクション

請求書を削除します。削除成功時に通知が表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 詳細表示 | account_moves | SELECT | 請求書データの取得 |
| 詳細表示 | account_move_lines | SELECT | 請求書明細の取得 |
| 確認 | account_moves | UPDATE | stateをpostedに更新 |
| キャンセル | account_moves | UPDATE | stateをcancelに更新 |
| 削除 | account_moves | DELETE | 請求書の削除 |

### テーブル別更新項目詳細

アクション実行時の更新は編集画面と同様

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | 請求書が削除されました | 削除成功時 |
| MSG-002 | 成功 | 請求書が確認されました | 確認アクション成功時 |
| MSG-003 | 成功 | 請求書がキャンセルされました | キャンセルアクション成功時 |

## 例外処理

| 例外 | 対応 |
|------|------|
| 権限不足 | 403エラーページへリダイレクト |
| レコード未存在 | 404エラーページへリダイレクト |
| アクション実行エラー | エラー通知を表示 |

## 備考

- この画面は`Webkul\Account\Filament\Resources\BillResource\Pages\ViewBill`を継承しています。
- `HasRecordNavigationTabs`トレイトによりレコード間のナビゲーションが提供されます。
- `HasRepeatableEntryColumnManager`トレイトにより請求明細のカラム管理が提供されます。
- 請求明細はRepeatableEntry形式で表示され、テーブル形式でカラムの表示/非表示を切り替え可能です。
- InvoiceSummary Livewireコンポーネントにより、合計金額や税額のサマリーがリアルタイムで表示されます。
- UOM（単位）の表示はProductSettings.enable_uomの設定に応じて制御されます。
- Chatterアクションにより、請求書に対するコメントやアクティビティの確認・追加が可能です。
