# 画面設計書 19-財務ポジション一覧

## 概要

本ドキュメントは、Aureus ERPシステムにおける「財務ポジション一覧」画面の設計仕様を定義するものである。

### 本画面の処理概要

財務ポジション一覧画面は、会計モジュールにおいて財務ポジション（税務ポジション）の設定を管理するための画面である。

**業務上の目的・背景**：財務ポジションは、顧客や取引の地理的条件（国、郵便番号範囲等）に基づいて、適用される税率を自動的に変更するための設定である。例えば、EU域内取引と域外取引で異なる税率を適用したり、特定の国への輸出時に免税処理を行うなど、複雑な税務要件に対応する。国際取引を行う企業にとって必須の機能である。

**画面へのアクセス方法**：会計モジュールの設定メニューから「財務ポジション」を選択してアクセスする。ナビゲーションには直接表示されない設定画面（shouldRegisterNavigation = false）であるため、設定画面経由でのアクセスとなる。

**主要な操作・処理内容**：
1. 財務ポジション設定の一覧表示（名前、会社、国、国グループ、作成者、郵便番号範囲、自動検出でのソート・検索）
2. 新規財務ポジション設定の作成
3. 既存設定の詳細表示・編集・削除
4. 複数設定の一括削除

**画面遷移**：
- 財務ポジション作成画面へ遷移可能
- 財務ポジション詳細画面へ遷移可能
- 財務ポジション編集画面へ遷移可能

**権限による表示制御**：Filament Resourceの標準的な権限管理に従い、リソースへのアクセス権限を持つユーザーのみが画面にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-ACC-020 | 財務ポジション管理 | 主機能 | 財務ポジション設定のCRUD操作全般 |
| FN-ACC-035 | 財務ポジション管理 | 主機能 | 作成/編集/削除 |

## 画面種別

一覧

## URL/ルーティング

`/admin/accounts/fiscal-positions`

## 画面構成

1. **ヘッダーエリア**
   - ページタイトル
   - 「作成」ボタン（heroicon-o-plus-circleアイコン付き）

2. **テーブルエリア**
   - カラム：名前、会社、国、国グループ、作成者、郵便番号（開始）、郵便番号（終了）、自動検出
   - 各行アクション：表示、編集、削除
   - 検索・ソート機能

3. **バルクアクションエリア**
   - 一括削除機能

## 入出力項目

該当なし（一覧画面のため入力項目なし）

## 表示項目

| 項目名 | 物理名 | データ型 | 説明 |
|--------|--------|----------|------|
| 名前 | name | string | 財務ポジション設定の名称 |
| 会社 | company.name | string | 関連会社名 |
| 国 | country.name | string | 適用対象国 |
| 国グループ | countryGroup.name | string | 適用対象国グループ |
| 作成者 | createdBy.name | string | 設定を作成したユーザー名 |
| 郵便番号（開始） | zip_from | string | 適用郵便番号範囲（開始） |
| 郵便番号（終了） | zip_to | string | 適用郵便番号範囲（終了） |
| 自動検出 | auto_reply | boolean | 自動検出フラグ（アイコン表示） |

## イベント仕様

### 1-作成ボタン押下

ヘッダーの「作成」ボタン押下時、財務ポジション作成画面（CreateFiscalPosition）へ遷移する。

### 2-表示アクション

各行の「表示」アクション選択時、該当レコードの詳細画面（ViewFiscalPosition）へ遷移する。

### 3-編集アクション

各行の「編集」アクション選択時、該当レコードの編集画面（EditFiscalPosition）へ遷移する。

### 4-削除アクション

各行の「削除」アクション選択時、確認後にレコードを削除し、成功通知を表示する。

### 5-一括削除

バルクアクションの「削除」選択時、選択された複数レコードを一括削除し、成功通知を表示する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | accounts_fiscal_positions | DELETE | 選択レコードの削除 |
| 一括削除 | accounts_fiscal_positions | DELETE | 複数レコードの一括削除 |

### テーブル別更新項目詳細

#### accounts_fiscal_positions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = 選択ID | 物理削除 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 成功 | 削除成功通知（タイトル・本文） | 削除アクション成功時 |
| 成功 | 一括削除成功通知（タイトル・本文） | 一括削除成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| データなし | 空のテーブルを表示 |
| 権限不足 | Filament標準の権限エラー表示 |

## 備考

- ナビゲーションに直接表示されない設定画面（shouldRegisterNavigation = false）
- 自動検出（auto_reply）フィールドはIconColumn（boolean）で表示
- 各カラムはsearchable、sortableが設定されている
- 国、国グループが未設定の場合はプレースホルダー（'-'）が表示される
- Sortableトレイトが使用されており、sortフィールドでレコードの並び順を管理可能
