# 画面設計書 190-仕入先支払一覧

## 概要

本ドキュメントは、Aureus ERPシステムの請求書モジュールにおける「仕入先支払一覧」画面の設計書です。

### 本画面の処理概要

この画面では、仕入先（ベンダー）への支払情報の一覧表示と管理を行うことができます。

**業務上の目的・背景**：仕入先への支払状況を一元管理し、支払業務を効率化するための画面です。支払済み・未処理・処理中など各状態の支払を確認でき、キャッシュフロー管理や支払予定の把握に活用できます。銀行照合の状態確認や消込処理の管理も可能です。

**画面へのアクセス方法**：メインナビゲーションから「Invoices」モジュールを選択し、「Vendors」クラスター内の「Payments」を選択することでアクセスできます。

**主要な操作・処理内容**：
1. 仕入先支払の一覧を表示する
2. 検索・フィルタ・ソート機能で目的の支払を絞り込む
3. プリセットビュー（タブ）で支払の状態別に表示を切り替える
4. 新規支払を作成する
5. 支払の詳細画面へ遷移する

**画面遷移**：一覧画面から作成画面、詳細画面、編集画面へ遷移できます。

**権限による表示制御**：Filament Shieldの権限管理に基づいてアクセス制御されます。適切な権限を持つユーザーのみが閲覧・操作できます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-VE-003 | 仕入先支払一覧 | 主機能 | 仕入先支払の一覧表示、検索、フィルタ |
| FN-ACC-010 | 支払作成 | 遷移先機能 | 新規支払作成画面への遷移 |
| FN-ACC-012 | 支払表示 | 遷移先機能 | 支払詳細画面への遷移 |

## 画面種別

一覧

## URL/ルーティング

- URL: `/admin/invoices/vendors/payments`
- ナビゲーションソート: 3

## 画面構成

- ページヘッダー
  - タイトル
  - 新規作成ボタン
- プリセットビュータブ
  - 仕入先支払（デフォルト、お気に入り）
  - 顧客支払
  - ドラフト
  - 処理中
  - 送信済み
  - 未送信
  - 銀行照合なし
  - 消込済み
- データテーブル
  - ソート可能なカラム
  - フィルタ機能
  - 検索機能
  - ページネーション

## 入出力項目

なし（一覧画面のため、入力項目はフィルタ・検索のみ）

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 支払番号 | 支払の一意識別子 |
| 仕入先名 | 支払先の仕入先 |
| 支払日 | 支払実行日 |
| 金額 | 支払金額 |
| 支払方法 | 使用された支払方法 |
| 状態 | ドラフト/処理中/送信済みなど |
| 銀行照合状態 | 銀行照合の有無 |
| 消込状態 | 消込処理の有無 |

## イベント仕様

### 1-新規作成ボタン押下

新規作成ボタン押下時に、支払作成画面へ遷移します。

**処理フロー**：
1. 作成画面URLへリダイレクト

### 2-行クリック

テーブル行クリック時に、該当支払の詳細画面へ遷移します。

**処理フロー**：
1. 選択されたレコードのIDを取得
2. 詳細画面URLへリダイレクト

### 3-プリセットビュー切り替え

プリセットビュータブ切り替え時に、表示データをフィルタリングします。

**処理フロー**：
1. 選択されたビューのクエリ条件を適用
2. 「仕入先支払」ビューでは `partner_type = 'supplier'` でフィルタ
3. 「ドラフト」ビューでは `state = 'draft'` でフィルタ
4. 「処理中」ビューでは `state = 'in_process'` でフィルタ
5. 「送信済み」ビューでは `is_sent = true` でフィルタ
6. 「未送信」ビューでは `is_sent = false` でフィルタ
7. 「銀行照合なし」ビューでは `is_matched = false` でフィルタ
8. 「消込済み」ビューでは `is_reconciled = true` でフィルタ

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | account_payments | SELECT | 支払データの取得 |

### テーブル別更新項目詳細

この画面ではデータの更新は行いません。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 情報 | データがありません | 検索結果が0件の場合 |

## 例外処理

| 例外 | 対応 |
|------|------|
| 権限不足 | 403エラーページへリダイレクト |
| データ取得エラー | エラー通知を表示 |

## 備考

- この画面は`Webkul\Account\Filament\Resources\PaymentsResource\Pages\ListPayments`を継承しています。
- `HasTableViews`トレイトによりプリセットビュー機能が提供されています。
- 「仕入先支払」ビューがデフォルトで選択され、お気に入りとして設定されています。
- 親クラスから継承されたプリセットビューに加え、仕入先支払固有のビューが追加されています。
- フィルタ条件として`partner_type = 'supplier'`が適用され、仕入先への支払のみが表示されます。
- 支払状態（PaymentStatus列挙型）には、DRAFT、IN_PROCESSなどの値があります。
