# 画面設計書 191-仕入先返金一覧

## 概要

本ドキュメントは、Invoices（請求書）モジュールにおける仕入先返金一覧画面（ListRefunds）の設計仕様を記載するものです。仕入先に対する返金処理を一覧表示し、返金の管理・追跡を行う画面です。

### 本画面の処理概要

**業務上の目的・背景**：仕入先からの過払いや返品に伴う返金処理を一元管理し、財務の健全性を保つために必要な画面です。仕入先への返金状況をリアルタイムで把握し、未処理の返金を効率的に処理できます。

**画面へのアクセス方法**：メインナビゲーションから「請求書」モジュールを選択し、「仕入先」クラスター内の「返金」メニューをクリックしてアクセスします。URLは `/invoices/vendors/refunds` です。

**主要な操作・処理内容**：
1. 仕入先返金データの一覧表示と検索
2. プリセットビューによる返金データのフィルタリング（返金、下書き、転記済み、キャンセル済み等）
3. 返金レコードの詳細表示・編集・削除
4. 新規返金の作成
5. 一括削除操作

**画面遷移**：
- この画面から遷移できる画面：仕入先返金作成画面、仕入先返金編集画面、仕入先返金詳細画面
- この画面に遷移してくる画面：仕入先モジュールのメニュー、ダッシュボード

**権限による表示制御**：請求書モジュールへのアクセス権限を持つユーザーのみが表示可能です。返金の編集・削除には追加の権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-VE-002 | 返金一覧 | 主機能 | 返金データの一覧表示 |
| FN-INV-VE-001 | 仕入請求書一覧 | 関連機能 | 請求書から返金への遷移 |
| FN-ACC-013 | 返金一覧 | API連携 | 会計モジュールの返金リソース継承 |

## 画面種別

一覧

## URL/ルーティング

`/invoices/vendors/refunds`

## 画面構成

- **ヘッダーアクション**：新規作成ボタン（CreateAction）
- **プリセットビュー**：返金（デフォルト・お気に入り）、下書き、転記済み、キャンセル済み、未保護、確認待ち、支払待ち、支払中、期限超過
- **テーブル**：返金データ一覧（請求書リソースから継承されたテーブル構造）
- **フィルター**：番号、請求書元、参照、パートナー名、請求日、支払期限、作成日、更新日
- **グループ化**：名前、パートナー名、請求日、確認済み、日付、支払期限、請求元、担当者、通貨、作成日、更新日

## 入出力項目

| 項目名 | 型 | 入力/出力 | 必須 | 説明 |
|--------|-----|----------|------|------|
| move_type | enum | 出力 | - | 移動タイプ（IN_REFUND固定） |

## 表示項目

| 項目名 | 表示形式 | ソート | 検索 | 説明 |
|--------|----------|--------|------|------|
| name | テキスト | 可 | 可 | 返金番号 |
| state | バッジ | 可 | - | ステータス |
| invoice_partner_display_name | テキスト | 可 | 可 | 仕入先名 |
| invoice_date | 日付 | 可 | - | 請求日 |
| invoice_date_due | 日付 | 可 | - | 支払期限 |
| amount_untaxed_in_currency_signed | 通貨 | 可 | 可 | 税抜金額 |
| amount_tax_signed | 通貨 | 可 | 可 | 税額 |
| amount_total_in_currency_signed | 通貨 | 可 | 可 | 合計金額 |
| amount_residual_signed | 通貨 | 可 | 可 | 残高 |
| payment_state | バッジ | 可 | 可 | 支払状態 |
| checked | アイコン | 可 | - | 確認済み（デフォルト非表示） |
| date | 日付 | 可 | 可 | 会計日（デフォルト非表示） |
| invoice_origin | テキスト | 可 | 可 | 元伝票（デフォルト非表示） |
| reference | テキスト | 可 | 可 | 参照（デフォルト非表示） |
| invoiceUser.name | テキスト | 可 | 可 | 担当者（デフォルト非表示） |
| currency.name | テキスト | 可 | 可 | 通貨（デフォルト非表示） |

## イベント仕様

### 1-プリセットビュー切替

プリセットビューを切り替えると、move_typeがIN_REFUNDの返金データに対してさらにフィルタリングが適用されます。

### 2-新規作成ボタン押下

CreateActionにより新規返金作成画面に遷移します。

### 3-行アクション

- **表示**：ViewActionで詳細画面へ遷移
- **編集**：EditActionで編集画面へ遷移
- **削除**：DeleteActionで削除（確認ダイアログあり）

### 4-一括削除

DeleteBulkActionにより選択した複数の返金を一括削除します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | account_moves | DELETE | 返金レコードの削除 |
| 一括削除 | account_moves | DELETE | 複数返金レコードの削除 |

### テーブル別更新項目詳細

#### account_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = {選択レコードID} AND move_type = 'in_refund' | 仕入先返金のみ対象 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| delete.success.title | 成功 | 削除が完了しました | 削除成功時 |
| delete.success.body | 成功 | レコードが正常に削除されました | 削除成功時 |
| bulk-delete.success.title | 成功 | 一括削除が完了しました | 一括削除成功時 |
| bulk-delete.success.body | 成功 | 選択したレコードが正常に削除されました | 一括削除成功時 |

## 例外処理

| 例外条件 | 対応処理 | 表示メッセージ |
|---------|---------|--------------|
| データが見つからない | 空の一覧を表示 | - |
| 削除権限不足 | 操作を拒否 | 権限がありません |
| 関連データ存在時の削除 | 削除を拒否 | 関連するデータが存在するため削除できません |

## 備考

- 本画面はBaseListInvoicesを継承しており、請求書一覧の基本機能を継承しています
- HasTableViewsトレイトを使用してプリセットビュー機能を実装しています
- move_typeがIN_REFUNDのデータのみがデフォルトで表示されます
