# 画面設計書 192-仕入先一覧

## 概要

本ドキュメントは、Invoices（請求書）モジュールにおける仕入先一覧画面（ListVendors）の設計仕様を記載するものです。仕入先（サプライヤー）情報を一覧表示し、仕入先の管理を行う画面です。

### 本画面の処理概要

**業務上の目的・背景**：仕入先を一元管理し、購買取引・請求書処理・支払管理を効率化するために必要な画面です。仕入先の基本情報、連絡先情報、支払条件などを管理できます。

**画面へのアクセス方法**：メインナビゲーションから「請求書」モジュールを選択し、「仕入先」クラスター内の「仕入先」メニューをクリックしてアクセスします。URLは `/invoices/vendors` です。

**主要な操作・処理内容**：
1. 仕入先データのカード形式一覧表示と検索
2. 仕入先レコードの詳細表示・編集・削除
3. 新規仕入先の作成
4. ソフトデリート・復元・完全削除操作
5. 一括削除・復元・完全削除操作

**画面遷移**：
- この画面から遷移できる画面：仕入先作成画面、仕入先編集画面、仕入先詳細画面、連絡先管理画面、住所管理画面、銀行口座管理画面
- この画面に遷移してくる画面：仕入先モジュールのメニュー、ダッシュボード

**権限による表示制御**：請求書モジュールへのアクセス権限を持つユーザーのみが表示可能です。編集・削除には追加の権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-VE-004 | 仕入先一覧 | 主機能 | 仕入先データの一覧表示 |
| FN-PAR-001 | パートナー管理 | API連携 | パートナーリソースから継承 |

## 画面種別

一覧

## URL/ルーティング

`/invoices/vendors`

## 画面構成

- **ヘッダーアクション**：新規作成ボタン（CreateAction）
- **テーブル**：仕入先データをカード形式で表示（コンテンツグリッド）
- **フィルター**：アカウントタイプ、名前、メール、職位、ウェブサイト、税番号、電話、携帯、会社登録番号、参照、親会社、作成者、担当者、敬称、会社、業種
- **グループ化**：アカウントタイプ、親会社、敬称、職位、業種

## 入出力項目

| 項目名 | 型 | 入力/出力 | 必須 | 説明 |
|--------|-----|----------|------|------|
| sub_type | string | 出力 | - | サブタイプ（supplier固定でフィルタ） |

## 表示項目

| 項目名 | 表示形式 | ソート | 検索 | 説明 |
|--------|----------|--------|------|------|
| avatar | 画像 | - | - | アバター画像 |
| name | テキスト | 可 | 可 | 仕入先名 |
| parent.name | テキスト | 可 | - | 親会社名（表示時のみ） |
| job_title | テキスト | 可 | 可 | 職位 |
| email | テキスト | 可 | 可 | メールアドレス |
| phone | テキスト | 可 | 可 | 電話番号 |
| tags.name | バッジ | - | - | タグ（複数） |

## フォーム項目（継承元から拡張）

| 項目名 | 型 | 必須 | バリデーション | 説明 |
|--------|-----|------|---------------|------|
| account_type | radio | 是 | - | アカウントタイプ（個人/法人） |
| name | text | 是 | max:255 | 仕入先名 |
| parent_id | select | - | - | 親会社 |
| avatar | file | - | image | アバター画像 |
| tax_id | text | - | max:255 | 税番号 |
| job_title | text | - | max:255 | 職位 |
| phone | text | - | tel, max:255 | 電話番号 |
| mobile | text | - | tel, max:255 | 携帯番号 |
| email | text | - | email, max:255, unique | メールアドレス |
| website | text | - | url, max:255 | ウェブサイト |
| title_id | select | - | - | 敬称 |
| tags | select | - | multiple | タグ |
| street1 | text | - | max:255 | 住所1 |
| street2 | text | - | max:255 | 住所2 |
| city | text | - | max:255 | 市区町村 |
| zip | text | - | max:255 | 郵便番号 |
| country_id | select | - | - | 国 |
| state_id | select | - | - | 都道府県/州 |
| user_id | select | - | - | 営業担当 |
| property_payment_term_id | select | - | - | 支払条件 |
| property_inbound_payment_method_line_id | select | - | - | 支払方法（入金） |
| property_supplier_payment_term_id | select | - | - | 仕入先支払条件 |
| property_outbound_payment_method_line_id | select | - | - | 支払方法（出金） |
| property_account_position_id | select | - | - | 財務ポジション |
| invoice_sending_method | select | - | - | 請求書送付方法 |
| invoice_edi_format_store | select | - | - | EDIフォーマット |
| peppol_eas | select | - | - | PEPPOL EAS |
| peppol_endpoint | text | - | - | PEPPOLエンドポイント |
| autopost_bills | select | - | - | 自動転記設定 |
| ignore_abnormal_invoice_amount | toggle | - | - | 異常金額無視 |
| ignore_abnormal_invoice_date | toggle | - | - | 異常日付無視 |
| comment | richtext | - | - | 内部メモ |

## イベント仕様

### 1-新規作成ボタン押下

CreateActionにより新規仕入先作成画面に遷移します。sub_typeは自動的にsupplierに設定されます。

### 2-カードクリック

詳細画面または編集画面へ遷移します。

### 3-行アクション

- **表示**：ViewAction - 詳細画面へ遷移（ソフトデリートされていない場合のみ表示）
- **編集**：EditAction - 編集画面へ遷移（ソフトデリートされていない場合のみ表示）
- **復元**：RestoreAction - ソフトデリートからの復元
- **削除**：DeleteAction - ソフトデリート
- **完全削除**：ForceDeleteAction - データベースから完全削除

### 4-一括アクション

- **一括復元**：RestoreBulkAction
- **一括削除**：DeleteBulkAction
- **一括完全削除**：ForceDeleteBulkAction

### 5-国選択変更時

国を変更すると、state_idがnullにリセットされ、選択した国に属する都道府県/州のみが選択可能になります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | partners | UPDATE | ソフトデリート（deleted_at設定） |
| 完全削除ボタン押下 | partners | DELETE | 仕入先レコードの完全削除 |
| 復元ボタン押下 | partners | UPDATE | ソフトデリート解除（deleted_at null） |

### テーブル別更新項目詳細

#### partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE (soft) | deleted_at | 現在日時 | ソフトデリート |
| DELETE (force) | - | WHERE id = {選択レコードID} | 完全削除 |
| RESTORE | deleted_at | NULL | 復元 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| edit.notification.title | 成功 | 編集が完了しました | 編集成功時 |
| edit.notification.body | 成功 | レコードが正常に更新されました | 編集成功時 |
| restore.notification.title | 成功 | 復元が完了しました | 復元成功時 |
| restore.notification.body | 成功 | レコードが正常に復元されました | 復元成功時 |
| delete.notification.title | 成功 | 削除が完了しました | 削除成功時 |
| delete.notification.body | 成功 | レコードが正常に削除されました | 削除成功時 |
| force-delete.notification.success.title | 成功 | 完全削除が完了しました | 完全削除成功時 |
| force-delete.notification.success.body | 成功 | レコードが完全に削除されました | 完全削除成功時 |
| force-delete.notification.error.title | エラー | 完全削除に失敗しました | 関連データ存在時 |
| force-delete.notification.error.body | エラー | 関連するデータが存在するため削除できません | 関連データ存在時 |

## 例外処理

| 例外条件 | 対応処理 | 表示メッセージ |
|---------|---------|--------------|
| データが見つからない | 空の一覧を表示 | - |
| 完全削除時に関連データ存在 | 操作をキャンセル | force-delete.notification.error |
| メールアドレス重複 | バリデーションエラー | メールアドレスは既に使用されています |

## 備考

- 本画面はBaseVendorResource（PartnerResource）を継承しており、パートナー管理の基本機能を継承しています
- sub_type = 'supplier' でフィルタリングされ、仕入先のみが表示されます
- カード形式のグリッドレイアウトで表示（sm: 1列、md: 2列、xl/2xl: 3列）
- ソフトデリート機能をサポートしており、削除したレコードを復元可能です
- 請求書タブでEDI形式（PEPPOL等）の設定が可能です
- 自動転記設定により、請求書の自動処理が設定可能です
