# 画面設計書 193-顧客請求書一覧

## 概要

本ドキュメントは、Invoices（請求書）モジュールにおける顧客請求書一覧画面（ListInvoices）の設計仕様を記載するものです。顧客への請求書を一覧表示し、請求書の管理・追跡を行う画面です。

### 本画面の処理概要

**業務上の目的・背景**：顧客への請求書を一元管理し、売上管理・売掛金管理を効率化するために必要な画面です。請求書のステータス管理、支払状況の追跡が可能です。

**画面へのアクセス方法**：メインナビゲーションから「請求書」モジュールを選択し、「顧客」クラスター内の「請求書」メニューをクリックしてアクセスします。URLは `/invoices/customer/invoices` です。

**主要な操作・処理内容**：
1. 顧客請求書データの一覧表示と検索
2. プリセットビューによる請求書データのフィルタリング（請求書、下書き、転記済み、キャンセル済み、未保護、返金、確認待ち、支払待ち、支払中、期限超過）
3. 請求書レコードの詳細表示・編集・削除
4. 新規請求書の作成
5. 一括削除操作

**画面遷移**：
- この画面から遷移できる画面：顧客請求書作成画面、顧客請求書編集画面、顧客請求書詳細画面
- この画面に遷移してくる画面：顧客モジュールのメニュー、ダッシュボード

**権限による表示制御**：請求書モジュールへのアクセス権限を持つユーザーのみが表示可能です。編集・削除には追加の権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-CU-001 | 顧客請求書一覧 | 主機能 | 請求書データの一覧表示 |
| FN-ACC-001 | 請求書一覧 | API連携 | 会計モジュールの請求書リソース継承 |

## 画面種別

一覧

## URL/ルーティング

`/invoices/customer/invoices`

## 画面構成

- **ヘッダーアクション**：新規作成ボタン（CreateAction）
- **プリセットビュー**：請求書（デフォルト・お気に入り）、下書き（お気に入り）、転記済み（お気に入り）、キャンセル済み（お気に入り）、未保護（お気に入り）、返金、確認待ち、支払待ち、支払中、期限超過
- **テーブル**：請求書データ一覧
- **フィルター**：番号、請求書元、参照、パートナー名、請求日、支払期限、作成日、更新日
- **グループ化**：名前、パートナー名、請求日、確認済み、日付、支払期限、請求元、担当者、通貨、作成日、更新日

## 表示項目

| 項目名 | 表示形式 | ソート | 検索 | 説明 |
|--------|----------|--------|------|------|
| name | テキスト | 可 | 可 | 請求書番号 |
| state | バッジ | 可 | - | ステータス（下書き/転記済み/キャンセル） |
| invoice_partner_display_name | テキスト | 可 | 可 | 顧客名 |
| invoice_date | 日付 | 可 | - | 請求日 |
| invoice_date_due | 日付 | 可 | - | 支払期限 |
| amount_untaxed_in_currency_signed | 通貨 | 可 | 可 | 税抜金額 |
| amount_tax_signed | 通貨 | 可 | 可 | 税額 |
| amount_total_in_currency_signed | 通貨 | 可 | 可 | 合計金額 |
| amount_residual_signed | 通貨 | 可 | 可 | 残高 |
| payment_state | バッジ | 可 | 可 | 支払状態（未払/一部支払/支払済み等） |
| checked | アイコン | 可 | - | 確認済み（デフォルト非表示） |
| date | 日付 | 可 | 可 | 会計日（デフォルト非表示） |
| invoice_origin | テキスト | 可 | 可 | 元伝票（デフォルト非表示） |
| reference | テキスト | 可 | 可 | 参照（デフォルト非表示） |
| invoiceUser.name | テキスト | 可 | 可 | 担当者（デフォルト非表示） |
| currency.name | テキスト | 可 | 可 | 通貨（デフォルト非表示） |

## イベント仕様

### 1-プリセットビュー切替

プリセットビューを切り替えると、データに対してフィルタリングが適用されます。デフォルトではmove_typeがOUT_INVOICEの請求書が表示されます。

### 2-新規作成ボタン押下

CreateActionにより新規請求書作成画面に遷移します。

### 3-行アクション

- **表示**：ViewActionで詳細画面へ遷移
- **編集**：EditActionで編集画面へ遷移
- **削除**：DeleteActionで削除（確認ダイアログあり）

### 4-一括削除

DeleteBulkActionにより選択した複数の請求書を一括削除します。

## プリセットビュー詳細

| ビュー名 | アイコン | フィルタ条件 | お気に入り |
|---------|---------|-------------|----------|
| 請求書 | heroicon-s-receipt-percent | move_type = OUT_INVOICE | デフォルト、お気に入り |
| 下書き | heroicon-s-stop | state = DRAFT | お気に入り |
| 転記済み | heroicon-s-play | state = POSTED | お気に入り |
| キャンセル済み | heroicon-s-x-circle | state = CANCEL | お気に入り |
| 未保護 | heroicon-s-shield-exclamation | inalterable_hash IS NOT NULL | お気に入り |
| 返金 | heroicon-s-receipt-refund | move_type = IN_REFUND | - |
| 確認待ち | heroicon-s-check-badge | state != DRAFT AND checked = false | - |
| 支払待ち | heroicon-s-banknotes | state != POSTED AND payment_state IN (NOT_PAID, PARTIAL) | - |
| 支払中 | heroicon-s-banknotes | state != POSTED AND payment_state = IN_PAYMENT | - |
| 期限超過 | heroicon-s-banknotes | state != POSTED AND payment_state = NOT_PAID AND invoice_date_due < now() | - |

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | account_moves | DELETE | 請求書レコードの削除 |
| 一括削除 | account_moves | DELETE | 複数請求書レコードの削除 |

### テーブル別更新項目詳細

#### account_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = {選択レコードID} | 請求書削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| delete.success.title | 成功 | 削除が完了しました | 削除成功時 |
| delete.success.body | 成功 | レコードが正常に削除されました | 削除成功時 |
| bulk-delete.success.title | 成功 | 一括削除が完了しました | 一括削除成功時 |
| bulk-delete.success.body | 成功 | 選択したレコードが正常に削除されました | 一括削除成功時 |

## 例外処理

| 例外条件 | 対応処理 | 表示メッセージ |
|---------|---------|--------------|
| データが見つからない | 空の一覧を表示 | - |
| 削除権限不足 | 操作を拒否 | 権限がありません |
| 転記済み請求書の削除 | 削除を拒否 | 転記済みの請求書は削除できません |

## 備考

- 本画面はBaseListInvoicesを継承しており、会計モジュールの請求書一覧の基本機能を継承しています
- HasTableViewsトレイトを使用してプリセットビュー機能を実装しています
- CustomerクラスターのInvoiceResourceを使用し、顧客向けの請求書（OUT_INVOICE）がデフォルトで表示されます
