# 画面設計書 194-顧客請求書作成

## 概要

本ドキュメントは、Invoices（請求書）モジュールにおける顧客請求書作成画面（CreateInvoice）の設計仕様を記載するものです。新規の顧客請求書を作成するための入力画面です。

### 本画面の処理概要

**業務上の目的・背景**：顧客への新規請求書を作成し、売上を記録するために必要な画面です。商品・サービスの明細、税金、支払条件などを設定できます。

**画面へのアクセス方法**：顧客請求書一覧画面から「新規作成」ボタンをクリックしてアクセスします。URLは `/invoices/customer/invoices/create` です。

**主要な操作・処理内容**：
1. 請求書基本情報の入力（顧客、請求日、支払期限等）
2. 明細行の追加・編集（商品、数量、単価、税金等）
3. 請求書の保存
4. 保存後は詳細画面へ自動遷移

**画面遷移**：
- この画面から遷移できる画面：顧客請求書詳細画面（保存後）、顧客請求書一覧画面（キャンセル時）
- この画面に遷移してくる画面：顧客請求書一覧画面

**権限による表示制御**：請求書作成権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-CU-002 | 顧客請求書作成 | 主機能 | 請求書の新規作成 |
| FN-ACC-002 | 請求書作成 | API連携 | 会計モジュールの請求書作成機能継承 |

## 画面種別

作成

## URL/ルーティング

`/invoices/customer/invoices/create`

## 画面構成

- **サブナビゲーション**：クラスターコンポーネント
- **フォーム**：請求書情報入力フォーム
- **明細リピーター**：商品明細入力

## フォーム項目

| 項目名 | 型 | 必須 | バリデーション | 説明 |
|--------|-----|------|---------------|------|
| partner_id | select | - | - | 顧客（パートナー） |
| partner_shipping_id | select | - | - | 配送先 |
| reference | text | - | max:255 | 参照/支払参照 |
| invoice_date | date | - | - | 請求日 |
| invoice_date_due | date | - | - | 支払期限 |
| invoice_payment_term_id | select | - | - | 支払条件 |
| journal_id | select | 是 | - | 仕訳帳 |
| currency_id | select | 是 | - | 通貨 |
| invoice_user_id | select | - | - | 担当者 |
| narration | richtext | - | - | 備考/利用規約 |
| products | repeater | - | - | 商品明細 |

### 商品明細（products）の項目

| 項目名 | 型 | 必須 | バリデーション | 説明 |
|--------|-----|------|---------------|------|
| product_id | select | - | - | 商品 |
| name | text | 是 | max:255 | 説明/ラベル |
| account_id | select | 是 | - | 勘定科目 |
| quantity | number | - | min:0 | 数量 |
| product_uom_id | select | - | - | 単位 |
| price_unit | number | - | min:0 | 単価 |
| discount | number | - | min:0, max:100 | 割引率 |
| tax_ids | select | - | multiple | 税金 |

## イベント仕様

### 1-顧客選択変更時

顧客を変更すると、以下の項目が自動的に設定されます：
- 配送先（partner_shipping_id）
- 支払条件（propertyPaymentTerm）
- デフォルトの税金設定

### 2-商品選択変更時

商品を選択すると、以下の項目が自動的に設定されます：
- 説明（商品名）
- 勘定科目（商品カテゴリから）
- 単価（商品価格から）
- 単位（商品のデフォルト単位から）

### 3-支払条件選択時

支払条件を選択すると、支払期限が自動計算されます。

### 4-保存ボタン押下

請求書を保存し、以下の処理を実行します：
1. move_typeにOUT_INVOICEを設定
2. dateに現在日時を設定
3. Account::computeAccountMove()で金額計算を実行
4. 保存成功後、詳細画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | account_moves | INSERT | 請求書ヘッダーの作成 |
| 保存ボタン押下 | account_move_lines | INSERT | 請求書明細の作成 |
| 保存ボタン押下 | account_move_line_taxes | INSERT | 明細行の税金関連 |

### テーブル別更新項目詳細

#### account_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | move_type | 'out_invoice' | 顧客請求書 |
| INSERT | state | 'draft' | 下書き状態 |
| INSERT | date | now() | 現在日時 |
| INSERT | partner_id | フォーム入力値 | 顧客ID |
| INSERT | invoice_date | フォーム入力値 | 請求日 |
| INSERT | invoice_date_due | フォーム入力値 | 支払期限 |
| INSERT | journal_id | フォーム入力値 | 仕訳帳ID |
| INSERT | currency_id | フォーム入力値 | 通貨ID |
| INSERT | company_id | Auth::user()->company_id | 会社ID |
| INSERT | creator_id | Auth::user()->id | 作成者ID |

#### account_move_lines

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | move_id | 親レコードID | 請求書ID |
| INSERT | product_id | フォーム入力値 | 商品ID |
| INSERT | name | フォーム入力値 | 説明 |
| INSERT | account_id | フォーム入力値 | 勘定科目ID |
| INSERT | quantity | フォーム入力値 | 数量 |
| INSERT | price_unit | フォーム入力値 | 単価 |
| INSERT | discount | フォーム入力値 | 割引率 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| notification.title | 成功 | 請求書が作成されました | 保存成功時 |
| notification.body | 成功 | 請求書が正常に作成されました | 保存成功時 |

## 例外処理

| 例外条件 | 対応処理 | 表示メッセージ |
|---------|---------|--------------|
| 必須項目未入力 | 保存を拒否 | 必須項目を入力してください |
| バリデーションエラー | 該当フィールドにエラー表示 | 各フィールドのエラーメッセージ |
| データベースエラー | 保存を拒否 | 保存中にエラーが発生しました |

## 備考

- 本画面はBaseCreateInvoiceを継承しており、会計モジュールの請求書作成機能を継承しています
- HasRepeaterColumnManagerトレイトを使用して、明細行のカラム管理機能を実装しています
- 保存後は自動的に詳細画面にリダイレクトされます
- move_typeは自動的にOUT_INVOICE（顧客請求書）に設定されます
- 金額計算はAccount::computeAccountMove()で自動実行されます
