# 画面設計書 195-顧客請求書編集

## 概要

本ドキュメントは、Invoices（請求書）モジュールにおける顧客請求書編集画面（EditInvoice）の設計仕様を記載するものです。既存の顧客請求書を編集するための入力画面です。

### 本画面の処理概要

**業務上の目的・背景**：既存の顧客請求書を修正・更新するために必要な画面です。下書き状態の請求書の内容変更、転記、確認マーク設定、支払登録などの操作が可能です。

**画面へのアクセス方法**：顧客請求書一覧画面または詳細画面から「編集」ボタンをクリックしてアクセスします。URLは `/invoices/customer/invoices/{record}/edit` です。

**主要な操作・処理内容**：
1. 請求書基本情報の編集
2. 明細行の追加・編集・削除
3. 請求書の転記（確認）
4. 支払登録
5. キャンセル処理
6. 下書きへのリセット
7. 確認済みマークの設定
8. プレビュー表示
9. 印刷・送信
10. クレジットノート作成
11. 請求書の削除
12. コメント・アクティビティ管理（Chatter）

**画面遷移**：
- この画面から遷移できる画面：顧客請求書詳細画面（保存後）、支払登録モーダル、クレジットノート作成画面、プレビュー画面
- この画面に遷移してくる画面：顧客請求書一覧画面、顧客請求書詳細画面

**権限による表示制御**：請求書編集権限を持つユーザーのみがアクセス可能です。ステータスによって一部のアクションが制限されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-CU-003 | 顧客請求書編集 | 主機能 | 請求書の編集 |
| FN-ACC-003 | 請求書編集 | API連携 | 会計モジュールの請求書編集機能継承 |
| FN-ACC-PAY | 支払登録 | 関連機能 | PayAction |
| FN-ACC-CNF | 請求書確認 | 関連機能 | ConfirmAction |

## 画面種別

編集

## URL/ルーティング

`/invoices/customer/invoices/{record}/edit`

## 画面構成

- **ヘッダーアクション**：
  - ChatterAction（コメント・アクティビティ）
  - PayAction（支払登録）
  - ConfirmAction（転記）
  - CancelAction（キャンセル）
  - ResetToDraftAction（下書きにリセット）
  - SetAsCheckedAction（確認済みにする）
  - PreviewAction（プレビュー）
  - PrintAndSendAction（印刷・送信）
  - CreditNoteAction（クレジットノート作成）
  - DeleteAction（削除）
- **レコードナビゲーション**：前後のレコードへの移動
- **フォーム**：請求書情報編集フォーム
- **明細リピーター**：商品明細編集

## フォーム項目

（作成画面と同一のフォーム項目を使用）

| 項目名 | 型 | 必須 | バリデーション | 説明 |
|--------|-----|------|---------------|------|
| partner_id | select | - | - | 顧客（パートナー） |
| partner_shipping_id | select | - | - | 配送先 |
| reference | text | - | max:255 | 参照/支払参照 |
| invoice_date | date | - | - | 請求日 |
| invoice_date_due | date | - | - | 支払期限 |
| invoice_payment_term_id | select | - | - | 支払条件 |
| journal_id | select | 是 | - | 仕訳帳 |
| currency_id | select | 是 | - | 通貨 |
| invoice_user_id | select | - | - | 担当者 |
| narration | richtext | - | - | 備考/利用規約 |
| products | repeater | - | - | 商品明細 |

## ヘッダーアクション詳細

| アクション名 | 条件 | 説明 |
|-------------|------|------|
| ChatterAction | 常時表示 | コメント・アクティビティパネル表示 |
| PayAction | 転記済み、未払い | 支払登録モーダル表示 |
| ConfirmAction | 下書き状態 | 請求書を転記 |
| CancelAction | 転記済み | 請求書をキャンセル |
| ResetToDraftAction | キャンセル済み | 下書きに戻す |
| SetAsCheckedAction | 転記済み、未確認 | 確認済みにマーク |
| PreviewAction | 常時表示 | プレビュー画面表示 |
| PrintAndSendAction | 転記済み | 印刷・送信処理 |
| CreditNoteAction | 転記済み | クレジットノート作成 |
| DeleteAction | 下書き/キャンセル | 請求書削除 |

## イベント仕様

### 1-保存ボタン押下

以下の処理を実行します：
1. partner_idがない場合は既存値を維持
2. invoice_dateがない場合は既存値を維持
3. nameがない場合は既存値を維持
4. auto_postがない場合は既存値を維持
5. invoice_currency_rateがない場合は1.0を設定
6. partner_idがある場合、commercial_partner_id、partner_shipping_id、invoice_partner_display_nameを設定
7. partner_idがない場合、invoice_partner_display_nameに作成者名を設定
8. Account::computeAccountMove()で金額計算を実行
9. 保存成功後、詳細画面へリダイレクト

### 2-ConfirmAction押下

請求書を「転記済み」状態に変更し、請求書番号を確定します。

### 3-PayAction押下

支払登録モーダルを表示し、支払情報を登録します。

### 4-CancelAction押下

請求書を「キャンセル」状態に変更します。

### 5-ResetToDraftAction押下

キャンセル済みの請求書を「下書き」状態に戻します。

### 6-CreditNoteAction押下

現在の請求書から反転したクレジットノートを作成します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | account_moves | UPDATE | 請求書ヘッダーの更新 |
| 保存ボタン押下 | account_move_lines | UPDATE/INSERT/DELETE | 請求書明細の更新 |
| ConfirmAction | account_moves | UPDATE | state='posted'に更新 |
| CancelAction | account_moves | UPDATE | state='cancel'に更新 |
| ResetToDraftAction | account_moves | UPDATE | state='draft'に更新 |
| DeleteAction | account_moves | DELETE | 請求書削除 |

### テーブル別更新項目詳細

#### account_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | partner_id | フォーム入力値または既存値 | 顧客ID |
| UPDATE | invoice_date | フォーム入力値または既存値 | 請求日 |
| UPDATE | invoice_date_due | フォーム入力値 | 支払期限 |
| UPDATE | commercial_partner_id | partner.id | 取引先ID |
| UPDATE | partner_shipping_id | partner.id | 配送先ID |
| UPDATE | invoice_partner_display_name | partner.name | 表示名 |
| UPDATE | invoice_currency_rate | フォーム入力値または1.0 | 為替レート |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| notification.title | 成功 | 請求書が更新されました | 保存成功時 |
| notification.body | 成功 | 請求書が正常に更新されました | 保存成功時 |

## 例外処理

| 例外条件 | 対応処理 | 表示メッセージ |
|---------|---------|--------------|
| 転記済み請求書の編集 | 一部項目の編集制限 | - |
| 必須項目未入力 | 保存を拒否 | 必須項目を入力してください |
| 権限不足 | 操作を拒否 | 権限がありません |

## 備考

- 本画面はBaseEditInvoiceを継承しており、会計モジュールの請求書編集機能を継承しています
- HasRecordNavigationTabsトレイトを使用して、レコード間のナビゲーション機能を実装しています
- HasRepeaterColumnManagerトレイトを使用して、明細行のカラム管理機能を実装しています
- 保存後は自動的に詳細画面にリダイレクトされます
- 転記済みの請求書は一部の編集が制限されます
- ChatterActionによりコメントやアクティビティの管理が可能です
