# 画面設計書 196-顧客請求書詳細

## 概要

本ドキュメントは、Invoices（請求書）モジュールにおける顧客請求書詳細画面（ViewInvoice）の設計仕様を記載するものです。顧客請求書の詳細情報を表示し、各種アクションを実行するための画面です。

### 本画面の処理概要

**業務上の目的・背景**：顧客請求書の詳細情報を確認し、転記、支払登録、キャンセルなどの操作を実行するために必要な画面です。請求書のステータス、金額、明細などを一覧で確認できます。

**画面へのアクセス方法**：顧客請求書一覧画面から特定の請求書をクリック、または作成・編集後に自動遷移します。URLは `/invoices/customer/invoices/{record}` です。

**主要な操作・処理内容**：
1. 請求書基本情報の表示
2. 明細行の表示
3. 請求書の転記（確認）
4. 支払登録
5. キャンセル処理
6. 下書きへのリセット
7. 確認済みマークの設定
8. プレビュー表示
9. 印刷・送信
10. クレジットノート作成
11. 請求書の削除
12. コメント・アクティビティ管理（Chatter）

**画面遷移**：
- この画面から遷移できる画面：顧客請求書編集画面、支払登録モーダル、クレジットノート作成画面、プレビュー画面
- この画面に遷移してくる画面：顧客請求書一覧画面、顧客請求書作成画面、顧客請求書編集画面

**権限による表示制御**：請求書閲覧権限を持つユーザーがアクセス可能です。アクション実行には追加の権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-CU-004 | 顧客請求書詳細 | 主機能 | 請求書情報の表示 |
| FN-ACC-004 | 請求書詳細 | API連携 | 会計モジュールの請求書詳細機能継承 |

## 画面種別

詳細

## URL/ルーティング

`/invoices/customer/invoices/{record}`

## 画面構成

- **ヘッダーアクション**：
  - ChatterAction（コメント・アクティビティ）
  - PayAction（支払登録）
  - ConfirmAction（転記）
  - CancelAction（キャンセル）
  - ResetToDraftAction（下書きにリセット）
  - SetAsCheckedAction（確認済みにする）
  - PreviewAction（プレビュー）
  - PrintAndSendAction（印刷・送信）
  - CreditNoteAction（クレジットノート作成）
  - DeleteAction（削除）
- **レコードナビゲーション**：前後のレコードへの移動
- **情報リスト**：請求書詳細情報の表示
- **明細エントリ**：商品明細の表示

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| name | テキスト | 請求書番号 |
| state | バッジ | ステータス（下書き/転記済み/キャンセル） |
| partner_id | テキスト | 顧客名 |
| partner_shipping_id | テキスト | 配送先 |
| reference | テキスト | 参照/支払参照 |
| invoice_date | 日付 | 請求日 |
| invoice_date_due | 日付 | 支払期限 |
| invoice_payment_term_id | テキスト | 支払条件 |
| journal_id | テキスト | 仕訳帳 |
| currency_id | テキスト | 通貨 |
| invoice_user_id | テキスト | 担当者 |
| narration | HTML | 備考/利用規約 |
| amount_untaxed | 通貨 | 税抜金額 |
| amount_tax | 通貨 | 税額 |
| amount_total | 通貨 | 合計金額 |
| amount_residual | 通貨 | 残高 |
| payment_state | バッジ | 支払状態 |

### 明細表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| product_id | テキスト | 商品名 |
| name | テキスト | 説明 |
| account_id | テキスト | 勘定科目 |
| quantity | 数値 | 数量 |
| product_uom_id | テキスト | 単位 |
| price_unit | 通貨 | 単価 |
| discount | パーセント | 割引率 |
| tax_ids | テキスト | 税金 |
| price_subtotal | 通貨 | 小計 |
| price_total | 通貨 | 合計 |

## ヘッダーアクション詳細

| アクション名 | 条件 | 説明 |
|-------------|------|------|
| ChatterAction | 常時表示 | コメント・アクティビティパネル表示 |
| PayAction | 転記済み、未払い | 支払登録モーダル表示 |
| ConfirmAction | 下書き状態 | 請求書を転記 |
| CancelAction | 転記済み | 請求書をキャンセル |
| ResetToDraftAction | キャンセル済み | 下書きに戻す |
| SetAsCheckedAction | 転記済み、未確認 | 確認済みにマーク |
| PreviewAction | 常時表示 | プレビュー画面表示 |
| PrintAndSendAction | 転記済み | 印刷・送信処理 |
| CreditNoteAction | 転記済み | クレジットノート作成 |
| DeleteAction | 下書き/キャンセル | 請求書削除 |

## イベント仕様

### 1-ConfirmAction押下

請求書を「転記済み」状態に変更し、請求書番号を確定します。

### 2-PayAction押下

支払登録モーダルを表示し、支払情報を登録します。

### 3-CancelAction押下

請求書を「キャンセル」状態に変更します。

### 4-ResetToDraftAction押下

キャンセル済みの請求書を「下書き」状態に戻します。

### 5-CreditNoteAction押下

現在の請求書から反転したクレジットノートを作成します。

### 6-DeleteAction押下

請求書を削除します（下書きまたはキャンセル済みの場合のみ）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ConfirmAction | account_moves | UPDATE | state='posted'に更新 |
| CancelAction | account_moves | UPDATE | state='cancel'に更新 |
| ResetToDraftAction | account_moves | UPDATE | state='draft'に更新 |
| SetAsCheckedAction | account_moves | UPDATE | checked=trueに更新 |
| DeleteAction | account_moves | DELETE | 請求書削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| delete.notification.title | 成功 | 請求書が削除されました | 削除成功時 |
| delete.notification.body | 成功 | 請求書が正常に削除されました | 削除成功時 |

## 例外処理

| 例外条件 | 対応処理 | 表示メッセージ |
|---------|---------|--------------|
| レコードが見つからない | 404エラー | 請求書が見つかりません |
| 権限不足 | 操作を拒否 | 権限がありません |

## 備考

- 本画面はBaseViewInvoiceを継承しており、会計モジュールの請求書詳細機能を継承しています
- HasRecordNavigationTabsトレイトを使用して、レコード間のナビゲーション機能を実装しています
- HasRepeatableEntryColumnManagerトレイトを使用して、明細行のカラム管理機能を実装しています
- プレビューテンプレートは `accounts::invoice/actions/preview.index` を使用します
- ChatterActionによりコメントやアクティビティの管理が可能です
